set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9813353';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1.601579,
      2,
      3,
      0.090648,
      1.044174,
      2,
      '100',
      '41321203',
      NULL,
      47.668599,
      '1423323',
      NULL,
      0.044783,
      2,
      NULL,
      '1322',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 2-1988',
      8,
      NULL,
      NULL,
      2,
      1,
      ' 0-27-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.874544,
      1.431290,
      0.063448,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      4.078524,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      0,
      0,
      1,
      0.170757,
      0,
      0.126819,
      0,
      1,
      1.366265,
      1.153745,
      0.737214,
      1,
      4,
      6,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      1,
      1.813219,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      0.422988,
      3,
      1,
      1.074391,
      3,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0.575766,
      1.372430,
      1.950299,
      0,
      1,
      1,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      1.586518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0.448623,
      NULL,
      0.391026,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      3,
      2,
      0,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      3.352347,
      ' 0-15-1993',
      66,
      NULL,
      381.484548,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      1.059307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1.472803,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.632264,
      1.937866,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.347835,
      1,
      0.299761,
      0.887853,
      NULL,
      NULL,
      3.426286,
      1.705590,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      2,
      NULL,
      3,
      2,
      NULL,
      1,
      2,
      1,
      2,
      NULL,
      NULL,
      1.480522,
      1,
      0.331319,
      0.182731,
      0,
      0,
      1,
      0.550789,
      NULL,
      NULL,
      1.955224,
      0,
      0,
      NULL,
      NULL,
      0,
      4.433077,
      2,
      3.738156,
      0,
      9.725094,
      2.466308,
      2,
      3.129064,
      4,
      0,
      1,
      0,
      35.000927,
      NULL,
      0.055119,
      5,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '02404',
      '14043',
      '',
      1.867011,
      '',
      '',
      '',
      0.931601,
      NULL,
      NULL,
      NULL,
      3.212306,
      14,
      101,
      11,
      NULL,
      11.458768,
      0.894379,
      21,
      NULL,
      NULL,
      3,
      2.627393,
      1.781395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.984130,
      NULL,
      NULL,
      2.648678,
      0.300763,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.394698,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.074908,
      1.356352,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.960765,
      0.440482,
      1.263538,
      0,
      1.564050,
      NULL,
      NULL,
      0,
      0.876264,
      1.294082,
      3,
      2.935534,
      1,
      0,
      1,
      1.141301,
      NULL,
      NULL,
      0.840492,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5.657166,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.134242,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.349320,
      NULL,
      NULL,
      1.815124,
      1,
      3.584446,
      NULL,
      NULL,
      NULL,
      9.388394,
      0.291877,
      NULL,
      1,
      NULL,
      NULL,
      0.406984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767007,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.044094,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.288040,
      NULL,
      NULL,
      3,
      3,
      2.828720,
      0.339893,
      0.763363,
      1,
      1.754706,
      NULL,
      NULL,
      NULL,
      7.598106,
      7,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.461558,
      0.917549,
      2,
      1,
      NULL,
      NULL,
      5,
      3.677758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.241444,
      0,
      0.721773,
      0.712675,
      2.840624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255594,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.473701,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220347,
      1.231385,
      0.296208,
      0.999985,
      0,
      2.469764,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.309028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980234,
      NULL,
      NULL,
      NULL,
      1.190356,
      NULL,
      NULL,
      NULL,
      1.617825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      16.930167,
      10,
      1,
      37,
      NULL,
      1.661005,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.532569,
      NULL,
      NULL,
      1,
      NULL,
      1.889447,
      170.535061,
      1.787157,
      NULL,
      0,
      0.864556,
      NULL,
      0,
      0.960035,
      0.709640,
      NULL,
      1,
      1,
      0,
      0.420241,
      0,
      0.495989,
      1.406358,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      7.680961,
      3.224962,
      0,
      0,
      1.656323,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.058545,
      0,
      NULL,
      NULL,
      1.895114,
      NULL,
      0.827942,
      NULL,
      NULL,
      0,
      0.538364,
      NULL,
      0.868864,
      1.017484,
      NULL,
      0,
      1,
      NULL,
      0.960878,
      2,
      NULL,
      0,
      0,
      0.406726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637259,
      NULL,
      NULL,
      NULL,
      1.530760,
      NULL,
      2,
      4,
      0,
      0,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      4,
      NULL,
      '32013',
      '32131',
      '04401',
      1,
      '12440',
      '',
      '',
      1.557532,
      '',
      '',
      '');
commit;
end;
/


