set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916164';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '2310344',
      2.828537,
      0.144389,
      2,
      3,
      '3103',
      3.220287,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 9-26-1980',
      NULL,
      3,
      244.312986,
      NULL,
      0,
      NULL,
      ' 2-21-1996',
      ' 2-18-1985',
      1,
      1.053130,
      NULL,
      0.013329,
      1.491304,
      2.710703,
      7,
      0,
      0,
      1586.947343,
      3,
      13,
      6.722577,
      141,
      192,
      NULL,
      22.512695,
      2,
      NULL,
      2.242254,
      1.176597,
      0,
      1,
      0.905759,
      1.180221,
      0,
      1,
      0.794909,
      0.848958,
      1,
      NULL,
      6,
      0,
      1,
      2,
      5,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      3,
      NULL,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      0.389181,
      0,
      0.861419,
      0,
      1.568473,
      NULL,
      0.341708,
      1.477542,
      1,
      0.760504,
      1.670187,
      1.859966,
      1,
      0,
      1.584845,
      NULL,
      0.932500,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      3,
      1,
      5,
      1,
      0,
      0,
      0,
      1,
      0,
      2.321982,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      5,
      NULL,
      0,
      1,
      1,
      4,
      1,
      5,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      5,
      NULL,
      NULL,
      3,
      3,
      NULL,
      4,
      4,
      3,
      2,
      1,
      3.884664,
      ' 3-24-1997',
      693,
      ' 5-10-1991',
      NULL,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.060120,
      0,
      2,
      3,
      2.896047,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158826,
      NULL,
      0,
      NULL,
      1,
      0,
      0.185781,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125272,
      3,
      6,
      1,
      NULL,
      1.242338,
      0,
      NULL,
      1,
      3.681463,
      2.470035,
      3.506221,
      NULL,
      30.886567,
      0,
      1.367281,
      NULL,
      8,
      22,
      26.340249,
      2,
      1,
      NULL,
      '34211',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      5.492801,
      '2111',
      '3421',
      NULL,
      0,
      10.836394,
      NULL,
      0.067060,
      NULL,
      10,
      15.024833,
      236,
      2,
      0,
      0.153786,
      3,
      1.345302,
      NULL,
      NULL,
      3.604228,
      0.818357,
      0,
      2,
      0.106729,
      0.082163,
      0.582262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.683314,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486444,
      1,
      0.075074,
      NULL,
      NULL,
      NULL,
      3.187288,
      3,
      NULL,
      2,
      3.276048,
      2.275109,
      1.680063,
      3.805105,
      3.324745,
      NULL,
      1,
      NULL,
      NULL,
      0.298189,
      1,
      1,
      1.781908,
      0.206729,
      0.435193,
      NULL,
      3,
      1.231475,
      NULL,
      NULL,
      0.199199,
      0,
      1.545419,
      NULL,
      0,
      1.628877,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.654966,
      1,
      0.201661,
      NULL,
      NULL,
      NULL,
      1.190190,
      2.013371,
      0.877033,
      1,
      0,
      NULL,
      NULL,
      0.809809,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.520126,
      1.409158,
      3.061464,
      1.030930,
      1,
      NULL,
      1,
      NULL,
      0.958098,
      1.478030,
      0.786941,
      0.786449,
      NULL,
      0.992604,
      0,
      0.553800,
      0,
      3,
      12,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      3,
      1.090507,
      3.169173,
      NULL,
      NULL,
      NULL,
      1,
      9,
      NULL,
      3,
      2.816136,
      NULL,
      2,
      2,
      3,
      3.810146,
      7,
      NULL,
      NULL,
      9,
      0.153624,
      0.616793,
      NULL,
      3.135716,
      3.028412,
      NULL,
      0,
      3.684016,
      NULL,
      NULL,
      NULL,
      3.310756,
      1,
      5.063195,
      6.013757,
      1,
      1.343034,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      3,
      1.129434,
      1.594658,
      NULL,
      1,
      4.136597,
      0.565748,
      6,
      6,
      2.568350,
      6,
      NULL,
      3,
      4,
      1,
      1,
      0.331769,
      0,
      1.716791,
      0.749212,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612134,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.307796,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.239940,
      1.410969,
      0,
      1,
      3.129643,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.251717,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.334416,
      3.004269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.311133,
      0,
      NULL,
      NULL,
      1,
      1.494478,
      NULL,
      NULL,
      NULL,
      0.068569,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.014576,
      NULL,
      NULL,
      1,
      6.667667,
      NULL,
      NULL,
      1.208687,
      NULL,
      NULL,
      NULL,
      1,
      211,
      202.951456,
      1,
      NULL,
      NULL,
      0.653788,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.582425,
      589,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.583868,
      NULL,
      1631,
      1,
      1.872023,
      0,
      1,
      0.895333,
      1,
      1.033161,
      1.560003,
      1,
      1.232452,
      1,
      1,
      0.870332,
      1.225027,
      0,
      0.894532,
      1.644464,
      0.219325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      7.070692,
      2.237690,
      4,
      1,
      3,
      0,
      0.985413,
      3.079775,
      1,
      0,
      3.536490,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.110968,
      1,
      0,
      NULL,
      2,
      2,
      1,
      2.079193,
      1,
      0,
      1,
      1,
      3,
      1.980429,
      0.030187,
      0,
      NULL,
      3,
      0,
      2.752137,
      3,
      NULL,
      1,
      0,
      3.578891,
      3.122165,
      NULL,
      NULL,
      2,
      2.200796,
      0.927511,
      NULL,
      3.713126,
      1,
      0.834218,
      1,
      0,
      0,
      1,
      0,
      2.651424,
      NULL,
      0.245745,
      3.450787,
      0,
      0.860345,
      NULL,
      1.624956,
      NULL,
      0,
      0.077004,
      1,
      1.083793,
      47,
      0.176892,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478796,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      5,
      7,
      NULL,
      0.598892,
      NULL,
      5.024118,
      30,
      2,
      1.316910,
      NULL,
      NULL,
      '12443',
      '04212',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '2304',
      '2222');
commit;
end;
/


