set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9528893';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '0201341',
      1.620674,
      0,
      1,
      3,
      '3301',
      NULL,
      1.629165,
      NULL,
      NULL,
      ' 2- 1-1991',
      12.484288,
      NULL,
      NULL,
      1,
      5,
      ' 9- 2-1998',
      29.439778,
      0.680176,
      NULL,
      56.841359,
      NULL,
      ' 1- 5-1975',
      ' 7-10-1980',
      ' 4-23-1988',
      0.147161,
      NULL,
      3.519246,
      2.198296,
      1.198844,
      3.595433,
      1,
      1.752114,
      0,
      NULL,
      0,
      1.584195,
      NULL,
      21,
      21.792069,
      NULL,
      5,
      2,
      0,
      2,
      1,
      2,
      1,
      1,
      1.989388,
      1,
      0,
      1,
      0.248004,
      0,
      NULL,
      3,
      NULL,
      1,
      1.938158,
      3,
      1,
      1,
      0,
      0,
      0,
      3,
      3,
      NULL,
      NULL,
      3,
      4,
      9,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      0.944874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3.284764,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.746940,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      1,
      6.624233,
      NULL,
      1,
      1,
      0,
      1.726167,
      NULL,
      1.806892,
      4,
      4,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      2,
      4,
      NULL,
      3,
      0,
      NULL,
      5,
      1,
      5,
      4,
      NULL,
      NULL,
      3,
      1.105924,
      NULL,
      1006.787428,
      ' 1- 3-2001',
      231.821210,
      1.260299,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1.842777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      311,
      1.683490,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.273298,
      0,
      1.385493,
      0.091967,
      1,
      1,
      NULL,
      1,
      1.783380,
      0,
      1,
      NULL,
      NULL,
      0,
      2.937123,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.328393,
      0.392822,
      3.340340,
      1,
      NULL,
      0,
      0,
      64.529019,
      0.831007,
      3.948649,
      32.946914,
      121.425857,
      85.404713,
      0,
      1.718828,
      NULL,
      3,
      2,
      1,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      1,
      1,
      2.908097,
      2,
      NULL,
      1.782803,
      0,
      9,
      1.311696,
      1.870229,
      1.989627,
      1,
      1,
      NULL,
      1.378312,
      0,
      1,
      NULL,
      NULL,
      1,
      5.642458,
      NULL,
      NULL,
      0,
      0.958516,
      1.315650,
      5.862575,
      2,
      4.031355,
      0.609666,
      NULL,
      0.305090,
      21,
      0,
      3,
      NULL,
      21,
      NULL,
      31.589909,
      4,
      4,
      1.465001,
      '21310',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      110.663709,
      NULL,
      1.045259,
      17,
      20.812930,
      1.650639,
      5,
      3.921372,
      2,
      1.621722,
      NULL,
      NULL,
      NULL,
      1.630031,
      3,
      0,
      NULL,
      3.283659,
      0,
      1,
      2.500273,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      2,
      1,
      NULL,
      2,
      NULL,
      2,
      1,
      1.296039,
      NULL,
      2.719423,
      0.023029,
      3,
      3.093496,
      2.976443,
      NULL,
      2.992003,
      3.586706,
      4.192045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648897,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.079796,
      NULL,
      NULL,
      0.634568,
      2.457052,
      0.517755,
      1,
      3,
      1.775954,
      0.451185,
      3,
      1,
      1.612942,
      3,
      NULL,
      1.879725,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.411659,
      1,
      1,
      1.018502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004834,
      3,
      0,
      2.236634,
      3,
      2,
      1,
      NULL,
      NULL,
      7,
      0.360175,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.280999,
      2,
      4,
      0.393715,
      NULL,
      NULL,
      1.387879,
      NULL,
      NULL,
      1.101227,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.403482,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.097578,
      0.813328,
      2,
      2.497820,
      4.331745,
      0,
      NULL,
      NULL,
      0.206727,
      1.955853,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.150261,
      1.078027,
      1,
      2.877238,
      0.186345,
      2,
      0,
      3,
      2,
      NULL,
      2.423871,
      2.838389,
      1.573872,
      0,
      NULL,
      NULL,
      1.185654,
      0.529806,
      NULL,
      1.854158,
      NULL,
      1,
      NULL,
      6.645084,
      5.541585,
      6,
      4.296707,
      NULL,
      NULL,
      1,
      4,
      0.153663,
      NULL,
      1.843102,
      0.921638,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.596064,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023154,
      NULL,
      NULL,
      3.859161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504932,
      NULL,
      NULL,
      1.672070,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.445007,
      NULL,
      NULL,
      1.556261,
      1.318030,
      2.616551,
      0,
      3.419681,
      3,
      1.503680,
      NULL,
      NULL,
      0.530179,
      NULL,
      NULL,
      43.494865,
      61.905883,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.452789,
      NULL,
      NULL,
      NULL,
      1.723784,
      NULL,
      NULL,
      NULL,
      2.088722,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3.391459,
      NULL,
      NULL,
      NULL,
      0.341604,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.699733,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824753,
      NULL,
      NULL,
      NULL,
      3.531925,
      3,
      NULL,
      NULL,
      1.655606,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      5.925364,
      4,
      NULL,
      NULL,
      1,
      1,
      2.321336,
      3,
      1,
      3,
      294,
      231.745100,
      3,
      60.335389,
      1,
      NULL,
      NULL,
      NULL,
      0.843437,
      12.999333,
      3.913794,
      1.213875,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751991,
      NULL,
      0,
      0,
      0.849514,
      0.366517,
      0.879584,
      1.369084,
      1,
      1.631559,
      0,
      NULL,
      0.696450,
      NULL,
      1.277372,
      0,
      0.536921,
      1.678099,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.574596,
      0.255078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.502922,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257047,
      0.443783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.808946,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.017963,
      NULL,
      0,
      NULL,
      1,
      0.658878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      4.529665,
      2,
      4,
      NULL,
      0,
      5,
      NULL,
      3.149443,
      0.497504,
      2,
      1.346872,
      NULL,
      3,
      3.393382,
      NULL,
      3,
      3.403344,
      NULL,
      0.811433,
      0.680186,
      NULL,
      2.251260,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466527,
      1,
      NULL,
      0,
      3.663347,
      NULL,
      NULL,
      0,
      NULL,
      3.793131,
      NULL,
      NULL,
      1.539472,
      NULL,
      NULL,
      1,
      1.397206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      17.217583,
      1,
      0.026599,
      0.325980,
      '02102',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.350200,
      NULL,
      NULL,
      '');
commit;
end;
/


