set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9332463';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '0432010',
      2,
      1,
      NULL,
      2,
      '1221',
      1.497061,
      1.003359,
      NULL,
      NULL,
      ' 3- 1-1996',
      19,
      NULL,
      2,
      NULL,
      2.968178,
      '10- 1-1999',
      NULL,
      0,
      NULL,
      91.962914,
      NULL,
      '11-21-1991',
      ' 7- 3-1990',
      ' 2-15-1978',
      2,
      1.735245,
      3.369070,
      2,
      1,
      1.285143,
      1,
      1,
      NULL,
      2.400350,
      0,
      13,
      7.845808,
      4,
      21.883848,
      0,
      25,
      5,
      4,
      NULL,
      0.616640,
      1,
      3,
      NULL,
      1.644850,
      NULL,
      1,
      6.723483,
      1,
      1.825769,
      NULL,
      3,
      3,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      5,
      1,
      2,
      NULL,
      6.293824,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.354781,
      1.648070,
      1,
      1,
      NULL,
      1,
      2.902614,
      1.079247,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0,
      3,
      0,
      1,
      0,
      1.223683,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      0.142488,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.014363,
      4,
      0,
      0,
      0,
      0,
      3,
      2,
      0,
      1,
      2,
      0,
      1,
      1,
      0,
      NULL,
      2,
      3,
      0,
      3,
      0,
      4,
      NULL,
      NULL,
      2,
      1,
      6,
      3,
      ' 2- 4-1998',
      132.178061,
      ' 7- 0-1989',
      NULL,
      2,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.010361,
      2.742403,
      NULL,
      4,
      1.691743,
      1.652980,
      1,
      2,
      6,
      2,
      0.561373,
      2,
      0,
      1.700350,
      1,
      1,
      1.811204,
      8.429764,
      0.389880,
      NULL,
      0,
      3.797907,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.690511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.051987,
      1.681506,
      1.006737,
      1.319539,
      1.768091,
      1.973414,
      1.618526,
      23.394510,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      1,
      2,
      0,
      1,
      2,
      2,
      1,
      2.377528,
      NULL,
      3,
      2,
      1,
      NULL,
      0.207569,
      1.390939,
      1.847554,
      1,
      NULL,
      1.137261,
      0,
      0,
      1,
      1.178507,
      NULL,
      0.690692,
      4,
      6,
      3,
      NULL,
      3,
      6,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      2,
      NULL,
      71,
      71,
      33,
      5,
      0,
      NULL,
      '30313',
      '',
      '',
      0,
      '',
      '',
      '',
      1.475869,
      '',
      '',
      '',
      2.428964,
      NULL,
      34,
      36,
      2,
      9,
      0,
      3,
      NULL,
      3.035074,
      3.689391,
      NULL,
      1.408637,
      NULL,
      NULL,
      1.958790,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.513832,
      2.655855,
      1.543251,
      NULL,
      NULL,
      NULL,
      2.100833,
      2.713431,
      0.010070,
      NULL,
      NULL,
      1.886382,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      4.504746,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.029653,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.890662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432573,
      NULL,
      NULL,
      2.505191,
      0.089403,
      2.731581,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.706545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.324035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534687,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.942030,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.820814,
      0.846995,
      1.925214,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643417,
      4,
      1,
      0,
      1.511225,
      NULL,
      NULL,
      3,
      0,
      1.140992,
      2.461676,
      2,
      0,
      3.837751,
      3.404256,
      NULL,
      6.722914,
      3.871000,
      4.299402,
      2.215792,
      NULL,
      3,
      0.476058,
      NULL,
      NULL,
      3,
      3,
      0.873147,
      2.013549,
      0,
      2,
      2.068817,
      0.731784,
      NULL,
      3,
      NULL,
      3,
      1.419605,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356627,
      1.539803,
      1.118515,
      0.729487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.381268,
      0,
      1,
      0.095454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905170,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.520054,
      1,
      0.010359,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.606198,
      NULL,
      NULL,
      0.368591,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.690359,
      0,
      0,
      1.095527,
      0.858314,
      NULL,
      1.251612,
      1,
      0,
      0.104915,
      NULL,
      1.869680,
      0.748823,
      0,
      0.570107,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      7.483128,
      7,
      4,
      0,
      0,
      5,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      1.241306,
      0,
      NULL,
      3.444186,
      1.753884,
      NULL,
      1.300700,
      1,
      NULL,
      NULL,
      1.004831,
      NULL,
      1.264812,
      1.149471,
      NULL,
      3.312263,
      1,
      NULL,
      0.212439,
      1.833137,
      NULL,
      0,
      0,
      NULL,
      1.988347,
      2.272977,
      NULL,
      2.090217,
      0.581581,
      NULL,
      2.142288,
      1.635193,
      1.713357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331146,
      3.667688,
      NULL,
      2,
      NULL,
      0.659264,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.345367,
      NULL,
      0.327152,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2.182051,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.259775,
      NULL,
      16.400570,
      2.799811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371919,
      NULL,
      1,
      3,
      4,
      1,
      1,
      1.872985,
      38.146991,
      13.227450,
      0,
      0.196597,
      0.466232,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


