set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8533544';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '0324201',
      0.826586,
      1,
      3,
      NULL,
      '4221',
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 6-1975',
      44.705927,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3,
      302.559335,
      180.627562,
      2,
      ' 7-26-1988',
      '10-22-1999',
      '10-27-1975',
      1,
      NULL,
      1,
      NULL,
      1,
      1.650140,
      NULL,
      2.928573,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      14,
      11,
      1,
      NULL,
      4,
      NULL,
      2,
      0.604095,
      0,
      NULL,
      1.083775,
      1,
      NULL,
      1,
      1,
      0.977418,
      0,
      NULL,
      4,
      2,
      2,
      3.680860,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.040667,
      1.481656,
      0,
      NULL,
      NULL,
      1.599766,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1.666496,
      0.647676,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      7,
      1,
      0,
      3,
      1.495226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      3,
      1,
      3,
      3,
      0,
      0,
      1,
      0,
      0,
      NULL,
      2,
      2,
      2,
      2,
      0,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      '11-20-1998',
      103,
      ' 5- 0-1995',
      11,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.930377,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.821154,
      NULL,
      NULL,
      NULL,
      0.549531,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.191726,
      1,
      NULL,
      1.247577,
      0.441040,
      4.833882,
      0.859892,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.334317,
      0.338562,
      NULL,
      2,
      3,
      NULL,
      3,
      2,
      NULL,
      NULL,
      3,
      2,
      3,
      NULL,
      NULL,
      8,
      0.624412,
      0,
      NULL,
      0,
      NULL,
      55.944825,
      91.097302,
      143,
      55.000104,
      161,
      14.299488,
      2,
      1.979662,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      49,
      28,
      93,
      NULL,
      0,
      NULL,
      NULL,
      '',
      '',
      1,
      '44104',
      '',
      '',
      0.818801,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      39.039094,
      38,
      1.236205,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414435,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.903995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404351,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.462373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344330,
      NULL,
      NULL,
      1.065864,
      NULL,
      NULL,
      0.951189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151129,
      3.665873,
      0,
      0.952115,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.776691,
      NULL,
      1,
      NULL,
      0.926531,
      0.721060,
      0,
      1.162888,
      0,
      1.280154,
      0,
      0.846401,
      1,
      1,
      0,
      1.110826,
      0.461315,
      NULL,
      NULL,
      1.744980,
      NULL,
      NULL,
      1.578102,
      NULL,
      NULL,
      NULL,
      3.145830,
      3.788648,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.654573,
      NULL,
      NULL,
      NULL,
      1.606371,
      NULL,
      NULL,
      1.738621,
      NULL,
      NULL,
      0.060553,
      NULL,
      NULL,
      0.009754,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.001073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544867,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.749479,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.399703,
      1.909470,
      3,
      1.834375,
      NULL,
      NULL,
      4.586154,
      1.863055,
      NULL,
      4.350690,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.630225,
      1,
      3,
      1,
      2.818117,
      NULL,
      2,
      1.834210,
      1.662658,
      0,
      3,
      1,
      0.379759,
      NULL,
      NULL,
      0.389920,
      NULL,
      2,
      2,
      2.010493,
      0,
      0,
      2.654895,
      4.534684,
      NULL,
      NULL,
      NULL,
      1.329942,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.407551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646161,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.906104,
      1,
      0.132884,
      NULL,
      0.396019,
      NULL,
      NULL,
      4.795627,
      NULL,
      NULL,
      NULL,
      767.304203,
      NULL,
      NULL,
      NULL,
      1.383634,
      NULL,
      NULL,
      NULL,
      1.814703,
      NULL,
      NULL,
      NULL,
      1.398562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.736431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266834,
      NULL,
      NULL,
      NULL,
      1.460799,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.788578,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.763937,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.493772,
      NULL,
      1.685831,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.956370,
      NULL,
      NULL,
      0.831976,
      NULL,
      NULL,
      0,
      NULL,
      0.524404,
      NULL,
      0.490025,
      1,
      NULL,
      0,
      0.928866,
      1.540363,
      0,
      3,
      1.203697,
      0,
      0,
      NULL,
      1.781922,
      NULL,
      1,
      0.172354,
      0.990279,
      2,
      NULL,
      1,
      NULL,
      1.872007,
      NULL,
      1.684331,
      NULL,
      0.773568,
      NULL,
      1.314694,
      NULL,
      1,
      NULL,
      0.874293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.634211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.256720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.116720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.551690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      5,
      1.913548,
      2.877982,
      NULL,
      2,
      15,
      3.940011,
      3,
      NULL,
      1,
      0.210379,
      NULL,
      1.877975,
      1.235991,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616843,
      NULL,
      NULL,
      1.371857,
      3.018336,
      NULL,
      NULL,
      3,
      NULL,
      1.182492,
      NULL,
      NULL,
      2.702160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.071544,
      NULL,
      0,
      1.400000,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.882740,
      NULL,
      0,
      NULL,
      2.356278,
      NULL,
      1.320295,
      NULL,
      0.113323,
      NULL,
      1,
      NULL,
      1.637863,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.427018,
      NULL,
      0,
      NULL,
      0.085346,
      NULL,
      9,
      NULL,
      1.029647,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      1.380758,
      2.238434,
      NULL,
      NULL,
      46,
      4,
      0.676024,
      2,
      '34144',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0.468275,
      '',
      '',
      '');
commit;
end;
/


