set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8533544';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      '1341',
      NULL,
      1.784720,
      NULL,
      NULL,
      ' 7- 0-2003',
      41.861016,
      NULL,
      3,
      3,
      1,
      NULL,
      4,
      3.089215,
      69.989969,
      173.856190,
      0,
      ' 1-10-1982',
      ' 3-23-1978',
      ' 3-29-1988',
      0,
      1,
      0,
      NULL,
      0.134111,
      0,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      86.855981,
      150.706331,
      3,
      2,
      5,
      1,
      4,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      1.616036,
      1.252564,
      1.465658,
      0,
      1,
      4,
      NULL,
      NULL,
      0.458194,
      NULL,
      5,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      3.445747,
      0,
      1,
      NULL,
      NULL,
      1.348419,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.312518,
      NULL,
      1.315294,
      0.207745,
      NULL,
      3.719018,
      0.288191,
      0.908480,
      2.734464,
      1,
      3,
      0,
      3,
      NULL,
      1.430719,
      3.390271,
      1.620004,
      NULL,
      3,
      2,
      5,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0,
      3,
      0,
      NULL,
      1,
      1.974798,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      1,
      3,
      1,
      4,
      NULL,
      1,
      0,
      1,
      2,
      ' 8-20-1998',
      146.716261,
      ' 5- 0-1990',
      6,
      2.455018,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      5,
      1,
      NULL,
      0.533931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.669756,
      1,
      2,
      2.328601,
      NULL,
      0,
      0,
      NULL,
      0,
      2,
      2.835421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419052,
      1.122346,
      0.137750,
      NULL,
      0,
      1.103335,
      0,
      3,
      27.646122,
      1.007675,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      0,
      3,
      1,
      2.888970,
      NULL,
      NULL,
      97.360275,
      186.704763,
      NULL,
      86,
      148,
      52.698699,
      185.366128,
      NULL,
      75.347074,
      NULL,
      0.254877,
      0,
      1,
      3.985206,
      7,
      0.474358,
      4,
      11,
      4,
      NULL,
      NULL,
      2,
      1.634748,
      3,
      0.269450,
      NULL,
      2,
      1.575111,
      34,
      NULL,
      1,
      NULL,
      67,
      79,
      NULL,
      3,
      1.685433,
      1,
      '41443',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      58.484518,
      41,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901448,
      2.376520,
      0.530566,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      3.375669,
      3,
      1.706913,
      1,
      NULL,
      NULL,
      0.194143,
      NULL,
      NULL,
      0.270875,
      NULL,
      NULL,
      0.841626,
      NULL,
      NULL,
      3,
      0,
      0,
      1.349079,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.769655,
      NULL,
      NULL,
      3.131145,
      2.826406,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.293860,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.099607,
      NULL,
      1,
      3,
      0.888658,
      NULL,
      0,
      0.297374,
      0.911742,
      3.933829,
      1.286887,
      1.958056,
      2,
      NULL,
      1.837681,
      3,
      0,
      3,
      NULL,
      2.529488,
      1.557411,
      3.648374,
      1,
      NULL,
      NULL,
      0.821497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.938220,
      1.309023,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.790837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021857,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.419063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.467470,
      NULL,
      NULL,
      1.776539,
      NULL,
      NULL,
      0.700585,
      NULL,
      NULL,
      1.616124,
      0.037820,
      2.807120,
      NULL,
      0,
      1,
      NULL,
      0.062605,
      0,
      3.446087,
      1,
      3,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      1.574404,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.562714,
      1.760490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.246966,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.411681,
      NULL,
      NULL,
      1.777316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086052,
      NULL,
      NULL,
      1,
      0,
      2.034280,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.312108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.354576,
      NULL,
      NULL,
      NULL,
      0.007043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072980,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.154354,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.654454,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.890837,
      NULL,
      NULL,
      NULL,
      3.134383,
      NULL,
      NULL,
      NULL,
      0.388009,
      NULL,
      NULL,
      NULL,
      0.758236,
      3,
      5,
      1,
      2,
      NULL,
      NULL,
      1.014216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.058525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      114.150268,
      5.260737,
      1.117337,
      0,
      0,
      0.204990,
      0,
      1,
      NULL,
      1.234223,
      1.326688,
      0,
      NULL,
      1.692073,
      0.209123,
      0.563442,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.993643,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.777016,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050623,
      0.476703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558684,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.634661,
      NULL,
      1,
      NULL,
      1.353642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3,
      NULL,
      1.768932,
      NULL,
      NULL,
      NULL,
      0.862987,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.957747,
      NULL,
      0.165169,
      0,
      NULL,
      0.703938,
      0,
      NULL,
      1,
      0,
      NULL,
      0.233952,
      1.696737,
      NULL,
      0,
      0,
      NULL,
      1.363706,
      1,
      NULL,
      0.157825,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.905420,
      NULL,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      103,
      NULL,
      2,
      1.613874,
      0,
      '23014',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


