set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8533544';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '3432203',
      1.310987,
      1.714889,
      5,
      2,
      '3200',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      26.285432,
      NULL,
      2,
      0,
      NULL,
      ' 1- 1-1979',
      31,
      NULL,
      307,
      124.198986,
      2,
      ' 8-14-1982',
      ' 1- 3-1978',
      '11-12-1997',
      3,
      0.211204,
      2.967615,
      NULL,
      0,
      1.215361,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      11.507495,
      11.989726,
      7,
      13.131348,
      2,
      NULL,
      1,
      1,
      9,
      0,
      0,
      0,
      3,
      1,
      0.963244,
      1.327190,
      1,
      1.274168,
      NULL,
      0.223528,
      3,
      2,
      NULL,
      3,
      4,
      2,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      1.902542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      8,
      0,
      0,
      0,
      0,
      0,
      1,
      3,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      2,
      6.663908,
      1,
      0,
      3.794229,
      1,
      NULL,
      NULL,
      1.580424,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      4,
      1,
      0,
      0,
      NULL,
      0,
      1,
      5,
      5,
      1,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      1,
      0.238913,
      ' 8-14-1998',
      NULL,
      NULL,
      90,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      1,
      0,
      0.547783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.496617,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      2.811444,
      NULL,
      NULL,
      1.933789,
      5,
      1,
      2.922344,
      NULL,
      6.548478,
      0,
      NULL,
      NULL,
      1.918447,
      0.817873,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710152,
      0.064303,
      0.102171,
      0.017942,
      NULL,
      0,
      0,
      3,
      30,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      1,
      2,
      0,
      3,
      0,
      3,
      2,
      1,
      3,
      0,
      3,
      2.825255,
      0,
      6.966810,
      NULL,
      0.924045,
      0,
      1.892036,
      NULL,
      131,
      158,
      142,
      NULL,
      NULL,
      190.441452,
      2,
      0.851041,
      4,
      0.895198,
      2,
      2.989404,
      3.338159,
      1.995520,
      2.401799,
      NULL,
      0.283114,
      2,
      3,
      2,
      0,
      0,
      57,
      NULL,
      2,
      NULL,
      20,
      NULL,
      16.577481,
      1,
      0,
      2,
      '40101',
      NULL,
      '',
      1.726086,
      '44040',
      '',
      '',
      1.313810,
      '',
      '',
      NULL,
      3,
      6,
      114,
      47.759766,
      0.702075,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.654984,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0.188701,
      0,
      NULL,
      NULL,
      1.278881,
      NULL,
      NULL,
      1.555522,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.600454,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.248662,
      1,
      1.658320,
      NULL,
      3.105703,
      0,
      0.125923,
      NULL,
      0.243804,
      0.234513,
      2,
      0,
      NULL,
      3.691451,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.499230,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.907984,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.803278,
      3,
      0.176387,
      NULL,
      0.406838,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908677,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.981477,
      NULL,
      NULL,
      1.479650,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.446011,
      NULL,
      NULL,
      0.424202,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.182698,
      3.039800,
      2.121526,
      1.418570,
      NULL,
      NULL,
      0,
      1.112712,
      1,
      2.390892,
      4,
      0,
      1,
      NULL,
      NULL,
      0.622241,
      NULL,
      NULL,
      0.781328,
      1,
      3,
      NULL,
      3,
      2,
      0,
      1.552169,
      4.005216,
      NULL,
      1.065368,
      NULL,
      3.606189,
      0.593832,
      1.471314,
      NULL,
      3.783089,
      0,
      1.283341,
      1.505312,
      2.095251,
      4,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      1.266057,
      1.056683,
      0.593472,
      0,
      0.183978,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.222958,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.833591,
      NULL,
      NULL,
      NULL,
      1.842568,
      1.903487,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      504.269431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.565645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.174138,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.154396,
      NULL,
      NULL,
      NULL,
      1.338007,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.839177,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6.885003,
      NULL,
      NULL,
      NULL,
      1.746414,
      4.130303,
      1,
      3,
      3,
      0.232846,
      1,
      0.136591,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.831554,
      416,
      NULL,
      NULL,
      0.037661,
      NULL,
      0,
      0.125492,
      1.262712,
      3.365445,
      0.902375,
      NULL,
      1,
      NULL,
      0.216167,
      0.421873,
      0,
      1,
      0.776588,
      2.823405,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.998565,
      NULL,
      0.884032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327022,
      0.509975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155037,
      1.365467,
      1.260087,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.690109,
      NULL,
      1,
      1.872471,
      1.177070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      5,
      5,
      3,
      5,
      1,
      1.425877,
      0,
      0.720330,
      1.199301,
      NULL,
      NULL,
      0.615072,
      NULL,
      1,
      0.205604,
      NULL,
      1,
      NULL,
      NULL,
      0.563931,
      NULL,
      NULL,
      0.501755,
      2,
      NULL,
      1,
      3.859883,
      NULL,
      1,
      0.005372,
      NULL,
      0.707960,
      1.103971,
      NULL,
      2,
      2,
      NULL,
      0.115308,
      1,
      NULL,
      0.396835,
      NULL,
      1.784436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.283296,
      NULL,
      0,
      NULL,
      1.709403,
      NULL,
      1.776859,
      NULL,
      1,
      NULL,
      0.473409,
      NULL,
      1.011887,
      NULL,
      1.419727,
      NULL,
      0,
      NULL,
      1.672958,
      NULL,
      14,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.775094,
      NULL,
      46,
      54,
      5,
      1,
      1,
      '01411',
      '',
      '',
      3,
      '41311',
      NULL,
      '',
      0.317702,
      '',
      '',
      '');
commit;
end;
/


