set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.586956,
      1,
      2,
      5.528018,
      1.615103,
      3.542812,
      1,
      3,
      '131',
      '21214100',
      59.329010,
      17,
      '3032144',
      2,
      NULL,
      0,
      1,
      '0104',
      4.029180,
      NULL,
      NULL,
      NULL,
      '10-16-1996',
      17,
      100.106673,
      NULL,
      0,
      0.135423,
      ' 0-16-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11-15-1983',
      ' 3-14-1999',
      ' 5-24-1985',
      3,
      3.511468,
      0.097930,
      NULL,
      0,
      3.659227,
      NULL,
      3.317507,
      NULL,
      NULL,
      NULL,
      10.537942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      0.347086,
      3,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      6,
      1,
      1,
      NULL,
      1,
      0.890591,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0.921896,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      2,
      NULL,
      0,
      0.035083,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      NULL,
      2,
      NULL,
      1,
      1,
      3,
      NULL,
      0,
      1,
      2.614438,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0,
      3,
      1,
      1,
      4,
      1,
      NULL,
      5,
      0,
      0,
      0,
      1.323113,
      1,
      ' 2-29-1987',
      1519,
      ' 0-14-1992',
      16.314482,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1.825521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.240619,
      1.071098,
      3,
      1.405325,
      NULL,
      5,
      0.109332,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.650588,
      1.307571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.161307,
      NULL,
      1.793431,
      1.753696,
      0.493385,
      NULL,
      1,
      3.394273,
      NULL,
      1,
      0.208857,
      NULL,
      NULL,
      NULL,
      3,
      0.024051,
      0.172232,
      2,
      0,
      0,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.457433,
      1,
      0,
      0.280798,
      0,
      NULL,
      1,
      NULL,
      1,
      1.083470,
      1.073941,
      0,
      3,
      4,
      0.856342,
      1,
      1,
      5.578625,
      7,
      2,
      3,
      1.795768,
      NULL,
      3.595533,
      1,
      1.794138,
      2.444363,
      45,
      NULL,
      0.171293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626508,
      5,
      '04130',
      '34331',
      '',
      1.988837,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      3.995028,
      25,
      23.173896,
      2.761024,
      3.104466,
      28,
      NULL,
      1,
      0,
      3,
      NULL,
      1,
      0.944927,
      NULL,
      NULL,
      0.593034,
      NULL,
      NULL,
      0.089589,
      NULL,
      NULL,
      0.073189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745927,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.295694,
      NULL,
      NULL,
      0.484088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.429590,
      NULL,
      NULL,
      3.536425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.735767,
      0.625348,
      0.886194,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.502409,
      NULL,
      NULL,
      2.276957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844037,
      NULL,
      NULL,
      0.092084,
      NULL,
      NULL,
      1,
      0,
      0,
      0.934963,
      NULL,
      NULL,
      2,
      1,
      1.647489,
      0.479020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197891,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.615408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.254080,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906916,
      NULL,
      NULL,
      0.615382,
      NULL,
      NULL,
      1.503941,
      NULL,
      NULL,
      NULL,
      0.096913,
      0.362195,
      1.372755,
      1.675372,
      0,
      0.206826,
      NULL,
      NULL,
      NULL,
      2.630549,
      3.870738,
      3,
      1,
      1.841142,
      1,
      0.790226,
      NULL,
      3.020075,
      3,
      2,
      2.496764,
      1.293629,
      NULL,
      5.057828,
      0,
      1.671656,
      2.629312,
      3,
      0,
      1,
      NULL,
      NULL,
      1.802155,
      0.446489,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964443,
      0.224581,
      1.519687,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187945,
      2.198752,
      1,
      NULL,
      3.794673,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.448085,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528773,
      NULL,
      1,
      1.934651,
      3.633854,
      0.320585,
      3.455871,
      1,
      0,
      0,
      NULL,
      2,
      1.009353,
      NULL,
      0,
      1.642223,
      0,
      NULL,
      NULL,
      1.726624,
      NULL,
      1,
      1.521491,
      0,
      NULL,
      0.681828,
      0.353416,
      1.898407,
      0,
      1,
      0,
      NULL,
      NULL,
      16,
      73,
      0,
      1,
      7.923278,
      NULL,
      0.112477,
      0,
      NULL,
      0,
      2,
      2.241004,
      1.839832,
      0.056762,
      0,
      NULL,
      0,
      2.136750,
      1.177628,
      0.346180,
      0.484054,
      1,
      1,
      0.422571,
      NULL,
      NULL,
      3,
      1,
      1.718155,
      0,
      NULL,
      NULL,
      NULL,
      0.921765,
      1,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.061471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.587070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998762,
      0.201310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.622357,
      NULL,
      NULL,
      1.796822,
      0,
      NULL,
      NULL,
      0.329917,
      1,
      0.111259,
      1.832425,
      1.498395,
      1.272951,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5.623930,
      0,
      2,
      1,
      0,
      6,
      1,
      0,
      1.462015,
      1.373749,
      0.332031,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.127318,
      NULL,
      NULL,
      1.705849,
      2.071665,
      NULL,
      NULL,
      0,
      NULL,
      0.492548,
      0,
      NULL,
      1.818371,
      1.318744,
      NULL,
      1.908291,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      71.581597,
      NULL,
      3,
      NULL,
      NULL,
      '44113',
      '00003',
      '',
      0.614029,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


