set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314770';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.688972,
      3.929118,
      2.437401,
      4,
      NULL,
      3,
      3,
      3,
      NULL,
      NULL,
      53.102247,
      38.780916,
      '1333220',
      5,
      0.236675,
      0,
      0,
      '1414',
      0,
      0,
      NULL,
      NULL,
      ' 2- 4-1975',
      109.445773,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-12-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 0-28-1988',
      2,
      1.305080,
      1,
      1,
      NULL,
      NULL,
      2,
      1.645103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.043605,
      0,
      0.013520,
      1.331893,
      1,
      0,
      NULL,
      0.860026,
      1,
      4,
      0,
      0.807299,
      3,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.406036,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      4,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1.311176,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      5,
      NULL,
      4,
      5,
      NULL,
      2,
      5,
      0,
      2,
      0,
      0,
      1.420897,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.589864,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.007981,
      NULL,
      NULL,
      NULL,
      0.302263,
      0,
      1,
      2,
      1.914563,
      0.696034,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380865,
      0,
      0,
      1.272748,
      NULL,
      1.266537,
      NULL,
      0,
      NULL,
      1,
      0.401869,
      NULL,
      NULL,
      NULL,
      1,
      0.243024,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      2,
      1,
      NULL,
      1,
      0,
      1.643428,
      2,
      NULL,
      0.319602,
      0.452284,
      NULL,
      0.681148,
      0.400503,
      1.209139,
      0,
      NULL,
      1,
      0,
      1.489183,
      NULL,
      3.390094,
      4,
      1.076620,
      6.178494,
      4,
      2.918916,
      1.700088,
      NULL,
      NULL,
      0,
      2.774423,
      NULL,
      3.904869,
      3.928204,
      2.870931,
      39,
      3,
      0,
      48,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      '00314',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.508396,
      23.448082,
      120.318354,
      4,
      NULL,
      14,
      NULL,
      3,
      4,
      3,
      0.940982,
      0,
      0.613669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.898476,
      NULL,
      2.560853,
      0.225767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269031,
      NULL,
      NULL,
      1.280722,
      NULL,
      NULL,
      0.334111,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.048763,
      0.203316,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.860587,
      1.375008,
      0.116470,
      2.938377,
      NULL,
      1,
      2.919606,
      0.194020,
      NULL,
      0.692888,
      1,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.723355,
      NULL,
      NULL,
      6.405189,
      0,
      2.459181,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.907651,
      NULL,
      NULL,
      NULL,
      0.300127,
      NULL,
      NULL,
      2,
      0,
      1.706475,
      3,
      0,
      1.079271,
      0.908362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.403495,
      1,
      0.548771,
      1,
      0,
      NULL,
      0.249668,
      NULL,
      NULL,
      0.938545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535656,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.306793,
      0,
      NULL,
      0.841213,
      NULL,
      NULL,
      0,
      0,
      1,
      3.523201,
      1,
      0,
      1.693107,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      2.024880,
      2,
      1,
      NULL,
      0.105070,
      1.330732,
      3.778482,
      NULL,
      2.118099,
      NULL,
      NULL,
      2.389923,
      3,
      3,
      NULL,
      1.416856,
      1.397812,
      1,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.227221,
      0,
      0.441279,
      1,
      1,
      3.098297,
      NULL,
      NULL,
      3.011469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.977117,
      NULL,
      NULL,
      0.526011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.174366,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.330379,
      1.025559,
      3,
      2.894196,
      NULL,
      NULL,
      4.970983,
      1,
      NULL,
      NULL,
      1.625995,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.993180,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.734210,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.088942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.650343,
      0.595378,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.574264,
      2.890698,
      NULL,
      NULL,
      1.151885,
      NULL,
      NULL,
      NULL,
      0.821636,
      0.332680,
      NULL,
      2,
      3,
      0.916011,
      0.446713,
      NULL,
      NULL,
      0.691561,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.505468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082089,
      24.297229,
      1.090700,
      NULL,
      0.261298,
      0.976737,
      NULL,
      2,
      0.397858,
      3,
      NULL,
      0.407654,
      1,
      3,
      0.675390,
      1.264780,
      NULL,
      1,
      0.269306,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.330989,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      11,
      NULL,
      0.630803,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0.526472,
      NULL,
      NULL,
      NULL,
      2.720131,
      NULL,
      2.195862,
      NULL,
      0.448257,
      NULL,
      1.392691,
      NULL,
      3,
      NULL,
      0.711534,
      NULL,
      0.313473,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.051725,
      2,
      0.933003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035632,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.566119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658828,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946420,
      2,
      NULL,
      1,
      NULL,
      0.372916,
      NULL,
      NULL,
      NULL,
      0.673093,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      2.274057,
      0.409976,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991802,
      0.306294,
      1.364097,
      0,
      NULL,
      0.107120,
      0.128371,
      0.103196,
      1,
      0,
      1.837476,
      1.721962,
      NULL,
      1,
      1.920331,
      1,
      2.817643,
      1,
      0,
      NULL,
      1.169985,
      0.214015,
      NULL,
      0.898200,
      1,
      0,
      0.000842,
      3,
      NULL,
      0.000331,
      0.126527,
      0.684451,
      2.631703,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.335783,
      0,
      3,
      1,
      7,
      0,
      NULL,
      2.819735,
      41.170159,
      35.209102,
      4,
      4.215509,
      1.998342,
      '10434',
      '12101',
      '',
      0.835315,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


