set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9515594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      NULL,
      0,
      0.492372,
      NULL,
      3.592831,
      2.003505,
      '014',
      '12022112',
      9,
      13.289308,
      NULL,
      3,
      1.283997,
      4,
      NULL,
      '0422',
      2,
      1.310447,
      NULL,
      NULL,
      NULL,
      55.824498,
      111,
      NULL,
      0.248787,
      4,
      ' 4-28-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 0-13-2001',
      '10-12-1989',
      '11-19-1982',
      2,
      1,
      2.790363,
      1.017441,
      0,
      1.407223,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      2,
      NULL,
      4,
      4,
      3,
      NULL,
      5,
      3,
      3,
      NULL,
      1,
      4,
      0,
      11,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.711224,
      NULL,
      NULL,
      3.644130,
      NULL,
      2.530515,
      1.449979,
      3,
      0.162996,
      3.170854,
      NULL,
      1,
      0,
      NULL,
      3,
      3.350603,
      3,
      0,
      4,
      NULL,
      NULL,
      0,
      5.527013,
      0,
      NULL,
      NULL,
      0.606470,
      NULL,
      NULL,
      5,
      5,
      2,
      2,
      3,
      1,
      1,
      NULL,
      1,
      3,
      0,
      4,
      1,
      2.250079,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1.246294,
      0,
      NULL,
      4,
      4,
      1,
      0,
      5,
      1,
      5,
      1,
      5,
      NULL,
      0,
      5,
      2,
      4,
      1,
      4,
      NULL,
      4,
      2,
      4,
      0,
      4,
      1,
      2,
      3.370335,
      ' 5-27-1990',
      248,
      ' 2-22-1984',
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      3,
      NULL,
      1,
      0.013038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      12.364876,
      0,
      1.711934,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011836,
      0.316719,
      5.318483,
      5.382388,
      1,
      4,
      NULL,
      1.028209,
      NULL,
      0,
      1,
      2.480348,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114575,
      0,
      0.587783,
      0,
      NULL,
      NULL,
      NULL,
      3.811648,
      NULL,
      0.352347,
      0.221588,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.704812,
      NULL,
      0,
      NULL,
      1,
      3,
      0,
      2,
      2,
      2,
      3,
      NULL,
      0.889193,
      NULL,
      4,
      NULL,
      1,
      1,
      NULL,
      1.940641,
      NULL,
      0,
      NULL,
      1,
      0,
      1.176234,
      NULL,
      1,
      NULL,
      0,
      4.279306,
      2.556228,
      NULL,
      0.157250,
      11.997408,
      1.379526,
      5,
      3.173183,
      7,
      1,
      2.046385,
      2,
      33,
      NULL,
      2.517384,
      19,
      NULL,
      33,
      67.682937,
      4,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      10.486888,
      24.673152,
      35,
      0.770074,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.646399,
      1,
      2,
      1.985818,
      1,
      2,
      0,
      1.288542,
      0.623107,
      0,
      NULL,
      2.080559,
      1,
      1.626561,
      2.898576,
      2.246158,
      3,
      1.686532,
      1.942948,
      1.025291,
      NULL,
      3.065802,
      1,
      1.428515,
      3,
      2,
      1.940698,
      NULL,
      NULL,
      2,
      3.553720,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.886394,
      7.305449,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.055820,
      NULL,
      NULL,
      NULL,
      NULL,
      3.248763,
      2,
      3,
      NULL,
      0.589658,
      2.565209,
      NULL,
      1.327485,
      0,
      NULL,
      3.724939,
      1,
      2,
      NULL,
      0,
      2,
      1,
      0.114245,
      2.736084,
      0.223412,
      2.434916,
      1.261508,
      1.070612,
      NULL,
      0.296627,
      2.093251,
      1,
      NULL,
      NULL,
      0,
      3,
      0.102546,
      NULL,
      8,
      4.119715,
      0.741573,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.632724,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1.118179,
      0.043575,
      1.686210,
      3,
      1.831225,
      5,
      3.445189,
      3,
      NULL,
      2,
      2,
      1.321929,
      0,
      1,
      4,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892483,
      NULL,
      NULL,
      1.786371,
      NULL,
      NULL,
      1.504355,
      NULL,
      NULL,
      NULL,
      1.361047,
      0.550129,
      NULL,
      5.095984,
      4,
      1.749157,
      4.082029,
      2,
      0,
      NULL,
      NULL,
      2.255366,
      0.748538,
      0,
      1,
      1.677145,
      NULL,
      1.869578,
      NULL,
      0.994692,
      2.884712,
      2.489134,
      2,
      1,
      NULL,
      NULL,
      1,
      0.125863,
      2.236798,
      1.372125,
      1,
      0.878069,
      0,
      2.387066,
      0.844080,
      1.215192,
      5,
      3.841807,
      1.050929,
      NULL,
      NULL,
      0.019300,
      NULL,
      NULL,
      0,
      1.032978,
      1.389149,
      0,
      0.030983,
      1,
      NULL,
      NULL,
      1.038512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.027355,
      NULL,
      NULL,
      3.848896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.327225,
      1,
      0.011257,
      0.092172,
      0.358889,
      3,
      1.907106,
      NULL,
      NULL,
      1.258196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.933678,
      NULL,
      NULL,
      NULL,
      0.865746,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983997,
      0,
      0.252869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.836354,
      NULL,
      NULL,
      1.970131,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.006657,
      1.892205,
      1.734371,
      0.104868,
      0,
      NULL,
      0.803388,
      1.366634,
      1,
      1.053086,
      0.605772,
      1.141233,
      NULL,
      1.704811,
      NULL,
      0,
      0,
      1.585681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.741237,
      0.933020,
      NULL,
      0.252606,
      1,
      1.580164,
      NULL,
      0.611059,
      0,
      1,
      1.782006,
      NULL,
      1,
      1,
      NULL,
      1.599341,
      0.439676,
      NULL,
      0,
      3,
      NULL,
      0,
      1.233143,
      NULL,
      0.371960,
      0,
      NULL,
      1,
      1.585369,
      NULL,
      1.836559,
      0,
      NULL,
      NULL,
      1.673005,
      NULL,
      0.128681,
      NULL,
      NULL,
      0,
      0.994715,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      0.931347,
      NULL,
      NULL,
      38.091033,
      107.599757,
      4,
      1,
      3.254216,
      '42104',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


