set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935282';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '0140442',
      2.253006,
      1.703672,
      NULL,
      1,
      '0030',
      1.636428,
      NULL,
      NULL,
      NULL,
      '10-18-2002',
      31.041116,
      NULL,
      2,
      0.935716,
      1,
      '10-26-1991',
      6.401194,
      0,
      90.389700,
      93,
      2,
      ' 9-16-1989',
      NULL,
      ' 2-27-1983',
      0.989691,
      0,
      2.743193,
      0.552917,
      0.800035,
      2,
      1,
      0,
      0.221053,
      33,
      2,
      14,
      4.781430,
      26,
      22.785930,
      0,
      26,
      NULL,
      2,
      2.909403,
      0.257710,
      1,
      1,
      1.544795,
      1.894326,
      1.696088,
      0.567045,
      0.230161,
      1,
      0,
      3.749433,
      NULL,
      2,
      NULL,
      3.899743,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1.653860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.778080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      1.386138,
      NULL,
      3,
      3,
      3,
      0,
      4,
      NULL,
      2,
      3,
      NULL,
      4,
      0,
      0,
      2,
      3,
      1,
      4,
      0,
      3,
      3,
      NULL,
      1,
      4,
      NULL,
      1,
      0,
      0,
      1.100101,
      1.649341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      1.612953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.358124,
      3,
      1.195166,
      0,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.662928,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305909,
      NULL,
      0.695675,
      0.014527,
      0.099651,
      1,
      0.921970,
      1.169074,
      47,
      2.457990,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.266630,
      0.879875,
      1,
      2,
      2,
      0,
      0,
      3,
      3,
      3,
      3,
      NULL,
      NULL,
      1.431551,
      3,
      0.719135,
      0,
      0.448926,
      2.762355,
      1.665672,
      1.456339,
      1,
      1.985169,
      0.387227,
      0,
      1.367040,
      1.837855,
      1,
      NULL,
      1,
      0.720385,
      11,
      1.321937,
      3.027746,
      NULL,
      NULL,
      0.448596,
      5,
      3.125446,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      3.880940,
      NULL,
      NULL,
      56,
      37,
      5,
      1.802260,
      2.711711,
      '34423',
      NULL,
      '',
      1.965836,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      2,
      30,
      187,
      29,
      2,
      28,
      3,
      5,
      NULL,
      0.925225,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.624897,
      NULL,
      NULL,
      1,
      0.287242,
      0,
      2,
      2.446400,
      1.272046,
      1,
      NULL,
      NULL,
      3,
      3.712533,
      1,
      0,
      NULL,
      NULL,
      1.554415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947573,
      NULL,
      NULL,
      1.470901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.443313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.817756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.230481,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982499,
      5.777533,
      2.088683,
      0.170798,
      1.998613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.043523,
      0.420823,
      3,
      1.323978,
      NULL,
      NULL,
      1.766347,
      NULL,
      NULL,
      0.882486,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.999289,
      3.057118,
      1.590864,
      1.326291,
      0.415698,
      3.651456,
      11.394085,
      4,
      NULL,
      9.955356,
      8,
      3.930381,
      0.898220,
      NULL,
      2.683419,
      1.002015,
      1.363564,
      NULL,
      3,
      1,
      2,
      1,
      3,
      3.631840,
      8,
      NULL,
      8.938955,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3.658396,
      1.255756,
      0.810502,
      3.721226,
      2,
      3,
      3,
      NULL,
      4.632588,
      7,
      0,
      3.130474,
      1.571280,
      1,
      NULL,
      0,
      1.194593,
      1.576928,
      1,
      1.626400,
      2.713035,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.112285,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846874,
      NULL,
      NULL,
      2.699854,
      NULL,
      NULL,
      0.919846,
      1,
      0.671057,
      1.078487,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.051420,
      3,
      NULL,
      NULL,
      1.984296,
      3.958014,
      NULL,
      NULL,
      0.827028,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.838166,
      1,
      NULL,
      NULL,
      0.050663,
      5.748916,
      NULL,
      NULL,
      1.066525,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      12.079594,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.747354,
      NULL,
      NULL,
      NULL,
      3.523286,
      2,
      1,
      NULL,
      NULL,
      0.775320,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0.749895,
      0.449502,
      0,
      NULL,
      0.891665,
      1,
      0,
      0.783661,
      1.676235,
      1,
      0.896822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.935586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.085894,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555053,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.910474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420723,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.971600,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.933564,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      0,
      0.424560,
      3,
      19.286885,
      1,
      2.054441,
      1.822549,
      1.813983,
      0,
      0,
      1,
      0.328333,
      1.829322,
      NULL,
      0.931114,
      0.936463,
      1,
      0,
      1.490358,
      0,
      1,
      NULL,
      0.283810,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      0.499403,
      1.625796,
      1.855648,
      1,
      1,
      NULL,
      NULL,
      0,
      0.574291,
      3.353950,
      3.129935,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952853,
      NULL,
      NULL,
      0,
      1.103957,
      1.583314,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      23,
      76,
      0,
      NULL,
      3,
      '44024',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      NULL);
commit;
end;
/


