set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9638589';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      '03',
      5.729737,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      '3012',
      0.549082,
      0.434360,
      NULL,
      NULL,
      ' 3-28-1976',
      157,
      0.747573,
      NULL,
      0.652593,
      1.146106,
      ' 4- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 8-26-1985',
      ' 7-21-1987',
      ' 1-18-1999',
      NULL,
      0.055223,
      2.273218,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      340,
      NULL,
      6.562317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3.835556,
      3,
      0,
      NULL,
      1,
      1,
      1,
      2,
      2,
      2,
      3,
      0,
      3,
      5,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      2.897850,
      2.225156,
      1.540777,
      0,
      3.235223,
      0.117751,
      0,
      0.261668,
      2,
      NULL,
      NULL,
      2.350066,
      0.562216,
      NULL,
      NULL,
      NULL,
      3.212823,
      0,
      5,
      1,
      3,
      1,
      0,
      0,
      0.022272,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      5,
      5,
      NULL,
      0,
      2,
      0,
      0,
      2,
      NULL,
      1.009083,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1.426261,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      4,
      1,
      0,
      NULL,
      1,
      3,
      5,
      2,
      5,
      0,
      2,
      0,
      3.571470,
      NULL,
      1066,
      ' 6-20-1981',
      NULL,
      0.971108,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      2,
      0,
      5,
      1,
      NULL,
      0.981641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718550,
      1.515329,
      0,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.372377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.310700,
      1.391687,
      1,
      0,
      0.011168,
      1.636823,
      1.985426,
      89,
      1.446229,
      0.172603,
      44.921215,
      160,
      NULL,
      NULL,
      0.091200,
      2,
      3,
      3,
      0,
      0,
      0,
      0,
      2,
      0,
      1,
      2,
      3,
      3,
      2,
      0.235612,
      0.294785,
      0.421007,
      1,
      1.488025,
      NULL,
      1.581840,
      0,
      0.015597,
      1.842483,
      0,
      0.064501,
      1,
      NULL,
      1,
      NULL,
      6,
      5,
      NULL,
      6.792880,
      11.957830,
      6.832729,
      1,
      2,
      NULL,
      NULL,
      1,
      3,
      10.535676,
      1,
      3,
      38,
      NULL,
      NULL,
      61.449696,
      3,
      0.088763,
      3,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.916131,
      '',
      NULL,
      '',
      NULL,
      NULL,
      114,
      NULL,
      1,
      NULL,
      21,
      13.863341,
      5,
      0.418369,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.580598,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.017607,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      2,
      0.404804,
      0.719330,
      NULL,
      NULL,
      1.919596,
      NULL,
      NULL,
      3.030547,
      1.365664,
      0.495921,
      3.988071,
      1.660218,
      NULL,
      7,
      7.585617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0.341274,
      1,
      0.969596,
      3,
      1.395459,
      1,
      1,
      0.527362,
      NULL,
      NULL,
      1.774021,
      0,
      3,
      1.809388,
      0.470539,
      1.611909,
      NULL,
      1,
      2.235063,
      0,
      0.269966,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929768,
      1,
      0.812670,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.997223,
      0.144755,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.756480,
      NULL,
      NULL,
      0,
      0.409021,
      8.646973,
      3,
      1,
      2.674038,
      NULL,
      NULL,
      NULL,
      0,
      0.314359,
      1.223163,
      2,
      0.295198,
      1.065023,
      1.520083,
      NULL,
      NULL,
      0.459518,
      NULL,
      NULL,
      1.940729,
      NULL,
      NULL,
      2,
      NULL,
      0,
      9,
      1,
      0,
      0.871440,
      NULL,
      NULL,
      1.136174,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      3.349331,
      1.735203,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      1,
      NULL,
      0,
      0.597055,
      1.639224,
      NULL,
      3.722969,
      3,
      1,
      2,
      2,
      2,
      1,
      2,
      1.762901,
      3.873335,
      1.010357,
      0,
      NULL,
      NULL,
      2.349786,
      5,
      NULL,
      5,
      NULL,
      3,
      1,
      2,
      2,
      0,
      1,
      0.383344,
      NULL,
      0.425495,
      1.184418,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.016729,
      NULL,
      NULL,
      1.725019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847886,
      0.259827,
      0.472143,
      0,
      0.624990,
      2.452938,
      0.312804,
      NULL,
      NULL,
      1.715244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.380979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870547,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914610,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922285,
      NULL,
      NULL,
      NULL,
      0.854647,
      64.730826,
      189974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837120,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.779185,
      543.331915,
      10767.481598,
      0.017185,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.110630,
      0,
      0.032105,
      NULL,
      0.235620,
      1,
      0.229291,
      1.633790,
      0.226270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.759885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.164473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046734,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.366667,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.680332,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      4,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      2.440730,
      0.659579,
      1,
      1,
      NULL,
      NULL,
      2.835841,
      NULL,
      0,
      2.009943,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.519616,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.373188,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.679370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819310,
      NULL,
      0,
      NULL,
      1.220437,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      1,
      35,
      19,
      NULL,
      3.383846,
      3.275759,
      '10443',
      '',
      NULL,
      1.234960,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


