set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7800082';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '2014041',
      0,
      1,
      NULL,
      1,
      '1342',
      NULL,
      NULL,
      4,
      55,
      ' 7-22-1984',
      55,
      NULL,
      1,
      1,
      1.873007,
      ' 9- 6-1997',
      43,
      5.863046,
      76.981531,
      21.813710,
      3,
      NULL,
      NULL,
      ' 9-18-1981',
      3.640982,
      NULL,
      1.124242,
      1,
      0,
      0.124419,
      NULL,
      1,
      1.091475,
      2.659877,
      1,
      4,
      7,
      1,
      10.220744,
      2,
      NULL,
      0,
      3,
      4.478875,
      0.397674,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0.981193,
      0,
      0.066395,
      1,
      2,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0.258382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      0,
      1,
      0,
      0,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0.919331,
      NULL,
      0,
      2,
      0,
      2,
      0,
      4,
      2,
      0,
      0,
      5,
      1,
      NULL,
      NULL,
      2,
      5,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      3,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      2,
      0,
      3.340610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.703847,
      0,
      1.169468,
      0,
      0.594505,
      1.563907,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.427372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.290752,
      NULL,
      0.106357,
      0.326004,
      0.938106,
      1.242029,
      0.813528,
      0.592435,
      NULL,
      3.604440,
      1.679235,
      NULL,
      NULL,
      NULL,
      3,
      0.315811,
      1.513676,
      2,
      3,
      1,
      0,
      0,
      2,
      1,
      0,
      3,
      0,
      2.516163,
      3.596921,
      NULL,
      1,
      1.982300,
      1.611195,
      0.278295,
      1.657935,
      0,
      4,
      NULL,
      1,
      0,
      1.429789,
      1,
      0,
      0.269259,
      3.305898,
      1.576668,
      5,
      NULL,
      0.740144,
      0.134325,
      9.326415,
      5.826450,
      1,
      1.475030,
      4.597185,
      1,
      1.925881,
      0.395653,
      10.787238,
      1,
      1.406219,
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13401',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.005427,
      '2301',
      NULL,
      NULL,
      NULL,
      49.789730,
      179,
      41.523198,
      2.528854,
      NULL,
      1,
      NULL,
      0,
      1,
      1.553064,
      1.336217,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      1.173030,
      NULL,
      NULL,
      0.403619,
      NULL,
      NULL,
      3.564028,
      0,
      NULL,
      1.469170,
      NULL,
      NULL,
      2.142510,
      1.669714,
      0.553149,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.707619,
      1.161657,
      1.695753,
      3,
      0,
      1,
      3,
      0,
      1.509690,
      0,
      0,
      0.906238,
      0.366316,
      0.858857,
      NULL,
      0.823313,
      3.456781,
      0.995816,
      NULL,
      0.698752,
      3.757322,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.663475,
      NULL,
      NULL,
      NULL,
      8.965345,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.543090,
      3.225912,
      NULL,
      2.327766,
      3.060400,
      NULL,
      3.056848,
      0.086905,
      0.773048,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      0.545626,
      0.617835,
      1,
      NULL,
      NULL,
      0.255330,
      5.027737,
      NULL,
      1.336006,
      NULL,
      NULL,
      0.387832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540150,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.378613,
      0.371972,
      NULL,
      2,
      1.269922,
      0.778710,
      NULL,
      NULL,
      6.389684,
      3,
      7.051716,
      0,
      NULL,
      2.545591,
      0.713176,
      NULL,
      2,
      1.494455,
      1.740102,
      2,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      2.527854,
      NULL,
      NULL,
      1.833142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379185,
      0,
      NULL,
      5.228069,
      3.263663,
      8,
      7.013745,
      NULL,
      3.223784,
      4,
      NULL,
      3.685052,
      NULL,
      2.381140,
      1.264107,
      0,
      0.700190,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      16.895468,
      NULL,
      NULL,
      1.592621,
      NULL,
      NULL,
      3.152914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.695489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.142620,
      NULL,
      NULL,
      3.919404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.984833,
      1.354102,
      0.795394,
      1.164728,
      NULL,
      NULL,
      NULL,
      NULL,
      2.333213,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917978,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.859636,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.781498,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.896011,
      1.181250,
      NULL,
      NULL,
      1,
      1.112793,
      NULL,
      NULL,
      3.087740,
      3.125326,
      NULL,
      NULL,
      0.413941,
      1,
      NULL,
      NULL,
      NULL,
      2.866381,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.981606,
      114,
      108.608496,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      2.528915,
      1.865043,
      1,
      NULL,
      1,
      178.645589,
      4.092845,
      1.306141,
      0,
      0,
      NULL,
      NULL,
      1.829672,
      1,
      1,
      1,
      0.672186,
      1,
      NULL,
      NULL,
      1.841245,
      1.695200,
      NULL,
      1.601197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      9,
      2,
      NULL,
      5.091011,
      1,
      2.258976,
      3.294136,
      NULL,
      1,
      0.905013,
      0.005963,
      1.156306,
      NULL,
      0,
      1.500025,
      3.124384,
      0,
      0,
      NULL,
      2,
      1.384578,
      0.282720,
      1.065718,
      3,
      1,
      NULL,
      0.819915,
      1.368124,
      0,
      2.724643,
      NULL,
      1,
      0,
      1,
      3,
      NULL,
      0.452557,
      0,
      3,
      1.931546,
      1,
      NULL,
      2.161962,
      2.499292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404513,
      1,
      1,
      1.388960,
      0.778000,
      0.512740,
      0,
      5,
      4,
      1.476375,
      3.439563,
      NULL,
      55,
      33,
      2,
      NULL,
      2.926327,
      '44300',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      '2320',
      '2444',
      '0433');
commit;
end;
/


