set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924136';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.145810,
      NULL,
      3,
      '1302',
      3,
      0.389462,
      NULL,
      NULL,
      ' 6- 8-1997',
      4.248613,
      NULL,
      3,
      1,
      1.898940,
      NULL,
      NULL,
      2.774817,
      277,
      94.903302,
      3,
      NULL,
      '11-11-1986',
      ' 0-12-1976',
      2.389472,
      1.754290,
      0,
      1.565090,
      1.677872,
      2.748187,
      1,
      NULL,
      1.723614,
      12,
      3,
      6.818675,
      2.043355,
      2,
      32,
      NULL,
      30.717591,
      1,
      2,
      7.270849,
      1,
      0,
      1,
      1,
      1.819902,
      0,
      1.087207,
      NULL,
      NULL,
      0,
      1.850211,
      3,
      4,
      2,
      1.593710,
      3,
      NULL,
      1,
      1,
      5,
      0,
      3,
      1,
      1,
      0,
      3,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      1,
      1.700318,
      NULL,
      1,
      NULL,
      2,
      2,
      1.303633,
      1.377556,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      1.329894,
      1,
      1,
      1,
      6,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      4,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      4,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      4,
      NULL,
      1,
      1,
      5,
      3,
      3,
      1,
      0,
      0,
      NULL,
      5,
      0,
      0,
      4,
      1,
      4,
      4,
      5,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 5- 2-1977',
      NULL,
      '11- 5-1984',
      NULL,
      2.285878,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      0,
      1,
      1.734456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576569,
      0,
      6,
      1.703850,
      2,
      5.618275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.578961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812916,
      1,
      NULL,
      1.538192,
      NULL,
      1.140428,
      1.845038,
      2,
      32.910976,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      3,
      1,
      1,
      2,
      3,
      1,
      3,
      3,
      0,
      2,
      NULL,
      1.830925,
      1.158386,
      1,
      1.390415,
      1.582562,
      1,
      1,
      1.169355,
      0.727540,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      5.786138,
      4.484850,
      6,
      0.644957,
      NULL,
      7,
      NULL,
      0.273428,
      NULL,
      1,
      0,
      1.577438,
      NULL,
      NULL,
      2,
      NULL,
      58,
      34,
      17.338717,
      1,
      NULL,
      3,
      '23414',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      242.524696,
      NULL,
      2.533010,
      50,
      2.473179,
      1,
      0,
      2.490269,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0.905540,
      NULL,
      NULL,
      NULL,
      2.962995,
      3.636391,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.425627,
      1,
      1,
      2.486204,
      NULL,
      2.470054,
      0,
      2.743521,
      NULL,
      6.891187,
      1,
      3.023052,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055372,
      NULL,
      NULL,
      NULL,
      0.562410,
      2.040673,
      2,
      NULL,
      NULL,
      2.075275,
      0,
      0,
      0,
      3,
      1.042794,
      3,
      NULL,
      2.291954,
      1.787386,
      2,
      0,
      1.139204,
      NULL,
      0,
      0.087353,
      2.530864,
      2,
      2.285738,
      0.112142,
      1.016895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      0.442718,
      NULL,
      NULL,
      NULL,
      0.698667,
      NULL,
      NULL,
      NULL,
      0.185447,
      NULL,
      NULL,
      3.778926,
      1.762796,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.273295,
      0.169783,
      0,
      0,
      1.312952,
      0.832711,
      NULL,
      NULL,
      0,
      1.428684,
      0.952899,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.234815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.358982,
      1,
      1.729306,
      0.584907,
      2,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0.218336,
      NULL,
      NULL,
      NULL,
      2.468029,
      1,
      NULL,
      2,
      0,
      3,
      2,
      0,
      3,
      3.743518,
      1,
      0,
      1,
      NULL,
      3,
      3,
      0,
      0,
      3.291066,
      1,
      NULL,
      3.453722,
      2,
      NULL,
      0.052979,
      0.157324,
      1,
      0,
      1,
      3.276579,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.129823,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.107012,
      NULL,
      NULL,
      0.899818,
      NULL,
      NULL,
      2.872506,
      NULL,
      NULL,
      0,
      1,
      2.306255,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      1.055867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.959036,
      NULL,
      NULL,
      NULL,
      1.647118,
      NULL,
      NULL,
      NULL,
      0.873625,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.282840,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.472565,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.723417,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.656091,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.996789,
      1.855680,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.147740,
      NULL,
      NULL,
      0.892194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      147,
      NULL,
      0,
      1.493036,
      0,
      1.111631,
      1.948585,
      0.748404,
      0,
      0.081050,
      0.778314,
      1.440352,
      NULL,
      0,
      NULL,
      1.174945,
      0,
      0,
      1.477496,
      1.622767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651884,
      3,
      NULL,
      3,
      NULL,
      NULL,
      0.501694,
      1.581743,
      NULL,
      3,
      1.099566,
      NULL,
      0.272820,
      NULL,
      NULL,
      0,
      3.231626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.358113,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.127330,
      0.891539,
      NULL,
      1.136117,
      0.962145,
      NULL,
      0.058726,
      1.318926,
      0.853899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.091756,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.645165,
      NULL,
      0.175218,
      NULL,
      1,
      NULL,
      1.706970,
      1.086087,
      NULL,
      0.660138,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      1,
      7,
      2,
      0,
      0,
      38.608789,
      95,
      NULL,
      0,
      NULL,
      '10402',
      '',
      NULL,
      0.400287,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


