set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8920528';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '4222434',
      3.765570,
      0.166124,
      1,
      1,
      '0041',
      3,
      0,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      2,
      3,
      NULL,
      NULL,
      52,
      1,
      40,
      120.564873,
      2,
      ' 9-26-1998',
      NULL,
      '10-16-1981',
      NULL,
      1.322093,
      2.198800,
      1,
      0.639424,
      0.973405,
      0,
      1.926259,
      1.155069,
      177.071325,
      1,
      NULL,
      4,
      0,
      17.619049,
      5,
      1,
      5,
      NULL,
      4,
      1,
      0,
      0,
      0.630894,
      0,
      0.833095,
      1.524868,
      NULL,
      NULL,
      1,
      144.086463,
      8,
      NULL,
      3,
      0.565553,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      3,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.838762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.630712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      3.800295,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      3,
      2,
      0,
      4,
      3,
      5,
      NULL,
      NULL,
      3,
      3,
      NULL,
      3,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      2.385798,
      ' 2-15-1977',
      486,
      ' 8-29-1994',
      1188,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      0.119592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1004,
      2,
      2.232686,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.831071,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745299,
      1.092542,
      0.610117,
      1,
      1.793829,
      0.122913,
      1.949085,
      NULL,
      NULL,
      NULL,
      NULL,
      193,
      1069,
      908.820230,
      1,
      NULL,
      2.383044,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      2,
      0,
      0,
      3,
      1,
      0,
      0.475541,
      0,
      1.389163,
      3.538107,
      0,
      0,
      NULL,
      NULL,
      0.237046,
      0.517891,
      8,
      NULL,
      5,
      6.615782,
      9,
      1.527972,
      0,
      3.647959,
      0,
      NULL,
      1,
      1.492560,
      44.532798,
      NULL,
      3.361740,
      NULL,
      61,
      NULL,
      7,
      1,
      0,
      1.862268,
      '03330',
      '41430',
      '',
      1,
      '',
      '',
      '',
      5,
      '42241',
      '03232',
      NULL,
      NULL,
      46.713550,
      690,
      32,
      1,
      4,
      1.118968,
      0.318742,
      5,
      2,
      NULL,
      1,
      1.806912,
      NULL,
      NULL,
      0.608641,
      NULL,
      NULL,
      0,
      1.225054,
      1.388378,
      1,
      2,
      0.233823,
      1,
      2,
      0.774010,
      3.030568,
      3,
      0,
      1.872157,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.328870,
      3,
      1.973264,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.190544,
      1.359382,
      1,
      0.236313,
      2,
      0.944977,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.347810,
      1,
      0,
      0,
      NULL,
      1.035844,
      1.504288,
      0.827107,
      1.612093,
      3.941321,
      3.389301,
      2,
      1,
      0,
      1.581992,
      0.784297,
      NULL,
      NULL,
      0.770847,
      NULL,
      NULL,
      0.357919,
      NULL,
      NULL,
      7,
      2.356348,
      3.842905,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.327785,
      3,
      NULL,
      0.821309,
      1.738238,
      3,
      0,
      NULL,
      1,
      1,
      3,
      0.127627,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      5.951848,
      0.111995,
      1,
      0.646289,
      1.061617,
      NULL,
      NULL,
      NULL,
      2,
      6,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.152477,
      NULL,
      4.686194,
      0.989929,
      1,
      NULL,
      NULL,
      1.505787,
      NULL,
      0.418469,
      0,
      0.688242,
      0.698292,
      7,
      NULL,
      1,
      NULL,
      7.310884,
      2.764998,
      0,
      2,
      1,
      3.745936,
      2.580293,
      3,
      3.842907,
      1,
      1,
      6,
      0,
      NULL,
      NULL,
      1,
      2.356299,
      2.476545,
      0,
      1.862010,
      3.105741,
      3.403082,
      NULL,
      1,
      1,
      0,
      0,
      5,
      NULL,
      2,
      6,
      5.310453,
      0,
      3,
      2,
      1.477845,
      0.957213,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.653927,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.467324,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.877800,
      3,
      0.207421,
      NULL,
      2,
      1,
      0,
      NULL,
      8.603788,
      NULL,
      NULL,
      NULL,
      199.290621,
      NULL,
      2.835647,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.057063,
      NULL,
      3.601610,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.813366,
      NULL,
      3.673029,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.739143,
      NULL,
      0.417006,
      NULL,
      NULL,
      NULL,
      0.402774,
      NULL,
      1.532657,
      NULL,
      1.540647,
      NULL,
      0.002103,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.471492,
      NULL,
      1.928213,
      NULL,
      0.255289,
      NULL,
      NULL,
      NULL,
      1.152785,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8.591739,
      NULL,
      8,
      NULL,
      2.861177,
      NULL,
      1.400948,
      NULL,
      NULL,
      NULL,
      3.656112,
      175,
      NULL,
      1.029272,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.739922,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.344723,
      NULL,
      NULL,
      3,
      32.969106,
      0.319399,
      NULL,
      NULL,
      1,
      0.827364,
      1.324900,
      1.597108,
      0.010613,
      2,
      0,
      1.393025,
      1.434329,
      1.798252,
      0.690757,
      1,
      0.457208,
      0,
      1.618430,
      2.407832,
      1.401487,
      1.238525,
      NULL,
      NULL,
      NULL,
      0.846820,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.572516,
      NULL,
      5,
      NULL,
      1.847187,
      NULL,
      38.380510,
      0.061849,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.722691,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.576687,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.285900,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.502143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      6,
      1,
      NULL,
      1.974735,
      2,
      9.557761,
      3.555180,
      NULL,
      0,
      0.196216,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.520786,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.672432,
      NULL,
      NULL,
      1.132055,
      0.998392,
      NULL,
      NULL,
      1.959949,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457703,
      1.612618,
      NULL,
      NULL,
      1.787805,
      1.984760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929294,
      NULL,
      1,
      NULL,
      0.610457,
      NULL,
      0,
      5,
      1,
      1.141022,
      3.386474,
      3,
      37.197355,
      26.899597,
      1,
      0.233125,
      1,
      '32440',
      '41241',
      '',
      1.407470,
      '',
      '',
      '',
      2.373270,
      '12024',
      '00314',
      '23404');
commit;
end;
/


