set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8418200';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0043221',
      NULL,
      0.113944,
      3,
      1,
      '4223',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1988',
      NULL,
      NULL,
      3,
      NULL,
      3,
      ' 0-21-1989',
      19.137382,
      1,
      320,
      92,
      0,
      ' 6-24-1975',
      ' 6-19-1996',
      NULL,
      1.390232,
      2.184858,
      1,
      3.847874,
      2,
      1.154495,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.915515,
      3,
      NULL,
      2.755660,
      2,
      NULL,
      2,
      2,
      0,
      1.976177,
      NULL,
      NULL,
      NULL,
      0.105498,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.782180,
      4,
      5,
      1,
      2,
      1,
      1,
      1,
      0,
      1,
      0,
      4,
      3,
      0,
      0,
      NULL,
      0,
      1,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.649139,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      0,
      0.909074,
      1,
      NULL,
      0.867340,
      NULL,
      0.870460,
      0,
      3.388579,
      0.037094,
      0,
      0.172027,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      2,
      3,
      2,
      NULL,
      0.116364,
      NULL,
      NULL,
      1.944981,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      4,
      4,
      1,
      2,
      4,
      1,
      3,
      0,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      0,
      0,
      0,
      1,
      0,
      3,
      5,
      5,
      0,
      3,
      NULL,
      4,
      1,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0,
      ' 0- 1-1983',
      NULL,
      ' 2-13-1978',
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.548111,
      2.896560,
      2,
      NULL,
      1,
      3,
      3.433802,
      1.796720,
      0.879548,
      1.459942,
      0,
      NULL,
      4,
      7.775809,
      11,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.803984,
      1.453756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576520,
      1.743380,
      1.944993,
      0,
      1.007789,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.320205,
      3.054895,
      0,
      0,
      2,
      1,
      0,
      3,
      3,
      1,
      1,
      0,
      2.389415,
      3.413519,
      NULL,
      NULL,
      1,
      NULL,
      1.929442,
      1.023185,
      0,
      1,
      1,
      1,
      1.033892,
      1.526382,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      30,
      40,
      47.217231,
      1,
      0.646485,
      0.489985,
      '21014',
      '20224',
      '32220',
      1,
      '',
      '',
      '',
      0.428940,
      '',
      '',
      '',
      1.947373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261358,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.267936,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.700915,
      NULL,
      NULL,
      462.775700,
      1,
      0.409217,
      NULL,
      0.104341,
      NULL,
      1,
      NULL,
      0,
      0.815867,
      NULL,
      1,
      3.261054,
      0.776560,
      0.390919,
      0.746387,
      0.835822,
      NULL,
      0.726479,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295895,
      NULL,
      NULL,
      NULL,
      1.436115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701870,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.264274,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.513830,
      1.066381,
      1.577950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.733507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514251,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995775,
      0.024361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.969437,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      NULL,
      NULL,
      NULL,
      3.712814,
      0.406073,
      1,
      NULL,
      0.924360,
      NULL,
      78,
      NULL,
      2.749938,
      NULL,
      0.311959,
      NULL,
      2.181692,
      NULL,
      0.009793,
      0,
      6.621696,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      2,
      1,
      NULL,
      0,
      0,
      0,
      3,
      1,
      0,
      NULL,
      0,
      NULL,
      1.877075,
      NULL,
      NULL,
      NULL,
      1.099395,
      NULL,
      1,
      1.096619,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1.882590,
      1.400901,
      NULL,
      0,
      1.932037,
      NULL,
      NULL,
      0.275143,
      NULL,
      0,
      0.252186,
      NULL,
      2,
      2.574720,
      NULL,
      2.649750,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750159,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      5,
      2,
      0.867218,
      NULL,
      NULL,
      37,
      87.270180,
      0,
      1.808800,
      7,
      '13110',
      '41230',
      '10100',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


