set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9684860';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '12',
      25,
      21,
      '1012240',
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.098270,
      NULL,
      NULL,
      ' 8-14-1987',
      NULL,
      2,
      NULL,
      0,
      0.121067,
      ' 0- 8-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 2- 9-1998',
      ' 7-21-1978',
      ' 4-10-1991',
      2.377396,
      0,
      3,
      3,
      0.342845,
      NULL,
      NULL,
      0.105839,
      1,
      101,
      0,
      18,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      1,
      2,
      0,
      0,
      0,
      0,
      1,
      3.119736,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      5,
      2,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      2.350757,
      NULL,
      5.582979,
      2,
      NULL,
      0,
      1,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      2,
      0,
      5,
      NULL,
      NULL,
      0,
      3,
      4,
      0,
      NULL,
      2,
      3,
      NULL,
      0.159204,
      2.340573,
      ' 4-19-1997',
      34.067476,
      '10- 8-1984',
      363,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0.248618,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.258498,
      0.247795,
      0.442243,
      2,
      0,
      1.791343,
      1,
      3.877344,
      4.290429,
      2.937448,
      1.010242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.122693,
      NULL,
      3,
      3,
      1,
      0,
      3,
      NULL,
      0,
      0,
      0,
      NULL,
      4.481753,
      2,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0.054240,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.450036,
      1.485029,
      11,
      NULL,
      6,
      8.116720,
      4,
      6.119506,
      NULL,
      0.618142,
      6.654373,
      1,
      0,
      1.057233,
      NULL,
      3,
      0,
      33,
      NULL,
      NULL,
      54,
      3,
      NULL,
      NULL,
      '42223',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.171349,
      13.862554,
      9,
      37,
      NULL,
      35.042432,
      0,
      1,
      5,
      3.030668,
      3.848074,
      3.449499,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.108682,
      1,
      2,
      3.533965,
      0,
      0.099881,
      1.829104,
      NULL,
      NULL,
      NULL,
      3,
      1.374244,
      1.249402,
      NULL,
      NULL,
      1.012018,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.738416,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.608072,
      1.118795,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414265,
      NULL,
      NULL,
      NULL,
      1.712965,
      NULL,
      0.790955,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.666208,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.440374,
      NULL,
      2,
      0.741678,
      NULL,
      1.679729,
      0.393695,
      NULL,
      NULL,
      7.248374,
      4,
      4.831052,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.734299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434550,
      NULL,
      1,
      3,
      1.665684,
      2.510951,
      NULL,
      3.593730,
      2.721162,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.392318,
      2,
      5,
      3.925769,
      2,
      1.015024,
      1,
      3,
      1,
      2.581806,
      0.975937,
      3,
      2,
      3,
      6.411584,
      9.539347,
      NULL,
      0,
      3,
      1.868434,
      3,
      3,
      2,
      3.788648,
      1,
      NULL,
      2.644422,
      2.162790,
      NULL,
      7,
      2,
      5,
      NULL,
      NULL,
      0.701896,
      0.338404,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.884059,
      NULL,
      NULL,
      0.635099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.273342,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      2.693323,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.044336,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.609246,
      NULL,
      NULL,
      NULL,
      1.792833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461844,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3,
      0.243173,
      4,
      1,
      2.102615,
      21.769906,
      NULL,
      3,
      4.740406,
      0.833947,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.625126,
      NULL,
      NULL,
      0.405344,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      314,
      5,
      1.486096,
      1.126849,
      0.066233,
      1.197043,
      1.705461,
      0.364959,
      NULL,
      1,
      0.393036,
      0,
      0,
      0,
      1,
      NULL,
      1.408365,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.966948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.804388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762481,
      1.228654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.536695,
      NULL,
      NULL,
      NULL,
      10,
      0.296660,
      NULL,
      NULL,
      0.912489,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.823813,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.699439,
      3,
      3.133898,
      NULL,
      2,
      4.223150,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.747286,
      1.645433,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.554596,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.730033,
      1,
      NULL,
      0,
      0.851698,
      NULL,
      0.038761,
      3.989334,
      NULL,
      0,
      1.742155,
      1.205075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891630,
      NULL,
      1.192415,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      3,
      0.370373,
      3,
      41,
      37.283233,
      NULL,
      2.832236,
      2.339059,
      '00442',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


