set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501739';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '3212112',
      3,
      0,
      1,
      1,
      '0344',
      NULL,
      0.690880,
      NULL,
      NULL,
      NULL,
      94.208950,
      NULL,
      3,
      1.364949,
      1.847868,
      ' 1-10-1986',
      17.865536,
      4,
      211,
      115.541943,
      NULL,
      NULL,
      ' 6-19-1996',
      ' 2- 0-1999',
      0,
      1,
      1,
      2.767591,
      NULL,
      0.147145,
      1,
      3.171501,
      NULL,
      NULL,
      NULL,
      3,
      7,
      11,
      8.759449,
      NULL,
      4.420724,
      1,
      2,
      3.331802,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      3.724861,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      0,
      0,
      0,
      2.571675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      4,
      2,
      0,
      NULL,
      1,
      3,
      NULL,
      1.268160,
      NULL,
      2,
      NULL,
      1.909204,
      0,
      1.813248,
      NULL,
      0,
      3.141140,
      0,
      1,
      1,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      3,
      1,
      1,
      NULL,
      1,
      1.790507,
      NULL,
      NULL,
      4,
      5,
      0,
      3,
      1,
      5,
      4,
      5,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      2,
      3,
      4,
      2,
      1,
      4,
      NULL,
      2,
      2,
      2,
      0,
      8,
      0,
      ' 0-16-1987',
      NULL,
      NULL,
      4,
      0.358805,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.713746,
      0.858853,
      0.760725,
      NULL,
      0.968010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148451,
      2.259100,
      0.279138,
      1.306890,
      1.340910,
      1,
      NULL,
      NULL,
      39.521386,
      0.381745,
      0.386341,
      NULL,
      NULL,
      NULL,
      0,
      1.788669,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      2,
      1,
      2,
      2,
      8.751499,
      0.644578,
      0.572749,
      0.539003,
      1,
      0.025402,
      NULL,
      1,
      1.166468,
      NULL,
      1.653381,
      0,
      NULL,
      0,
      2.370461,
      NULL,
      8,
      5.276855,
      7.055235,
      3.511816,
      NULL,
      5.102983,
      5.588831,
      2.596887,
      4.289366,
      0.180322,
      NULL,
      3.594829,
      NULL,
      NULL,
      0,
      NULL,
      48,
      24,
      51.722021,
      3,
      NULL,
      NULL,
      NULL,
      '31242',
      NULL,
      0,
      NULL,
      '',
      '',
      1.283489,
      NULL,
      NULL,
      '',
      1.836998,
      26.539372,
      NULL,
      NULL,
      0,
      37.383354,
      20.770248,
      92,
      NULL,
      1,
      0.412578,
      1.283030,
      1.892433,
      2,
      0,
      2,
      NULL,
      0.859170,
      1.098162,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.953713,
      NULL,
      NULL,
      3.668325,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127490,
      1,
      0,
      3,
      1.120197,
      NULL,
      NULL,
      1,
      NULL,
      1.969423,
      0.092177,
      3.126374,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      2.993895,
      NULL,
      3,
      NULL,
      0.000249,
      0.364692,
      1.402730,
      1.491991,
      2,
      0,
      2.942707,
      3.056584,
      1,
      1,
      1,
      2.203325,
      0.923933,
      NULL,
      0.690903,
      2,
      NULL,
      0.723009,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.064303,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.320190,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.192499,
      1.241481,
      0.083062,
      0,
      NULL,
      NULL,
      NULL,
      0.122407,
      7.289386,
      1.575852,
      NULL,
      3,
      1.787350,
      NULL,
      NULL,
      4.433347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.183670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.612992,
      NULL,
      NULL,
      0,
      1,
      1.322382,
      NULL,
      0,
      0,
      3.288435,
      NULL,
      NULL,
      7.301890,
      3.607558,
      2,
      3.025550,
      NULL,
      0.570727,
      1,
      NULL,
      NULL,
      NULL,
      1.136066,
      3,
      3.018789,
      0,
      1.931086,
      NULL,
      1.294080,
      3,
      3,
      NULL,
      NULL,
      0.723910,
      NULL,
      1.558429,
      3,
      1,
      0,
      3,
      1,
      3.855104,
      8.982456,
      0,
      0.959582,
      5.425477,
      1,
      NULL,
      3.483265,
      0,
      1,
      0,
      1,
      0,
      0,
      0.282064,
      0.193557,
      NULL,
      NULL,
      1.195543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571605,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.813067,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.544267,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.699943,
      NULL,
      NULL,
      1,
      1.129374,
      0,
      0,
      NULL,
      2.585300,
      0.594459,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.186526,
      NULL,
      NULL,
      NULL,
      2.658197,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.978066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      562.714590,
      335.388607,
      1.506341,
      328.836681,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.108762,
      1,
      NULL,
      NULL,
      NULL,
      9,
      1.135397,
      171.586963,
      54,
      1.934665,
      1,
      0.233777,
      1,
      1.165915,
      NULL,
      1.728674,
      1.690942,
      1.379024,
      0,
      1,
      0.429596,
      1.380490,
      1,
      NULL,
      1.302096,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1.144299,
      0,
      1,
      0.097911,
      NULL,
      2,
      2.322614,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      3.467772,
      2.469636,
      2.466243,
      NULL,
      2.058612,
      1.832279,
      1.818332,
      1.189908,
      2.219723,
      0.030206,
      3,
      NULL,
      NULL,
      0,
      1,
      0.887598,
      0,
      1.109522,
      1.884311,
      1.243409,
      NULL,
      0.273001,
      0.045502,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.218931,
      0,
      1.764703,
      1.710651,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      1,
      69,
      NULL,
      2.294754,
      2.116427,
      '30220',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.502639,
      '',
      '',
      NULL);
commit;
end;
/


