set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9007923';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      NULL,
      1,
      1.191125,
      NULL,
      NULL,
      ' 1-21-1981',
      NULL,
      NULL,
      2,
      0.114311,
      0.078641,
      ' 1-19-1993',
      45.265209,
      3.357616,
      105,
      31.807822,
      2,
      NULL,
      ' 3-29-1983',
      ' 9-29-1974',
      2.317045,
      0.865339,
      2,
      0.563222,
      1,
      1.302436,
      7,
      NULL,
      1,
      70,
      NULL,
      14.093908,
      5.548463,
      33.716356,
      20.369139,
      3,
      1,
      5,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      3,
      0,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1.715441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1,
      NULL,
      4,
      0,
      1,
      5,
      0,
      NULL,
      NULL,
      0,
      8,
      1,
      NULL,
      0,
      1,
      1.480065,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      1,
      4,
      NULL,
      1,
      2,
      5,
      1,
      0,
      2,
      1,
      2,
      5,
      NULL,
      5,
      2,
      NULL,
      2,
      1,
      0,
      5,
      4,
      5,
      0,
      NULL,
      350.103590,
      ' 0-11-1978',
      NULL,
      1.892832,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.389837,
      1,
      1,
      2.146001,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.703998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336934,
      1,
      0.396934,
      0,
      NULL,
      0,
      0,
      3,
      NULL,
      1.756793,
      0.910936,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.204778,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      0.120185,
      3,
      2,
      0.177216,
      NULL,
      0,
      2.563155,
      1,
      NULL,
      1,
      1,
      1.420742,
      1,
      NULL,
      0,
      NULL,
      1,
      1.561865,
      NULL,
      2.644911,
      8.956287,
      1.032960,
      7,
      10.574946,
      5.197846,
      3.992153,
      NULL,
      0,
      NULL,
      3.899219,
      0.587992,
      13.872811,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      67.902211,
      5,
      1,
      1,
      '43132',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      2,
      25,
      326,
      31,
      1,
      16,
      15.498056,
      43.787336,
      5,
      NULL,
      2,
      NULL,
      1.567976,
      NULL,
      NULL,
      2,
      0.590236,
      NULL,
      3.423943,
      NULL,
      2.013087,
      3,
      3,
      NULL,
      1,
      3,
      NULL,
      0.259229,
      2,
      0,
      1,
      NULL,
      NULL,
      1.661956,
      1.306926,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.260789,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237231,
      NULL,
      NULL,
      NULL,
      0,
      1.746113,
      NULL,
      1,
      NULL,
      NULL,
      0.182220,
      NULL,
      NULL,
      1,
      0.937478,
      1.133335,
      NULL,
      0.127461,
      2.802551,
      0,
      0.947643,
      1,
      NULL,
      1,
      0.656079,
      1.727281,
      1.465267,
      1.864021,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      1.149534,
      NULL,
      NULL,
      5.805808,
      1,
      1.719213,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.053895,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3.383150,
      0,
      3.038543,
      NULL,
      1.549597,
      1,
      8.935032,
      1,
      0.722673,
      NULL,
      NULL,
      NULL,
      1.666834,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.414393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112969,
      NULL,
      NULL,
      NULL,
      1.020316,
      2,
      0.803806,
      NULL,
      NULL,
      3.430863,
      0.161505,
      0,
      NULL,
      1.694925,
      3.359374,
      0.228034,
      0,
      1,
      NULL,
      0,
      2.537443,
      3.146815,
      2.105360,
      NULL,
      NULL,
      0.331056,
      3,
      7.164074,
      NULL,
      3.272622,
      1.938990,
      1,
      3,
      3,
      2.153990,
      3,
      NULL,
      2.702079,
      2.737092,
      2,
      NULL,
      0.123879,
      8.916252,
      NULL,
      2,
      1.325222,
      1,
      1.563682,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      0,
      0.664481,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.867942,
      NULL,
      NULL,
      1.254863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716714,
      NULL,
      NULL,
      3.365686,
      NULL,
      NULL,
      1.771353,
      1,
      1.859106,
      NULL,
      1.287434,
      2,
      0.153570,
      NULL,
      NULL,
      3.531239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.718592,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922911,
      NULL,
      NULL,
      NULL,
      1.077160,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.921906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.308688,
      1,
      3,
      3,
      520,
      384,
      1.312235,
      3.708821,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587261,
      NULL,
      NULL,
      1.180985,
      NULL,
      NULL,
      1.032482,
      NULL,
      NULL,
      1.866103,
      20.792598,
      NULL,
      187.889829,
      NULL,
      0.941778,
      0,
      1.169985,
      0.853343,
      1,
      1.888513,
      1,
      1.929378,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.643681,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      3.993494,
      1.186172,
      3,
      3.956980,
      NULL,
      12,
      2.841125,
      3,
      1.990726,
      0,
      NULL,
      NULL,
      1.813175,
      NULL,
      NULL,
      2.684198,
      2.030887,
      NULL,
      0.549273,
      1,
      NULL,
      1.702156,
      3,
      NULL,
      1,
      1.380349,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.701455,
      NULL,
      1.785997,
      0,
      NULL,
      1,
      2.519873,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.640746,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      2,
      3,
      2.218975,
      64.293052,
      34.869791,
      5,
      NULL,
      2,
      '32143',
      '',
      '',
      2,
      '41124',
      '',
      '',
      0.619818,
      NULL,
      '',
      '');
commit;
end;
/


