set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000172';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '2021313',
      NULL,
      1.448680,
      3,
      0,
      '2303',
      3.334249,
      2,
      3,
      40,
      ' 8- 6-1996',
      68.131485,
      NULL,
      NULL,
      0.676227,
      0.075301,
      ' 2-27-1984',
      23,
      NULL,
      264,
      20.476367,
      0,
      NULL,
      NULL,
      ' 8-25-1998',
      2,
      0.837699,
      NULL,
      1.158437,
      1.982923,
      3,
      5,
      2.385237,
      NULL,
      NULL,
      NULL,
      0,
      8.842096,
      20,
      21,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1.094073,
      0.327623,
      1.299370,
      NULL,
      NULL,
      3,
      3,
      3.147185,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1.300914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.959270,
      0.609970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      1.323065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884764,
      0,
      0,
      1.268542,
      1.850655,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.273887,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724363,
      0,
      NULL,
      0,
      NULL,
      1,
      0.853656,
      0.976457,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.372752,
      2.610165,
      2,
      3,
      0,
      2,
      2,
      1,
      0,
      1,
      3,
      2,
      3,
      1,
      0.452137,
      4.176238,
      0.784954,
      NULL,
      2,
      3,
      1.098402,
      NULL,
      1,
      NULL,
      0.636823,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      9.055524,
      7.649869,
      3,
      2.921175,
      0.674621,
      3.707251,
      NULL,
      6,
      1,
      3.163609,
      3,
      5.651784,
      2,
      1,
      38,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.116426,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      3,
      51.892939,
      8.574561,
      0,
      NULL,
      2.855650,
      1.247700,
      3,
      NULL,
      NULL,
      1.797326,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.204643,
      NULL,
      NULL,
      1.511403,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.990022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316089,
      NULL,
      NULL,
      0.665176,
      NULL,
      NULL,
      1.100297,
      NULL,
      NULL,
      2.007436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208065,
      NULL,
      NULL,
      1.549490,
      NULL,
      NULL,
      1.859907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.228799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.137324,
      NULL,
      NULL,
      2,
      2.666249,
      1.411351,
      NULL,
      NULL,
      1.057632,
      NULL,
      NULL,
      0.133405,
      1.262433,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.743014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.768813,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.123079,
      NULL,
      NULL,
      1.073096,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928673,
      NULL,
      NULL,
      1.779868,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.987916,
      NULL,
      NULL,
      0,
      10.349033,
      1.601215,
      16,
      NULL,
      NULL,
      1.225720,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      1.359342,
      5.973881,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.801696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.199288,
      NULL,
      NULL,
      1.415521,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.487517,
      NULL,
      2.263500,
      0,
      1.455757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.115217,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.914910,
      NULL,
      NULL,
      NULL,
      1.423894,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.150036,
      NULL,
      NULL,
      NULL,
      3.838443,
      NULL,
      NULL,
      NULL,
      2.549413,
      NULL,
      NULL,
      NULL,
      1.371279,
      NULL,
      NULL,
      NULL,
      1.354635,
      NULL,
      NULL,
      NULL,
      2.023005,
      1,
      NULL,
      NULL,
      NULL,
      1.290992,
      NULL,
      NULL,
      2.824679,
      NULL,
      1,
      0.253263,
      NULL,
      NULL,
      0.793865,
      NULL,
      NULL,
      1.561973,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.594391,
      NULL,
      1.725102,
      358,
      NULL,
      NULL,
      1.584058,
      0,
      0,
      0,
      0.651968,
      0,
      3,
      0,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.320907,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.839908,
      1,
      0.499726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041880,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015814,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087177,
      0.482245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.286546,
      1.213507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107976,
      NULL,
      1,
      NULL,
      1.329096,
      0.261625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.013133,
      1.747068,
      1,
      NULL,
      0,
      NULL,
      1,
      1.811786,
      NULL,
      1.833676,
      0.242839,
      0,
      0.950096,
      NULL,
      1.663555,
      NULL,
      16,
      1.420908,
      1,
      0.948446,
      NULL,
      3.829297,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1.730956,
      NULL,
      1.454869,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0.901868,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992803,
      3,
      2.902751,
      3,
      NULL,
      0,
      NULL,
      1.790301,
      3.137973,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.297718,
      0,
      2,
      1.205279,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.887238,
      0,
      8.566883,
      0,
      NULL,
      1.444489,
      0,
      NULL,
      0,
      1.962865,
      1.615610,
      NULL,
      3,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.964052,
      0.199011,
      '13342',
      '31420',
      '',
      0.255606,
      '',
      '',
      '',
      3.809240,
      '31343',
      NULL,
      '');
commit;
end;
/


