set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      0,
      0.408089,
      1,
      2,
      '2421',
      2.526295,
      1.457005,
      NULL,
      NULL,
      '10-25-1981',
      44,
      NULL,
      2,
      0.859041,
      0.188038,
      '11-13-2001',
      NULL,
      3,
      NULL,
      276,
      NULL,
      NULL,
      ' 8-13-1985',
      ' 2- 0-1989',
      0.675889,
      2,
      1,
      0.122679,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      7.531768,
      14,
      5,
      1,
      3.619465,
      4,
      1,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      2.262487,
      2,
      NULL,
      3,
      3,
      0,
      1,
      4,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.567984,
      0.350822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0,
      1.880721,
      NULL,
      1.604987,
      NULL,
      5,
      2,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      4,
      0,
      NULL,
      1,
      4,
      5,
      0,
      5,
      0,
      5,
      0,
      NULL,
      NULL,
      40,
      ' 9-26-1985',
      2,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.832961,
      2,
      NULL,
      1.803098,
      1.559384,
      1.355193,
      NULL,
      1.937166,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400840,
      1,
      0,
      0,
      0,
      NULL,
      0,
      3.341084,
      NULL,
      3.687893,
      1.655846,
      NULL,
      NULL,
      NULL,
      2,
      0.422088,
      0.594863,
      0,
      0,
      1,
      NULL,
      1,
      3,
      2,
      3,
      2,
      0,
      3.474728,
      2.256606,
      NULL,
      2.131711,
      1,
      NULL,
      2.801108,
      0,
      1,
      NULL,
      NULL,
      1,
      0.995741,
      1.874862,
      NULL,
      0,
      1,
      NULL,
      1.465060,
      10.736635,
      5.397495,
      0.619574,
      9.680422,
      11.597152,
      5.752022,
      0,
      0,
      6,
      1.423826,
      NULL,
      3.020961,
      49,
      3,
      0.711722,
      NULL,
      39,
      58,
      13,
      0,
      1,
      3.337828,
      '44412',
      '31121',
      '33131',
      0.453787,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.247665,
      19.384933,
      226.021204,
      33.190396,
      1,
      46.721466,
      0,
      0.118460,
      0,
      2.698332,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      3,
      1.237924,
      2.417104,
      3.031206,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220088,
      NULL,
      0.931334,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3.473434,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4,
      1,
      3,
      1.902575,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.961429,
      NULL,
      NULL,
      1.881261,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.684048,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566356,
      NULL,
      NULL,
      1.520900,
      1,
      0,
      1.289556,
      NULL,
      1.487777,
      1.148715,
      NULL,
      NULL,
      3.699163,
      5.422148,
      NULL,
      3.253007,
      1.995810,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.968314,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.167486,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.166640,
      1.895058,
      3,
      0.694981,
      0.170742,
      0.938217,
      0,
      NULL,
      NULL,
      0,
      1.384315,
      1,
      3.105129,
      3,
      0.634079,
      5.186305,
      3,
      4.675651,
      0.277436,
      2,
      0.094408,
      3,
      2.301873,
      0.865414,
      NULL,
      3.261656,
      1.772790,
      2,
      NULL,
      0.044531,
      NULL,
      NULL,
      5,
      2,
      0.204861,
      2,
      2,
      0,
      2,
      1,
      0,
      0.231626,
      1.585301,
      1,
      NULL,
      NULL,
      NULL,
      3.072427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.356892,
      NULL,
      NULL,
      1.245234,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.365225,
      NULL,
      NULL,
      0.564797,
      0,
      NULL,
      1.524478,
      1,
      1.770149,
      0.959778,
      NULL,
      NULL,
      2.278859,
      2.146382,
      NULL,
      NULL,
      1.648605,
      NULL,
      NULL,
      NULL,
      0.896368,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.433349,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.508507,
      NULL,
      NULL,
      NULL,
      1.632826,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.707287,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.470681,
      0.844378,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.044730,
      NULL,
      NULL,
      2,
      3.464576,
      NULL,
      NULL,
      0.823664,
      NULL,
      NULL,
      NULL,
      3,
      130,
      38.902498,
      0.899584,
      NULL,
      NULL,
      1.573782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.871441,
      NULL,
      NULL,
      0,
      NULL,
      0,
      856,
      NULL,
      0.172456,
      0.190084,
      1.995006,
      NULL,
      1,
      0,
      0.345890,
      3,
      1.531918,
      3.106153,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1.898948,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.537433,
      NULL,
      1.750985,
      NULL,
      12,
      NULL,
      2.758070,
      14.610922,
      NULL,
      0,
      2,
      1.534199,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.050161,
      NULL,
      1.440193,
      NULL,
      NULL,
      NULL,
      1.513356,
      NULL,
      0,
      NULL,
      2.677670,
      NULL,
      1,
      NULL,
      1.076664,
      NULL,
      0,
      NULL,
      0.660759,
      NULL,
      1,
      NULL,
      1.395099,
      1.640485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.849588,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.418133,
      NULL,
      1.735065,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.714083,
      NULL,
      NULL,
      NULL,
      0.229563,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391551,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      42,
      NULL,
      NULL,
      NULL,
      0.864882,
      NULL,
      3,
      0.947239,
      0.977996,
      14,
      NULL,
      3.332032,
      2.266976,
      1.636833,
      1,
      2,
      2,
      0,
      2.541506,
      1,
      0,
      3,
      NULL,
      4.403620,
      NULL,
      2.397943,
      3,
      0.427514,
      3.320287,
      NULL,
      0,
      2.444349,
      2,
      1.339113,
      2.088438,
      2.591950,
      0,
      1,
      1,
      2,
      1,
      2.290957,
      1,
      2,
      1,
      1.743455,
      0.364749,
      0,
      0,
      2,
      1.936492,
      NULL,
      1.552859,
      0,
      0.576535,
      2,
      3.618162,
      1,
      0.982291,
      1,
      3.350687,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727188,
      1.083350,
      0,
      0.926946,
      1,
      3.604387,
      3.703381,
      1,
      NULL,
      0.493341,
      1.708406,
      NULL,
      1.290336,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.792766,
      NULL,
      3.374279,
      NULL,
      NULL,
      2.709977,
      1.761073,
      1.972934,
      0.187387,
      36.754128,
      1,
      NULL,
      0.584461,
      0.808236,
      0,
      2,
      NULL,
      1.379649,
      2,
      0,
      5,
      0,
      NULL,
      0.408816,
      17,
      8,
      0,
      NULL,
      0.022872,
      '43443',
      '01433',
      '41032',
      1,
      '',
      '',
      '',
      0.388852,
      '',
      '',
      '');
commit;
end;
/


