set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9970404';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.083573,
      1.363300,
      7.242294,
      4,
      0,
      4.831332,
      1.838998,
      3.646119,
      '344',
      NULL,
      69.431862,
      60.547491,
      '4230010',
      3,
      1,
      4,
      3,
      '4043',
      3,
      1,
      NULL,
      NULL,
      ' 6- 0-2001',
      134.222542,
      190,
      NULL,
      3.967096,
      0.667932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 5-13-2000',
      ' 4-26-1985',
      '10-16-1999',
      0.716783,
      3,
      0.481786,
      1,
      1.991580,
      3.341067,
      1,
      1.779818,
      1.408374,
      2.587261,
      0,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0.617282,
      NULL,
      NULL,
      1,
      0.013467,
      NULL,
      1,
      1.559935,
      2,
      4,
      NULL,
      2.197528,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      1,
      NULL,
      0,
      2,
      0,
      0,
      0,
      0,
      NULL,
      0.624576,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.026221,
      0.562241,
      0,
      1.164926,
      0,
      2,
      2,
      1.882684,
      2,
      0.197962,
      0,
      2.274594,
      1.717766,
      0.118787,
      2,
      1,
      0,
      3,
      3,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0.397103,
      1,
      0,
      1,
      1,
      0,
      0,
      4,
      0,
      2,
      NULL,
      1,
      NULL,
      5,
      0,
      NULL,
      5,
      3,
      0,
      1,
      5,
      5,
      5,
      5,
      NULL,
      0,
      NULL,
      1.949654,
      ' 9-26-1975',
      638,
      ' 2- 1-2003',
      NULL,
      0.992457,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      0,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332140,
      0,
      7.573093,
      5,
      1,
      5.500555,
      2.378615,
      0.478239,
      NULL,
      0,
      0,
      2.240205,
      0.951945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      0.603737,
      0.428253,
      NULL,
      1.513058,
      19,
      1.653243,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.105489,
      0,
      1,
      1,
      2,
      NULL,
      1,
      2,
      2,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.957293,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.520683,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      5.745510,
      2.353954,
      3.915711,
      4.257002,
      8,
      5.489893,
      0,
      2,
      1.488370,
      0.669916,
      1,
      3.040647,
      22.139429,
      1,
      3,
      NULL,
      NULL,
      17,
      47,
      4,
      NULL,
      2.134305,
      '13300',
      '',
      '',
      1,
      '',
      NULL,
      '',
      2.343160,
      '1400',
      '',
      '',
      2,
      14,
      206.716790,
      24.038519,
      NULL,
      30,
      NULL,
      NULL,
      0,
      0,
      1.058177,
      0,
      0,
      NULL,
      NULL,
      1.773903,
      NULL,
      NULL,
      1.275896,
      2,
      3,
      0.238700,
      NULL,
      NULL,
      1,
      NULL,
      3.393846,
      2.021868,
      3.667238,
      NULL,
      3.681611,
      3.397993,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      3,
      3,
      NULL,
      3,
      5.323055,
      7,
      0,
      NULL,
      1.335515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.809687,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.445649,
      3,
      0,
      3.911725,
      0.636987,
      1,
      NULL,
      3,
      1,
      0.477228,
      3.289238,
      0.643231,
      3.066099,
      2,
      0,
      NULL,
      2,
      2,
      1.259472,
      NULL,
      NULL,
      NULL,
      2.999171,
      1.240603,
      0.684458,
      1,
      NULL,
      4.298428,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829052,
      NULL,
      NULL,
      NULL,
      NULL,
      3.310226,
      1.945916,
      NULL,
      NULL,
      4,
      4.127084,
      2.768214,
      3.157101,
      0,
      0,
      2.090825,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185201,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.380780,
      1.298718,
      1,
      NULL,
      NULL,
      1.603964,
      NULL,
      NULL,
      NULL,
      NULL,
      6.364011,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.664890,
      NULL,
      0.210976,
      3,
      0.056503,
      6.520918,
      5,
      NULL,
      NULL,
      2.549668,
      3.310287,
      NULL,
      2.312407,
      0,
      1.228963,
      NULL,
      3.367285,
      0.286262,
      0.946648,
      0.751699,
      3,
      1.238187,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1.398214,
      1.402339,
      0.924472,
      NULL,
      1.091966,
      1.943832,
      NULL,
      NULL,
      1.966101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302858,
      0.054893,
      1,
      1.457082,
      1.532568,
      2.335313,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.258725,
      NULL,
      NULL,
      NULL,
      0.390769,
      NULL,
      NULL,
      NULL,
      0.711219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.593186,
      NULL,
      NULL,
      NULL,
      2.799940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750069,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      0,
      2.254711,
      46.992672,
      20.548360,
      0,
      NULL,
      NULL,
      0.302395,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530180,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      420.733301,
      22.383715,
      NULL,
      NULL,
      NULL,
      0.973681,
      NULL,
      1.876465,
      NULL,
      NULL,
      NULL,
      1.306031,
      NULL,
      NULL,
      0.222255,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555035,
      1.173541,
      1.829011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679434,
      1.139267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674339,
      2,
      NULL,
      0,
      NULL,
      1.093684,
      NULL,
      NULL,
      NULL,
      1,
      0.992537,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509262,
      NULL,
      1,
      NULL,
      0.421249,
      0.080314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0.734077,
      1.847760,
      3,
      1.762777,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586971,
      NULL,
      1,
      3,
      NULL,
      1.764424,
      3,
      NULL,
      1,
      1,
      NULL,
      1.168874,
      1,
      NULL,
      NULL,
      0.823162,
      NULL,
      0,
      0.914989,
      NULL,
      1,
      0.671606,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162108,
      1.207793,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.616499,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914172,
      NULL,
      0.499037,
      NULL,
      1.400837,
      NULL,
      1,
      NULL,
      5,
      0.691601,
      NULL,
      NULL,
      34,
      52,
      3,
      4,
      1.975460,
      '11434',
      '',
      NULL,
      0.585381,
      NULL,
      '',
      NULL,
      1.092020,
      '0330',
      NULL,
      '');
commit;
end;
/


