set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8806665';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '3034102',
      2.559468,
      0.642208,
      2,
      NULL,
      '4204',
      3.281049,
      1.372470,
      NULL,
      NULL,
      ' 6- 3-1978',
      49,
      NULL,
      NULL,
      0,
      NULL,
      ' 0- 3-2000',
      NULL,
      3.809789,
      NULL,
      NULL,
      NULL,
      ' 8-21-1982',
      '10- 5-1995',
      ' 2- 1-1988',
      NULL,
      NULL,
      1.754940,
      1.195556,
      0,
      0.841071,
      3,
      1.762912,
      0.307525,
      8,
      3,
      9.098809,
      NULL,
      18,
      12,
      5,
      24,
      4,
      0,
      7.845892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      3,
      0.451739,
      2,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      6.667358,
      1,
      2,
      NULL,
      1,
      1.448072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1.425148,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      2,
      0,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      4,
      5,
      1,
      NULL,
      NULL,
      2,
      4,
      1,
      NULL,
      NULL,
      3.299176,
      ' 6-14-1980',
      103,
      ' 6- 9-1981',
      27.839920,
      0.303395,
      2,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.291378,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0.004643,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.832729,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.019994,
      1,
      0.949649,
      0.206796,
      0,
      1,
      0,
      9,
      0.230700,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      2,
      2,
      2,
      0,
      1,
      2,
      1,
      1,
      2,
      2.086005,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1.251831,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      4.309697,
      0.619869,
      8,
      5.007049,
      4,
      9.415231,
      1.510464,
      4,
      NULL,
      1.427065,
      3,
      3,
      1.579699,
      0.202324,
      34.808711,
      0,
      1,
      NULL,
      22,
      42,
      72.477675,
      3,
      NULL,
      6,
      NULL,
      NULL,
      '30003',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.712978,
      22,
      28,
      4.147674,
      1,
      42.996229,
      3,
      2,
      NULL,
      3.763016,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.931745,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.667132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.016339,
      NULL,
      NULL,
      7,
      NULL,
      0.693063,
      NULL,
      1.659348,
      NULL,
      NULL,
      NULL,
      1.664170,
      NULL,
      NULL,
      NULL,
      1.914258,
      NULL,
      NULL,
      1.245583,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.585517,
      NULL,
      NULL,
      0.986278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.165974,
      2,
      1,
      1.586980,
      3.204240,
      1.860661,
      1,
      NULL,
      NULL,
      4,
      1.178427,
      5.374863,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.252649,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2.133352,
      2.412116,
      NULL,
      3,
      4,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.328725,
      NULL,
      NULL,
      1.372856,
      NULL,
      NULL,
      1.039345,
      NULL,
      NULL,
      3.743767,
      0,
      NULL,
      0.312923,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.342405,
      0,
      0.245947,
      4.442819,
      4,
      NULL,
      5,
      4,
      5.695887,
      NULL,
      3,
      4,
      1,
      0,
      0.696152,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.281408,
      NULL,
      NULL,
      1.952253,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.458772,
      NULL,
      NULL,
      0.908540,
      NULL,
      NULL,
      0.806395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.368452,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.103215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252362,
      NULL,
      NULL,
      NULL,
      1.531820,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.834871,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.827724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.035339,
      6.829265,
      NULL,
      1.868643,
      NULL,
      NULL,
      0.683369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417821,
      NULL,
      NULL,
      519,
      NULL,
      0.202233,
      1,
      0,
      0.015004,
      1.102519,
      1.550248,
      3.629793,
      NULL,
      0.978181,
      0.156781,
      0,
      1.117350,
      0,
      1,
      1.409807,
      0,
      1.016261,
      0.223628,
      2,
      NULL,
      0.223068,
      NULL,
      NULL,
      NULL,
      2.050870,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      40.535490,
      NULL,
      NULL,
      0,
      0.705763,
      0,
      NULL,
      3.291815,
      NULL,
      2.382398,
      NULL,
      1.145115,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.423444,
      NULL,
      1,
      NULL,
      1.169861,
      NULL,
      0.792729,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.325323,
      1.774163,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.540060,
      0.878923,
      3.790609,
      NULL,
      1.514638,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.362592,
      NULL,
      0,
      NULL,
      1.385527,
      NULL,
      1,
      1,
      0,
      NULL,
      1.310729,
      NULL,
      2,
      NULL,
      65,
      NULL,
      0.048181,
      NULL,
      0.690481,
      NULL,
      0.760765,
      NULL,
      NULL,
      0.283728,
      1.281256,
      NULL,
      1,
      NULL,
      0.775853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.950445,
      0,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      103.969246,
      NULL,
      3.122485,
      1.912400,
      0,
      NULL,
      3.594992,
      NULL,
      1.494836,
      NULL,
      NULL,
      NULL,
      1.792172,
      3,
      1,
      2.312382,
      NULL,
      NULL,
      NULL,
      213.118657,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.650018,
      NULL,
      1.150837,
      1,
      6,
      NULL,
      NULL,
      0.489441,
      0,
      2.235590,
      1,
      1,
      3,
      NULL,
      1,
      0.307546,
      2,
      1,
      1.175130,
      3,
      1.873700,
      1.359521,
      0,
      1.868824,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.021828,
      1,
      NULL,
      0.173765,
      0,
      NULL,
      1.574486,
      0.416648,
      NULL,
      1.183176,
      0.512762,
      NULL,
      0.967622,
      1.279844,
      NULL,
      1.297849,
      0.543653,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.762112,
      NULL,
      NULL,
      5,
      7,
      NULL,
      NULL,
      NULL,
      44.853277,
      91,
      2,
      1.789588,
      1.226192,
      '44010',
      '30334',
      '21121',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


