set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8102496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '4402223',
      3.028167,
      0.515214,
      NULL,
      1,
      '3342',
      2.802094,
      0.068606,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      4,
      NULL,
      0.579598,
      ' 2-21-1987',
      25,
      3,
      257,
      160.464146,
      0,
      NULL,
      ' 4-11-2000',
      NULL,
      1,
      NULL,
      NULL,
      0.574705,
      0.214093,
      NULL,
      3,
      0.877836,
      0,
      171.087137,
      6,
      4,
      4,
      119,
      195.416902,
      2,
      0.837686,
      0,
      0,
      7,
      0.635761,
      1,
      0,
      0,
      1.721040,
      0.294839,
      1.753456,
      1.168637,
      0.261435,
      0.018560,
      91.013556,
      NULL,
      2,
      NULL,
      0,
      0,
      1,
      3,
      1,
      NULL,
      3,
      0,
      5,
      2,
      3,
      2,
      2,
      3.681676,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.512303,
      NULL,
      NULL,
      NULL,
      3,
      6,
      2,
      NULL,
      NULL,
      0.224442,
      NULL,
      2.103083,
      3,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0.596370,
      3.205932,
      2.402392,
      1,
      NULL,
      4,
      6,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.526786,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      4,
      3,
      3,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      3.945369,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      2,
      5,
      NULL,
      3,
      NULL,
      3,
      3,
      0,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4,
      NULL,
      4,
      0,
      NULL,
      1,
      ' 9-27-1993',
      723,
      NULL,
      555,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.494175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.017838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.862562,
      7.153326,
      11.684034,
      2.480242,
      NULL,
      NULL,
      NULL,
      1.052785,
      13,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557827,
      1,
      0.913691,
      NULL,
      NULL,
      0,
      2.951996,
      366,
      1,
      1.218475,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.422775,
      NULL,
      0,
      2,
      2,
      2,
      NULL,
      2,
      0,
      2,
      1,
      0,
      12.726918,
      11,
      181,
      167,
      64.862979,
      76,
      NULL,
      8,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1.316293,
      6.866179,
      0.203350,
      4.362060,
      1,
      1.652242,
      7.935393,
      7,
      7,
      1.514048,
      3.174646,
      NULL,
      3,
      2.977452,
      2,
      59.038324,
      2,
      2,
      NULL,
      NULL,
      13,
      47,
      NULL,
      1,
      2,
      '22033',
      '',
      '',
      1,
      '',
      '',
      '',
      1.573893,
      '',
      '',
      NULL,
      3.376134,
      36.807470,
      181.692720,
      NULL,
      2.249039,
      NULL,
      9,
      14,
      NULL,
      NULL,
      2.042172,
      NULL,
      0,
      NULL,
      NULL,
      3.913438,
      1.122762,
      1.345135,
      0,
      NULL,
      NULL,
      NULL,
      1.300289,
      0.529949,
      1.354811,
      2.252571,
      1.670200,
      1,
      0,
      1.347993,
      0.923283,
      NULL,
      NULL,
      0.634175,
      NULL,
      NULL,
      0.993054,
      3,
      0,
      0,
      1,
      0.109335,
      1,
      NULL,
      NULL,
      2.496443,
      3,
      2.540796,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0.734009,
      0.418222,
      2.684547,
      0,
      NULL,
      1.437713,
      0.154733,
      3.211966,
      1,
      3,
      NULL,
      3.822576,
      2.955512,
      NULL,
      0.401758,
      1.356744,
      NULL,
      1.186857,
      2,
      NULL,
      1.461947,
      0,
      3.109649,
      0,
      0,
      1,
      NULL,
      NULL,
      1.864219,
      0,
      0,
      0,
      0.913320,
      0.249665,
      0,
      0.233005,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1.007132,
      2,
      1.527910,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.178234,
      2,
      0.042252,
      2.655153,
      0.173048,
      0,
      NULL,
      NULL,
      2.608048,
      0.640289,
      2.393979,
      0.664355,
      NULL,
      NULL,
      0.318321,
      NULL,
      NULL,
      1.079056,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.197636,
      NULL,
      NULL,
      NULL,
      2.016568,
      3.523971,
      2.347738,
      NULL,
      0.413228,
      9.964321,
      4,
      3.029169,
      6.054947,
      7,
      5.971157,
      1,
      NULL,
      NULL,
      NULL,
      0.121295,
      2,
      3,
      2.768515,
      NULL,
      2.222597,
      3.972361,
      3,
      5.988148,
      NULL,
      NULL,
      2.355637,
      3.642397,
      1,
      NULL,
      3.545280,
      1.611162,
      2,
      NULL,
      3.025767,
      NULL,
      NULL,
      3.921960,
      7.474023,
      1.987724,
      7.669941,
      11,
      3,
      7.932514,
      2,
      4,
      0,
      0,
      1,
      1.128734,
      1.752898,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.884040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219763,
      NULL,
      NULL,
      1.508306,
      1.992321,
      1.199417,
      1,
      NULL,
      2,
      1.606300,
      NULL,
      NULL,
      2.938260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.969633,
      NULL,
      NULL,
      NULL,
      0.161901,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.204169,
      NULL,
      NULL,
      NULL,
      3.925164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      3.972094,
      0,
      NULL,
      4,
      0.546977,
      99,
      53,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520142,
      1,
      NULL,
      NULL,
      0.817870,
      NULL,
      NULL,
      116.621936,
      2.842958,
      1.767901,
      2,
      0.028002,
      NULL,
      0,
      1.258972,
      1.906722,
      0,
      0.395532,
      1.047029,
      0.014227,
      0.159964,
      0,
      0.448154,
      0.272010,
      0,
      1.329687,
      0.891502,
      NULL,
      0,
      NULL,
      0.927238,
      NULL,
      0,
      NULL,
      0.141309,
      NULL,
      0.111949,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.107754,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.596237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.164949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0.575890,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.816406,
      0.767814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      1.058500,
      3,
      9,
      NULL,
      1,
      0,
      0,
      0.125692,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.707517,
      NULL,
      0,
      0.062494,
      NULL,
      NULL,
      1.784131,
      NULL,
      0.610050,
      0.520019,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.379355,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.818065,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667865,
      NULL,
      NULL,
      NULL,
      0,
      6,
      2,
      2,
      1,
      NULL,
      34,
      NULL,
      1,
      NULL,
      0.717272,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


