set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8102496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      '20',
      41.110464,
      30,
      NULL,
      1,
      NULL,
      NULL,
      1,
      '4332',
      5,
      0,
      NULL,
      NULL,
      ' 5-24-2003',
      21.461806,
      6.224795,
      NULL,
      2.846732,
      1.430287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 7-23-1991',
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.013077,
      NULL,
      1,
      1.025729,
      217,
      3,
      16.236055,
      1.169031,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.750512,
      1,
      1,
      NULL,
      1,
      0.393763,
      1,
      0,
      0.846631,
      1.687682,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      5,
      NULL,
      NULL,
      5,
      5,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      6.883700,
      2,
      1.301649,
      NULL,
      0.666509,
      2.529631,
      1.991678,
      3,
      2.303292,
      1.728135,
      1,
      3,
      1,
      0.358758,
      0.643926,
      0.979650,
      NULL,
      0,
      NULL,
      1,
      9.754424,
      NULL,
      0,
      2.548851,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      5.292411,
      1,
      NULL,
      1,
      0,
      3,
      0,
      2,
      1,
      2,
      NULL,
      3,
      NULL,
      2,
      NULL,
      3,
      0,
      5,
      2,
      NULL,
      2,
      1,
      4,
      1,
      5,
      NULL,
      6,
      2.692444,
      ' 2- 5-1979',
      87.113660,
      '11-22-1994',
      206.792177,
      3.536283,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268421,
      3,
      9.136219,
      1,
      3.184572,
      3.497034,
      6.475443,
      0.158044,
      NULL,
      NULL,
      NULL,
      4.239097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.131756,
      0.564071,
      1,
      1,
      0.148383,
      1,
      3.443320,
      0,
      3.640112,
      10,
      12.328641,
      225.577477,
      3,
      1.086088,
      0,
      1,
      NULL,
      3,
      0,
      2,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.902572,
      0,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.106578,
      2,
      5.886039,
      6,
      2.083045,
      2,
      4,
      0.008085,
      1,
      0,
      15,
      0,
      0.665188,
      7,
      NULL,
      6,
      18,
      NULL,
      NULL,
      1.625698,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.166509,
      '',
      '',
      '',
      0.723554,
      44,
      8.352391,
      45.813628,
      1.391583,
      7,
      4.397567,
      231,
      3,
      NULL,
      1,
      NULL,
      1.594600,
      NULL,
      NULL,
      3.147403,
      3.800542,
      1.441158,
      0.513841,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      1,
      2,
      2,
      2.755548,
      NULL,
      NULL,
      NULL,
      0.522031,
      NULL,
      NULL,
      0,
      0.489551,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6.513810,
      9.178023,
      0,
      0.841798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675276,
      3.072118,
      NULL,
      3.222010,
      1.959653,
      1,
      1.563017,
      2,
      3,
      NULL,
      2,
      NULL,
      0.377359,
      2,
      1,
      2.449989,
      3.118824,
      1,
      NULL,
      2,
      0.241655,
      3,
      2,
      3.300297,
      3.669977,
      1.261268,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      1,
      10.676044,
      3.766036,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.124374,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.564643,
      2.074140,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      4,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      7.913177,
      7,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      1.393333,
      0.913112,
      8.276122,
      0,
      5.080908,
      3,
      3,
      0,
      1.329190,
      NULL,
      NULL,
      1,
      2.915576,
      1,
      NULL,
      1,
      NULL,
      3,
      0.996020,
      0,
      9,
      3.116583,
      7,
      3,
      0,
      3.864316,
      2.245569,
      2.579667,
      NULL,
      0,
      3.299922,
      NULL,
      1.178092,
      0.919201,
      3,
      NULL,
      5.088993,
      2,
      4.923200,
      4,
      2,
      NULL,
      0,
      2,
      1,
      0.212259,
      1.853875,
      NULL,
      0.356905,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963420,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.572197,
      NULL,
      NULL,
      0.224326,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.200007,
      NULL,
      NULL,
      1,
      NULL,
      0.644362,
      1.882283,
      0,
      0.726939,
      1.670017,
      NULL,
      NULL,
      3.074888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.260320,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242046,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.567136,
      NULL,
      NULL,
      NULL,
      15.347312,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      5,
      3,
      NULL,
      410.763696,
      2.676351,
      14.315097,
      1,
      0.420825,
      NULL,
      NULL,
      0.892033,
      NULL,
      NULL,
      1,
      7.014070,
      1.911017,
      NULL,
      NULL,
      NULL,
      0.856554,
      NULL,
      1,
      NULL,
      9,
      1,
      1,
      NULL,
      1,
      1.488747,
      NULL,
      1.861178,
      1,
      0,
      0.769718,
      1.226865,
      0,
      1,
      1.192132,
      1.973213,
      NULL,
      1.338718,
      0,
      NULL,
      0,
      NULL,
      1.235711,
      NULL,
      1.590380,
      NULL,
      NULL,
      NULL,
      0.610183,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082401,
      0.237717,
      1.686214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.084197,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215751,
      0.439086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527202,
      2,
      NULL,
      1.516484,
      NULL,
      0.495496,
      NULL,
      NULL,
      NULL,
      0.466725,
      1.701743,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.533577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1.259930,
      1,
      0,
      8,
      3.627984,
      1,
      NULL,
      1,
      1.717682,
      NULL,
      1.171161,
      2,
      NULL,
      0,
      0.123570,
      NULL,
      NULL,
      0.121138,
      NULL,
      NULL,
      1.837625,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.674351,
      NULL,
      1,
      1,
      NULL,
      1.371340,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.350367,
      1.423991,
      NULL,
      3.201149,
      1.832951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.413742,
      NULL,
      4,
      4,
      NULL,
      0,
      0.740871,
      3.592225,
      14.695989,
      6,
      3,
      0.371634,
      1.540862,
      '23121',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


