set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7838975';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.630613,
      NULL,
      2,
      3,
      NULL,
      1,
      1,
      1,
      '204',
      '00220043',
      15.629171,
      63,
      NULL,
      NULL,
      1.568144,
      0,
      3,
      '1143',
      NULL,
      1.116091,
      NULL,
      NULL,
      ' 8-25-1982',
      8,
      199,
      NULL,
      2.512226,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 9- 4-1993',
      2.171961,
      NULL,
      2,
      0,
      0,
      1,
      5,
      1.316259,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      0.298091,
      0,
      0,
      0.412462,
      1.925247,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.270667,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      2,
      2,
      1,
      1.677581,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      4,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      0,
      0,
      1,
      0.345424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.093390,
      3.814655,
      0,
      5.344299,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349188,
      0.699786,
      0.670488,
      NULL,
      3,
      3.998617,
      0.724233,
      NULL,
      NULL,
      NULL,
      0.153846,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193306,
      1,
      0,
      NULL,
      0.040245,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.856805,
      0,
      2,
      2,
      2,
      NULL,
      1,
      3,
      2,
      1,
      3,
      1,
      NULL,
      1,
      4.154263,
      1.423994,
      1.957179,
      0.459959,
      1,
      1,
      1.673399,
      1,
      NULL,
      1.109400,
      1.954678,
      1.353993,
      NULL,
      0,
      1.750068,
      4.199552,
      NULL,
      7,
      0.629254,
      0,
      NULL,
      5.918174,
      NULL,
      NULL,
      3.969792,
      6,
      0.757077,
      1,
      3.506820,
      61.244315,
      NULL,
      1.993328,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1.600433,
      '',
      NULL,
      NULL,
      0,
      0,
      146,
      12,
      0.289570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038470,
      NULL,
      NULL,
      1.520126,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.211441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.635870,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.218750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169038,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.924814,
      1,
      0.039608,
      NULL,
      NULL,
      NULL,
      1.669874,
      0.281617,
      1.853696,
      2,
      1,
      3,
      3,
      0,
      3.003679,
      5.669511,
      2.349563,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.143495,
      NULL,
      NULL,
      0.683036,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.335876,
      3.761474,
      0.918432,
      3.802414,
      3,
      1,
      NULL,
      0.288381,
      3.367142,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.639876,
      3.302697,
      NULL,
      NULL,
      1,
      1.188913,
      6.301623,
      0,
      5,
      1,
      1,
      NULL,
      NULL,
      0.494564,
      1.169070,
      1,
      1,
      1.743083,
      2,
      2,
      0,
      1,
      3,
      3,
      0,
      1,
      0.909928,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.725273,
      NULL,
      0.906775,
      1.158279,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.173465,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.909882,
      NULL,
      NULL,
      2.524492,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885035,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.096093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.420755,
      NULL,
      NULL,
      3.452911,
      NULL,
      3,
      NULL,
      1,
      0.466593,
      0.921970,
      NULL,
      1.244973,
      0.128434,
      NULL,
      NULL,
      NULL,
      1.399256,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.391971,
      NULL,
      NULL,
      NULL,
      3.523169,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.560772,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.751375,
      NULL,
      NULL,
      NULL,
      1.769059,
      NULL,
      NULL,
      NULL,
      1.030115,
      NULL,
      NULL,
      NULL,
      3.688699,
      NULL,
      NULL,
      NULL,
      0.978008,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.386456,
      NULL,
      NULL,
      NULL,
      1.633191,
      NULL,
      NULL,
      NULL,
      0.771820,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.777699,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1.188735,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4.656549,
      1,
      0.015091,
      2.420195,
      1.001250,
      0.611967,
      NULL,
      NULL,
      0.529075,
      NULL,
      NULL,
      0.881768,
      NULL,
      NULL,
      3.962965,
      31.537843,
      40,
      1.537371,
      NULL,
      1,
      61,
      18.204405,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1.980837,
      1.477368,
      0.087923,
      NULL,
      0.929823,
      0,
      0.145445,
      NULL,
      1.227979,
      0.909725,
      1.609355,
      1.498457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965287,
      1.582789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.166439,
      1.798460,
      1.307860,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.304492,
      1.143918,
      1,
      1,
      0.582165,
      1.877764,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487827,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793471,
      1,
      NULL,
      0.898399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.416994,
      NULL,
      NULL,
      0.194856,
      1.939525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      6,
      3,
      NULL,
      1,
      3,
      5,
      1.182342,
      1,
      0,
      1.305907,
      1.496425,
      1,
      NULL,
      0.115357,
      1.675710,
      0,
      1.711725,
      1,
      1,
      NULL,
      1.496017,
      0,
      NULL,
      NULL,
      0.283947,
      1,
      NULL,
      3,
      NULL,
      1.663368,
      0.540446,
      1,
      0.884224,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0.015417,
      1.181013,
      1.666232,
      NULL,
      0.754672,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.347151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427246,
      NULL,
      0,
      1,
      1.609692,
      1,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      74.521861,
      126.434573,
      5,
      3.894947,
      2.936048,
      '10431',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


