set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '2311403',
      0,
      1.645538,
      NULL,
      3,
      '4133',
      0.297588,
      0.727597,
      NULL,
      NULL,
      ' 3-11-1998',
      1,
      NULL,
      0,
      2.839665,
      NULL,
      '11-29-1974',
      3,
      2,
      318.970855,
      61.086030,
      1,
      ' 9-17-1980',
      ' 9-24-1974',
      ' 4- 4-1984',
      2,
      1,
      3,
      1.533340,
      1.607430,
      2.509377,
      NULL,
      0,
      0.141336,
      21,
      2,
      17.202598,
      2.966076,
      22,
      8,
      0,
      8,
      5,
      0,
      2.254800,
      1.795380,
      1,
      0,
      1.078826,
      1.764310,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      2,
      2,
      0,
      0,
      0,
      0,
      3,
      0,
      0,
      1,
      1,
      4,
      0,
      0,
      1,
      3.505713,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      0.418568,
      1.619837,
      1.840979,
      1,
      0,
      2.348015,
      NULL,
      NULL,
      1,
      1.137210,
      0.289504,
      2,
      0,
      1,
      0,
      0,
      3,
      0,
      0,
      5,
      10,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      2,
      5,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      3,
      NULL,
      1,
      3,
      2,
      NULL,
      0,
      1,
      2,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1,
      5,
      0,
      ' 9- 1-1993',
      47,
      ' 8-12-1987',
      51,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.315758,
      0.516106,
      2.001701,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.258245,
      NULL,
      1.587094,
      1.683745,
      0.189781,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.774338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.733584,
      1.604146,
      1,
      1.878553,
      NULL,
      3.149472,
      92,
      2,
      0.657424,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      3,
      3,
      2,
      2,
      1,
      NULL,
      2,
      3,
      NULL,
      1,
      2.261375,
      1.850625,
      1,
      0.273830,
      5,
      0.877244,
      0.020601,
      0,
      1,
      0.827839,
      1,
      1.092812,
      NULL,
      1,
      NULL,
      2.679039,
      1,
      NULL,
      2,
      5,
      8,
      7.785458,
      7,
      4,
      3,
      6.276258,
      NULL,
      3.482768,
      3,
      16.058212,
      1,
      0,
      NULL,
      28,
      11,
      NULL,
      3,
      1,
      1,
      '10011',
      '',
      '',
      0.340599,
      NULL,
      NULL,
      '',
      0.954647,
      '',
      '',
      '',
      2,
      12,
      19,
      3,
      0.279731,
      26.651496,
      3,
      0.561732,
      0,
      3.652150,
      NULL,
      1.501149,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.012384,
      NULL,
      1.925734,
      NULL,
      1.911602,
      1.479687,
      1,
      NULL,
      NULL,
      0,
      3,
      3.704653,
      NULL,
      NULL,
      NULL,
      1.146910,
      1.438345,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.617197,
      1,
      NULL,
      NULL,
      3.035761,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.434536,
      2,
      NULL,
      2,
      1,
      NULL,
      2,
      3,
      2,
      0,
      1,
      2,
      NULL,
      1.951161,
      1.918977,
      0,
      1.900638,
      1.168793,
      1.833876,
      1,
      NULL,
      2.783741,
      2.907085,
      3,
      0,
      NULL,
      NULL,
      0.954102,
      NULL,
      NULL,
      0,
      0,
      0.336569,
      6.698400,
      NULL,
      1.142526,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985813,
      1,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      1,
      1,
      NULL,
      0.857923,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      1,
      3,
      3,
      0.287196,
      0.426906,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      2,
      1,
      1.852379,
      3.110911,
      0.815204,
      NULL,
      NULL,
      NULL,
      NULL,
      8.083064,
      NULL,
      9,
      2,
      5.561851,
      3.455014,
      5.331226,
      6.711544,
      NULL,
      3.190699,
      NULL,
      1.279205,
      3.686205,
      3,
      NULL,
      3.640657,
      NULL,
      0.799523,
      0,
      7,
      2.933628,
      NULL,
      0.697024,
      2.067206,
      1.692473,
      1.746645,
      0,
      1.436509,
      1,
      1.337701,
      NULL,
      3,
      NULL,
      2.185657,
      NULL,
      NULL,
      NULL,
      2.671368,
      6,
      2.535661,
      3,
      1,
      NULL,
      1.442963,
      1.066547,
      0,
      0.242973,
      1.121409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.681472,
      0,
      0.600217,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      11.915057,
      6.583343,
      0.839091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499654,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.713556,
      NULL,
      NULL,
      0.033843,
      NULL,
      NULL,
      71.803587,
      6.297095,
      0.366983,
      0.104657,
      1,
      0.886769,
      1,
      1,
      1.005716,
      0.140161,
      1,
      NULL,
      1,
      0.743177,
      NULL,
      0.835689,
      NULL,
      0.353775,
      1,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.138507,
      NULL,
      3.069811,
      NULL,
      3.410665,
      NULL,
      60,
      NULL,
      NULL,
      7,
      NULL,
      1,
      0.252649,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.972527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.440411,
      NULL,
      0,
      NULL,
      1.923591,
      1,
      NULL,
      0.774204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626941,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651651,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200119,
      1,
      NULL,
      1.318733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549272,
      NULL,
      1.663837,
      NULL,
      1,
      NULL,
      NULL,
      0.944590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490788,
      2,
      NULL,
      3.198625,
      NULL,
      NULL,
      NULL,
      108,
      NULL,
      1,
      0,
      2.152224,
      NULL,
      2.590852,
      NULL,
      3,
      NULL,
      254,
      NULL,
      1.219159,
      NULL,
      3.173051,
      NULL,
      NULL,
      0.364664,
      1.184132,
      11.698863,
      17.304021,
      1.026121,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      3.532318,
      1,
      6,
      0,
      1.830387,
      1,
      1.010867,
      0.649358,
      NULL,
      2,
      3,
      NULL,
      2.614418,
      1,
      NULL,
      0.736112,
      0.648571,
      NULL,
      1.349647,
      NULL,
      NULL,
      NULL,
      0.069626,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689059,
      1,
      NULL,
      2.892964,
      1,
      NULL,
      NULL,
      3,
      NULL,
      2.006073,
      1,
      NULL,
      2.305836,
      0.626449,
      0.843657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986573,
      NULL,
      0.840006,
      NULL,
      0,
      NULL,
      2,
      4,
      1,
      NULL,
      NULL,
      NULL,
      14.690872,
      36.421623,
      NULL,
      2,
      NULL,
      '24004',
      '02210',
      '01403',
      0.472515,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


