set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '22',
      3.860710,
      0,
      '0413204',
      NULL,
      0.288932,
      2,
      NULL,
      '0200',
      2.755793,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1984',
      49,
      28.605804,
      NULL,
      NULL,
      1.922127,
      '10-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 0-23-1979',
      ' 1- 0-1996',
      '11-10-1976',
      1.495952,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      7,
      1.050287,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.455365,
      0.246136,
      1,
      1.347771,
      0.185335,
      1.435513,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      4,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      NULL,
      2,
      1.265488,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      1.151539,
      3,
      1.549231,
      1.057898,
      1,
      2,
      1.993363,
      1,
      1.092146,
      NULL,
      0.295598,
      0,
      0,
      1,
      3.266867,
      NULL,
      1.220089,
      3,
      5,
      4,
      2.461202,
      0,
      0,
      1,
      1.901574,
      NULL,
      NULL,
      1.359394,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1.527660,
      0,
      3,
      1,
      NULL,
      1,
      5,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      3,
      5,
      3,
      NULL,
      1,
      4,
      NULL,
      0,
      1.312762,
      1,
      ' 4-13-1986',
      164,
      NULL,
      134.429408,
      1.792263,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.994531,
      1.286931,
      0,
      0.466725,
      4.372105,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.503513,
      1.848335,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462542,
      NULL,
      NULL,
      0.641365,
      0.469355,
      NULL,
      1,
      3,
      25.938016,
      NULL,
      1.356513,
      NULL,
      NULL,
      NULL,
      3,
      3.877778,
      0.878014,
      2,
      0,
      3,
      2,
      1,
      0,
      2,
      2,
      0,
      1,
      NULL,
      1.328187,
      2,
      0.546011,
      1.009519,
      0,
      5.527693,
      0,
      NULL,
      1.099068,
      1,
      0.717014,
      1.472826,
      1.233006,
      NULL,
      1,
      0,
      0,
      NULL,
      5,
      4.903015,
      3,
      8.160996,
      NULL,
      6.674081,
      5,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      49.585335,
      2,
      2.561364,
      6,
      NULL,
      77,
      49.126062,
      0,
      2,
      6,
      '42310',
      '21111',
      '44444',
      1,
      NULL,
      NULL,
      '',
      1.484402,
      '',
      '',
      '',
      1.793389,
      17.419132,
      95.493808,
      18.952953,
      NULL,
      NULL,
      0.303984,
      5,
      NULL,
      1.364968,
      NULL,
      2.912063,
      0.112381,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.660498,
      0.434937,
      0,
      NULL,
      2.893758,
      1.825589,
      NULL,
      NULL,
      1.135814,
      3,
      NULL,
      0,
      NULL,
      NULL,
      2.653016,
      3.713366,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.190152,
      3,
      1,
      NULL,
      NULL,
      8,
      7.081368,
      7,
      NULL,
      0.863142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.667050,
      3,
      2.146018,
      1.092072,
      1,
      1,
      0,
      0,
      2.585055,
      0,
      0,
      1.375679,
      3,
      0,
      1.447144,
      0.566648,
      2.602073,
      0,
      2.982564,
      0.400654,
      0.461286,
      2.420910,
      0.774894,
      3.169839,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      8.932629,
      6.861095,
      0,
      1.275022,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.666672,
      0,
      3.855808,
      2,
      1.776775,
      1.115887,
      NULL,
      NULL,
      3,
      1.172114,
      0,
      NULL,
      5,
      4,
      2.822047,
      3,
      3.944667,
      0.432051,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637938,
      NULL,
      1.087122,
      1.642648,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.892630,
      NULL,
      NULL,
      3.719148,
      0,
      1,
      3.570494,
      2.018711,
      NULL,
      2.707835,
      2.855528,
      3.071387,
      2,
      NULL,
      1.861659,
      9,
      9,
      1,
      3.633888,
      7,
      NULL,
      1,
      1,
      2.866391,
      NULL,
      1,
      NULL,
      1.947561,
      3.018336,
      2.159592,
      1,
      NULL,
      3.535949,
      5.109725,
      4.113824,
      4.589784,
      0.355444,
      0,
      0,
      NULL,
      NULL,
      1.745527,
      2,
      0,
      3,
      1,
      0.020052,
      0.616454,
      0,
      3,
      1,
      2.523105,
      0.200130,
      6,
      0,
      NULL,
      NULL,
      1.085840,
      1,
      0.557782,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.465891,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.994834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.889883,
      NULL,
      1,
      0,
      0.498409,
      1,
      1.935776,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835704,
      NULL,
      NULL,
      NULL,
      0.212462,
      NULL,
      NULL,
      NULL,
      0.407984,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.073732,
      46,
      NULL,
      1.252449,
      NULL,
      NULL,
      0.724374,
      NULL,
      NULL,
      1.937605,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.009975,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      15514,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1.071022,
      NULL,
      0,
      1.492399,
      NULL,
      1.500579,
      0,
      0.860372,
      0.814678,
      0.667451,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      10,
      27,
      NULL,
      3.967408,
      2.322620,
      NULL,
      0.412244,
      NULL,
      0.106787,
      NULL,
      0.834515,
      NULL,
      0,
      NULL,
      0.781806,
      NULL,
      0.550993,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.317036,
      NULL,
      1.280110,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0.491523,
      1.937918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.662887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.090224,
      1.376190,
      NULL,
      1,
      NULL,
      0.825892,
      NULL,
      NULL,
      NULL,
      1.384651,
      NULL,
      1.344445,
      NULL,
      NULL,
      NULL,
      1.004580,
      NULL,
      3.965915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.450903,
      NULL,
      3.318658,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2,
      0,
      1.769539,
      NULL,
      0,
      NULL,
      1.259348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.045978,
      NULL,
      1,
      NULL,
      2,
      NULL,
      224.027483,
      NULL,
      0,
      1,
      0.011919,
      NULL,
      1.395299,
      NULL,
      0.715737,
      NULL,
      254.983544,
      NULL,
      5.689869,
      NULL,
      3.747064,
      NULL,
      0,
      0,
      NULL,
      NULL,
      6,
      1,
      3,
      2,
      0.783080,
      1,
      0,
      0,
      0.978781,
      1.913095,
      5,
      NULL,
      NULL,
      1.533912,
      0,
      2,
      0.592099,
      1.533686,
      0.701474,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.264340,
      NULL,
      1.447869,
      1,
      NULL,
      0,
      0.916183,
      NULL,
      1.389177,
      NULL,
      NULL,
      NULL,
      0.508383,
      NULL,
      1.729079,
      1,
      NULL,
      1.637470,
      0.384347,
      NULL,
      0,
      1,
      NULL,
      3.225035,
      NULL,
      NULL,
      1.022153,
      0.320079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424606,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      32.331477,
      90,
      1,
      5,
      5.253555,
      NULL,
      '04023',
      '',
      1,
      '',
      NULL,
      '',
      1.365078,
      '',
      '',
      '');
commit;
end;
/


