set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9944050';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      2.081032,
      NULL,
      2.735497,
      1.606811,
      NULL,
      NULL,
      2.949513,
      NULL,
      '42110330',
      41,
      5.724815,
      '4343332',
      NULL,
      1.016118,
      1,
      1,
      '2203',
      0,
      1.649102,
      NULL,
      NULL,
      NULL,
      217.872309,
      169.792129,
      NULL,
      1,
      NULL,
      ' 0-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 7-10-1998',
      NULL,
      NULL,
      2,
      1.538950,
      1,
      2.851622,
      0.796608,
      3,
      2,
      0,
      1.431719,
      20.336556,
      1,
      17,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      3,
      1,
      0,
      NULL,
      1.424558,
      1,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.350499,
      0.299517,
      0.983567,
      2.642477,
      3.280288,
      1.078222,
      NULL,
      1.123532,
      3,
      1,
      1,
      0,
      1,
      2.037024,
      2,
      3,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0.823294,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      0.987528,
      NULL,
      4,
      0,
      0,
      1,
      2,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      4,
      3,
      2,
      2,
      3,
      NULL,
      1,
      5,
      1,
      0,
      0,
      1.194920,
      ' 8-21-2000',
      7.848368,
      ' 0-26-1991',
      95.164578,
      2.289948,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1.801131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.277578,
      0.069253,
      5,
      1,
      NULL,
      9.547366,
      2,
      1.478987,
      1,
      1.145026,
      3.945778,
      0.781124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255656,
      3,
      0.247805,
      0.350903,
      1,
      0,
      1,
      3.488565,
      7,
      0.892401,
      0.195900,
      NULL,
      NULL,
      NULL,
      1,
      1.714280,
      0.418968,
      0,
      2,
      2,
      3,
      NULL,
      NULL,
      3,
      2,
      1,
      2,
      3,
      0,
      0,
      2,
      0,
      0,
      1.449063,
      0.181904,
      0.414181,
      1.810492,
      0.732083,
      1.698180,
      0,
      0.297737,
      1.275610,
      0,
      NULL,
      NULL,
      NULL,
      6,
      1.206607,
      2.529532,
      10.040879,
      5.203159,
      0,
      5.284570,
      1.270941,
      0,
      1.254989,
      2.101318,
      NULL,
      NULL,
      2,
      2,
      23,
      NULL,
      28,
      26,
      2,
      4.958900,
      2.017625,
      '43242',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      28,
      NULL,
      23,
      1,
      19.940616,
      NULL,
      NULL,
      4,
      NULL,
      3,
      3.913774,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.086702,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.922753,
      NULL,
      NULL,
      NULL,
      3,
      3.585662,
      NULL,
      NULL,
      NULL,
      1.174158,
      1.439140,
      0,
      0.442229,
      NULL,
      NULL,
      0.368476,
      NULL,
      NULL,
      0.808912,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.563609,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.355759,
      1,
      1,
      1.150365,
      2.269463,
      NULL,
      1,
      2.838993,
      0,
      0,
      2,
      0.481443,
      0.420570,
      0,
      3,
      NULL,
      1,
      3,
      3,
      1.154218,
      1.407494,
      NULL,
      3,
      1.867588,
      NULL,
      NULL,
      1.257329,
      1.390605,
      0,
      1,
      1,
      1,
      7.541245,
      1.457205,
      NULL,
      0,
      0.350662,
      NULL,
      NULL,
      NULL,
      0.473017,
      NULL,
      NULL,
      NULL,
      0.670875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325162,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.876015,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.687829,
      1.633284,
      1,
      1.070134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.861577,
      NULL,
      NULL,
      0.888617,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.464728,
      0,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873497,
      0.133161,
      1.766703,
      0,
      0.142377,
      0,
      5.409627,
      NULL,
      3,
      2.592346,
      1,
      NULL,
      1,
      NULL,
      2.596774,
      2,
      0.983140,
      1.500003,
      2.485867,
      2,
      3.587834,
      7,
      1.346878,
      0.530276,
      0.231918,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      1.744844,
      NULL,
      NULL,
      1.949056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866902,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776688,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.828749,
      NULL,
      NULL,
      5.052528,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.761105,
      2.011354,
      0.809878,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200092,
      NULL,
      NULL,
      NULL,
      3.449503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.679087,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.326894,
      NULL,
      NULL,
      NULL,
      1.765138,
      NULL,
      NULL,
      NULL,
      7.437687,
      NULL,
      NULL,
      NULL,
      2,
      3.424949,
      3,
      4,
      NULL,
      NULL,
      23,
      3,
      20.739027,
      2.630928,
      0,
      NULL,
      NULL,
      1.512004,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.651110,
      NULL,
      NULL,
      0.833610,
      NULL,
      1,
      1.942483,
      1,
      NULL,
      1.249211,
      0,
      0.342358,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0.599334,
      0.040615,
      0.118173,
      1,
      NULL,
      NULL,
      1.074585,
      1.026112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      9,
      NULL,
      1,
      3.810719,
      1,
      2.847747,
      0,
      1.350127,
      1.742379,
      1,
      1.018122,
      NULL,
      0,
      0.483811,
      NULL,
      3,
      2.294762,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      NULL,
      1.992239,
      0.434352,
      NULL,
      3.440313,
      NULL,
      NULL,
      0.155495,
      NULL,
      NULL,
      1.272443,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.985053,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      NULL,
      NULL,
      7,
      116,
      3,
      2.667186,
      1,
      '13000',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.773454,
      '',
      NULL,
      '');
commit;
end;
/


