set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9506730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '2404430',
      NULL,
      1,
      6,
      1,
      '3313',
      NULL,
      0,
      NULL,
      NULL,
      '11-23-1984',
      50,
      NULL,
      NULL,
      1.870347,
      NULL,
      NULL,
      4.021217,
      5,
      3.500247,
      NULL,
      3,
      ' 0- 7-1989',
      NULL,
      ' 9-13-2001',
      NULL,
      3,
      NULL,
      2.550619,
      0,
      0.421640,
      0,
      0.309736,
      1.747344,
      12.410653,
      2,
      6,
      NULL,
      21.449690,
      28,
      NULL,
      21,
      5,
      NULL,
      2.408796,
      0.644736,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      4,
      0.876887,
      2,
      0,
      1,
      1.459127,
      0,
      1,
      1,
      4,
      2,
      1,
      1,
      1,
      1,
      0,
      1,
      0,
      3.538644,
      1,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      1.746048,
      NULL,
      NULL,
      3,
      5,
      5.685485,
      1.139351,
      0.759251,
      3,
      2,
      3,
      0.302765,
      0,
      3,
      0.111255,
      0.424861,
      3,
      0.385017,
      1.544336,
      NULL,
      0.668415,
      2.584743,
      2,
      NULL,
      3,
      5.217419,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.882250,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      0,
      1,
      5,
      0,
      5,
      0,
      NULL,
      4,
      NULL,
      5.628323,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      2,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      5,
      4,
      NULL,
      1,
      NULL,
      NULL,
      1.313640,
      3.608027,
      '10- 2-1999',
      42,
      ' 4-26-2003',
      19,
      0.573219,
      0,
      1,
      0,
      5,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      2,
      2,
      1,
      1,
      5,
      2.939614,
      0.147466,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.548703,
      NULL,
      0,
      1.586217,
      NULL,
      NULL,
      1,
      3.639539,
      0,
      NULL,
      NULL,
      NULL,
      0.316277,
      1.966719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.791097,
      1.991841,
      0.979004,
      0.470363,
      1,
      1,
      0.969328,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      2,
      NULL,
      2.304674,
      NULL,
      0.127852,
      0.109286,
      0,
      0,
      1,
      0.478391,
      1.776954,
      1,
      0,
      NULL,
      0.027645,
      0.720382,
      NULL,
      0,
      NULL,
      3,
      0.688396,
      2,
      8,
      NULL,
      10.290167,
      0.723133,
      2.223635,
      0.524593,
      0,
      1.811027,
      2,
      0.539026,
      0,
      27.337167,
      2,
      3.306405,
      NULL,
      NULL,
      21,
      6,
      3,
      NULL,
      2.670814,
      '13444',
      NULL,
      '',
      0.233651,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      3.746053,
      18.328515,
      27,
      28,
      NULL,
      NULL,
      0,
      2.744573,
      4,
      0.820485,
      NULL,
      NULL,
      0.153910,
      NULL,
      NULL,
      1.284802,
      NULL,
      NULL,
      1,
      3,
      2,
      2,
      3.003879,
      1,
      2.031879,
      NULL,
      3,
      0.891191,
      3,
      3.778804,
      1.135194,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783990,
      NULL,
      NULL,
      4.076243,
      NULL,
      NULL,
      0,
      0.838200,
      3.413919,
      0.928678,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.112329,
      1.630860,
      2.154388,
      2,
      3,
      NULL,
      3.022042,
      3.784329,
      0,
      NULL,
      0.236128,
      2,
      2,
      2,
      2.512597,
      0.818588,
      0,
      0,
      1,
      3.615381,
      0.158555,
      1.725188,
      0,
      3,
      1,
      0,
      3,
      1,
      1.660895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.803893,
      2.941374,
      NULL,
      1,
      2.001875,
      1,
      3.339326,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.063660,
      1,
      1,
      3.114783,
      NULL,
      3.518042,
      0.025399,
      1.045443,
      0.133234,
      NULL,
      NULL,
      NULL,
      3.898588,
      3,
      0,
      1.393313,
      1,
      NULL,
      0.760630,
      0.963123,
      2.197697,
      0,
      2,
      0.564826,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.704538,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      5.730962,
      NULL,
      0,
      0,
      3.249750,
      0.739186,
      1,
      NULL,
      NULL,
      2,
      2,
      0,
      3,
      0,
      1.887255,
      1,
      NULL,
      NULL,
      0.135232,
      0,
      0.035837,
      0,
      3.489104,
      0.025001,
      0,
      1,
      1,
      3.717641,
      3.488366,
      0,
      3.671191,
      0.786288,
      1.075208,
      0.203120,
      7.750897,
      NULL,
      1.904660,
      NULL,
      NULL,
      3,
      2,
      1,
      1.977259,
      1.050561,
      0,
      0,
      0.555817,
      2.520306,
      NULL,
      3.275026,
      2.643551,
      NULL,
      0,
      8,
      NULL,
      1.527874,
      1.303233,
      NULL,
      0.313250,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.759015,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.542298,
      NULL,
      3,
      0,
      NULL,
      1.426235,
      2.495729,
      NULL,
      3,
      2.020125,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.333104,
      NULL,
      NULL,
      NULL,
      0.883755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.499720,
      NULL,
      NULL,
      NULL,
      0.777208,
      NULL,
      NULL,
      NULL,
      1.198437,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.377271,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.776624,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.749134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.128958,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.202111,
      1.027982,
      0,
      0.466806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.406372,
      635,
      2.145151,
      NULL,
      NULL,
      1.483809,
      1.615911,
      0.729971,
      NULL,
      1.454834,
      0.323383,
      0,
      1,
      1.172636,
      1.980175,
      0.342187,
      0,
      1.356156,
      0.582391,
      1.246440,
      1.109329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.835246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010774,
      3.255794,
      2,
      1,
      NULL,
      1,
      0.688739,
      NULL,
      NULL,
      NULL,
      1.437928,
      0.763294,
      0,
      0,
      NULL,
      1.361979,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.254191,
      1.480667,
      1,
      0.168303,
      NULL,
      3.701367,
      2,
      3.837853,
      3.389654,
      0,
      1.421240,
      1.662715,
      0.650249,
      1,
      3.622782,
      0.768918,
      NULL,
      0.481392,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      1.726121,
      0.057499,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.117469,
      1.086569,
      NULL,
      0,
      2,
      0.596330,
      0.894005,
      NULL,
      2,
      NULL,
      1.195736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410347,
      0.795181,
      1,
      NULL,
      0.828596,
      4,
      2,
      5,
      0,
      NULL,
      NULL,
      55.910216,
      NULL,
      4,
      NULL,
      0,
      '30110',
      '',
      NULL,
      0.055864,
      '',
      '',
      NULL,
      0.275137,
      NULL,
      NULL,
      '');
commit;
end;
/


