set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9223205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '3021001',
      1,
      0.010674,
      1,
      1,
      '2343',
      NULL,
      0,
      NULL,
      NULL,
      '10- 1-1977',
      152,
      NULL,
      3,
      NULL,
      0.183725,
      NULL,
      47.405341,
      3.138122,
      146.527514,
      35.173359,
      0,
      ' 4- 7-1993',
      ' 3-13-1996',
      ' 0-16-2001',
      3,
      2,
      3.805681,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.622320,
      NULL,
      0.612120,
      25,
      2,
      33.378950,
      0,
      1,
      7.282935,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      2,
      1,
      0,
      1,
      1,
      0.502535,
      NULL,
      NULL,
      1.804197,
      NULL,
      NULL,
      0,
      0,
      1.099828,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      2,
      4,
      1,
      0,
      0,
      2,
      2,
      NULL,
      0.809122,
      NULL,
      0,
      2,
      0,
      1.041214,
      NULL,
      3.340373,
      3,
      4,
      4,
      3,
      0,
      NULL,
      0,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      5,
      NULL,
      2,
      2,
      4,
      NULL,
      0,
      0,
      1,
      4,
      3,
      0,
      4.726619,
      0,
      '11-28-2001',
      1901,
      '10-15-1994',
      15.005612,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.852929,
      0,
      0,
      1.432453,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779830,
      1.456059,
      1.040957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.767814,
      1.794002,
      0,
      0,
      NULL,
      NULL,
      0.096677,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      0,
      2,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      2,
      1,
      NULL,
      0,
      2.383312,
      0,
      0.370767,
      0.367365,
      2,
      0,
      0,
      1.490251,
      0,
      0,
      1.518936,
      0,
      NULL,
      0,
      0.213651,
      2.763117,
      NULL,
      NULL,
      9.070589,
      6.156528,
      1,
      6,
      6,
      2,
      NULL,
      2.069671,
      NULL,
      0.793914,
      2,
      NULL,
      NULL,
      1.255426,
      NULL,
      30,
      23,
      12,
      2,
      0.720707,
      2.913201,
      '03332',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      12.933343,
      372.401990,
      29.314313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.160745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198223,
      NULL,
      NULL,
      0.809296,
      NULL,
      NULL,
      2.615369,
      3.274295,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.279993,
      NULL,
      NULL,
      0.327708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.441202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636754,
      NULL,
      NULL,
      1.425540,
      NULL,
      0.650095,
      3.999842,
      1,
      1,
      0.975130,
      NULL,
      NULL,
      2,
      1,
      2,
      3,
      1.773871,
      0.929378,
      1.983448,
      NULL,
      NULL,
      0.007605,
      1,
      0,
      1.568909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.754502,
      1,
      NULL,
      0.895544,
      NULL,
      NULL,
      0.523036,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.193026,
      2,
      NULL,
      NULL,
      NULL,
      4.521183,
      3.822251,
      3,
      7.667449,
      1,
      1.167387,
      7,
      0,
      4.154728,
      NULL,
      2,
      2.232042,
      2.422416,
      3,
      3.231637,
      3,
      1.310184,
      NULL,
      NULL,
      3.697568,
      NULL,
      1,
      2,
      1,
      NULL,
      2.503859,
      0,
      1.881559,
      NULL,
      NULL,
      1,
      0.110927,
      3,
      5.360188,
      1,
      4.369680,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      1.975706,
      NULL,
      1,
      1.075869,
      0.171269,
      0.003659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627685,
      0.151602,
      NULL,
      1.984563,
      0.829688,
      1.316669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.903511,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.348165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      568.440945,
      0.400417,
      1,
      1,
      0.679983,
      1.323424,
      1.334466,
      1.280074,
      0.714673,
      0.902160,
      1,
      0.916826,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.192130,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.805066,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526693,
      0.987950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.107110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485773,
      1.396829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.352288,
      3.493990,
      1,
      0,
      1,
      0.277903,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1.402171,
      1.425396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.019621,
      NULL,
      1.290550,
      1.150735,
      NULL,
      2.075207,
      1.431051,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.830533,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.160291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      2,
      NULL,
      1.080122,
      1.925032,
      2,
      44,
      47,
      NULL,
      0.029584,
      3,
      '22134',
      '',
      '',
      0.817519,
      '',
      NULL,
      NULL,
      0.736871,
      '',
      '',
      '');
commit;
end;
/


