set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8529806';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '4124040',
      0.937664,
      0.091795,
      2,
      1,
      '0423',
      0,
      NULL,
      NULL,
      NULL,
      '10-10-2000',
      NULL,
      NULL,
      3,
      2.021801,
      1,
      '10-20-1974',
      4,
      2.708161,
      1,
      129.662426,
      3,
      ' 7-14-2003',
      NULL,
      ' 7- 9-1984',
      2,
      0,
      2,
      NULL,
      1,
      1,
      4,
      1.808560,
      0,
      21,
      7,
      16,
      5,
      NULL,
      28.368960,
      4,
      18.187530,
      NULL,
      2,
      NULL,
      0.916669,
      NULL,
      3,
      0.619626,
      1,
      0,
      1,
      0.360114,
      1,
      1,
      0.141797,
      NULL,
      0,
      5,
      0,
      NULL,
      1,
      4,
      NULL,
      1,
      0,
      5,
      0,
      0,
      NULL,
      3,
      NULL,
      0.447821,
      NULL,
      2,
      0,
      0,
      0.062129,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      1.476887,
      1.019715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.918537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      0.271362,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1.201793,
      0,
      0,
      1,
      1,
      0,
      4,
      2,
      0,
      NULL,
      NULL,
      4,
      3,
      NULL,
      1,
      0,
      2,
      NULL,
      1,
      3,
      1,
      NULL,
      2,
      5,
      NULL,
      1,
      1,
      NULL,
      ' 0- 4-1986',
      571.105596,
      NULL,
      504.824146,
      3,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      374.702218,
      0,
      3.236533,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1.582831,
      NULL,
      NULL,
      NULL,
      3.611823,
      1.286553,
      4,
      6.835156,
      0,
      0,
      0.702791,
      NULL,
      NULL,
      NULL,
      2.380804,
      5,
      2.763634,
      NULL,
      5,
      2,
      2.859073,
      ' 6-26-1979',
      282,
      ' 3- 2-1994',
      287.793529,
      0,
      NULL,
      0.297083,
      0,
      2,
      NULL,
      1.266153,
      NULL,
      1.678801,
      0,
      0.910431,
      58,
      1.675511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.021088,
      NULL,
      1,
      3,
      1,
      0,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      3.106392,
      3.187013,
      3.359524,
      1,
      0,
      2.562802,
      2,
      1.022444,
      1.070284,
      1.198357,
      0.044798,
      0.893616,
      0,
      0.295430,
      1,
      1,
      5.838689,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531065,
      NULL,
      NULL,
      7,
      45,
      3,
      1.302601,
      1.346576,
      '30121',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.458483,
      '',
      '',
      '',
      2,
      4,
      165,
      27,
      0.232692,
      51.681855,
      NULL,
      5,
      2,
      1.396838,
      0,
      3.000378,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1.397884,
      NULL,
      NULL,
      1.760960,
      NULL,
      NULL,
      2.811020,
      3,
      0.424309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.192246,
      7.107661,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      0.583158,
      NULL,
      NULL,
      1.052066,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.654365,
      NULL,
      NULL,
      1.534582,
      NULL,
      NULL,
      0.867802,
      NULL,
      NULL,
      0.895582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.340826,
      1.669090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.431982,
      7.244233,
      1.162337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.329685,
      3.935095,
      1.416633,
      3.845872,
      1,
      9,
      5,
      5,
      3,
      2.617373,
      1.313684,
      3.670664,
      5,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.558519,
      7.336137,
      3.293805,
      2.903712,
      3.096856,
      3,
      NULL,
      0,
      0,
      0.952577,
      0.945482,
      1,
      1.462789,
      NULL,
      0.372006,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.977975,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.293234,
      NULL,
      NULL,
      0.252912,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.775721,
      NULL,
      NULL,
      0.352903,
      NULL,
      NULL,
      2.207338,
      0,
      3,
      0,
      3.585156,
      0.802745,
      3.901946,
      NULL,
      0,
      NULL,
      1.331483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0.386768,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.376110,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.699599,
      NULL,
      NULL,
      NULL,
      1.581107,
      NULL,
      NULL,
      NULL,
      0.612834,
      NULL,
      NULL,
      NULL,
      0.745086,
      0.099784,
      1,
      NULL,
      0,
      1.437637,
      1.832746,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.618502,
      1.708666,
      0,
      NULL,
      1.800117,
      1,
      0,
      NULL,
      0,
      2,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      7.620199,
      0.049095,
      NULL,
      NULL,
      0.422237,
      0.127746,
      NULL,
      NULL,
      NULL,
      2.728395,
      29,
      NULL,
      NULL,
      36.231916,
      NULL,
      1,
      NULL,
      NULL,
      0.187967,
      NULL,
      NULL,
      3.016000,
      3.766024,
      5.816244,
      1.208038,
      NULL,
      NULL,
      1.003660,
      NULL,
      1,
      167.908601,
      1.346852,
      0,
      1.827958,
      0,
      0.770606,
      NULL,
      0.133865,
      0.638236,
      1.063897,
      1.029415,
      1,
      1,
      0.327055,
      1.935043,
      NULL,
      1,
      0.529907,
      NULL,
      0.493350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0.075823,
      1,
      NULL,
      0.475854,
      3.035074,
      NULL,
      1,
      1.236915,
      1,
      NULL,
      NULL,
      NULL,
      1.607023,
      0.313392,
      3,
      1.343301,
      1,
      1.584490,
      NULL,
      0,
      NULL,
      0.847906,
      1,
      NULL,
      0.381192,
      0.141659,
      1,
      0,
      0,
      1.199508,
      0,
      1,
      NULL,
      1.008860,
      0.056409,
      2.103989,
      NULL,
      1.915915,
      0,
      3.420247,
      1.731414,
      0.165265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.365559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506911,
      0,
      1.383731,
      0,
      0.066656,
      2,
      1,
      7,
      1.886949,
      NULL,
      NULL,
      55.501741,
      NULL,
      3,
      NULL,
      0,
      '10022',
      '',
      NULL,
      0.507152,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


