set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '4134130',
      NULL,
      0.762000,
      0,
      NULL,
      '4343',
      2,
      1.325728,
      NULL,
      NULL,
      ' 6-27-1985',
      9,
      NULL,
      5,
      1.298512,
      0,
      ' 7-10-1982',
      78,
      3,
      218,
      30.219630,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.919795,
      1.452585,
      0,
      1,
      0,
      1,
      1,
      299,
      NULL,
      8.593018,
      NULL,
      141,
      76.146064,
      2,
      NULL,
      NULL,
      3,
      2.275643,
      1,
      1,
      1,
      0,
      0,
      1.940848,
      0,
      1,
      NULL,
      1,
      20,
      NULL,
      4,
      7,
      3.318813,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      4,
      NULL,
      1,
      1,
      4,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      4,
      3,
      3,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0.377348,
      5,
      1,
      0,
      0,
      0,
      0,
      3,
      2,
      1,
      2,
      1,
      0,
      NULL,
      2,
      1,
      4,
      2,
      4,
      4,
      NULL,
      1,
      0,
      NULL,
      3,
      3,
      4,
      0.637633,
      ' 3- 0-1975',
      NULL,
      ' 9-18-1980',
      1060,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019818,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.622197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.278370,
      1,
      1,
      NULL,
      1.116740,
      1,
      0,
      NULL,
      NULL,
      0.574540,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521016,
      1.526734,
      0.534569,
      NULL,
      NULL,
      11.787188,
      9.730860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      25,
      NULL,
      0,
      1,
      4,
      '14204',
      '30413',
      NULL,
      0.617419,
      '',
      NULL,
      '',
      2,
      NULL,
      '',
      NULL,
      0.787345,
      35.529167,
      842,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.105956,
      1,
      NULL,
      NULL,
      0.968694,
      NULL,
      NULL,
      0.466727,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.181228,
      1,
      0.427755,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      1.303671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.619724,
      1.520405,
      6,
      1,
      0.003112,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191682,
      0.045817,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      1.979954,
      0,
      NULL,
      0.406642,
      1.214208,
      0,
      1,
      0,
      0,
      0,
      0.800067,
      0,
      1.647529,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361836,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.299802,
      NULL,
      NULL,
      NULL,
      0.693858,
      3,
      NULL,
      1.794648,
      NULL,
      NULL,
      3.045994,
      2,
      1.786645,
      NULL,
      NULL,
      NULL,
      1.039512,
      5,
      7.205828,
      3.181033,
      3.333618,
      3.531956,
      2,
      1.759660,
      0,
      0.985344,
      4.220050,
      NULL,
      1.050819,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.945725,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.590663,
      NULL,
      NULL,
      0,
      4.681445,
      7.945616,
      NULL,
      2,
      2.498043,
      NULL,
      4,
      1,
      NULL,
      NULL,
      3,
      3,
      0.816929,
      0.361612,
      NULL,
      NULL,
      7,
      3.208059,
      7.274126,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2.239121,
      NULL,
      1.004041,
      4.288105,
      2,
      2.168237,
      3,
      5.502650,
      NULL,
      3.887953,
      1,
      4,
      NULL,
      0.429103,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.644041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369802,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.986294,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      1,
      1,
      1,
      1.559816,
      0.493206,
      1.218618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.479497,
      NULL,
      NULL,
      NULL,
      0.699444,
      NULL,
      NULL,
      NULL,
      2.808529,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.686564,
      NULL,
      NULL,
      NULL,
      0.066792,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      728,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687571,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      6309,
      774.452721,
      NULL,
      0,
      0.757783,
      0,
      NULL,
      NULL,
      1,
      1.894380,
      1,
      1.086744,
      0,
      1,
      0,
      0.061265,
      NULL,
      0.443358,
      0.621395,
      1.879796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.379764,
      1.255811,
      2,
      2,
      3,
      2.640724,
      NULL,
      0,
      0.876328,
      NULL,
      14,
      NULL,
      NULL,
      2,
      NULL,
      0.272342,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.785390,
      NULL,
      3,
      0.013117,
      NULL,
      0,
      1,
      NULL,
      1,
      0.528333,
      NULL,
      NULL,
      1.904033,
      NULL,
      0,
      0.243325,
      NULL,
      NULL,
      1.797566,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3.334303,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3.466996,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      15.365911,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      14.813995,
      NULL,
      NULL,
      0.141960,
      NULL,
      NULL,
      NULL,
      0.926431,
      NULL,
      2,
      5,
      2,
      2.308579,
      0,
      NULL,
      23,
      31,
      4,
      NULL,
      0,
      '42240',
      '11131',
      '10243',
      0,
      '',
      NULL,
      NULL,
      3.078904,
      '3430',
      '',
      '');
commit;
end;
/


