set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8236936';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3204310',
      1,
      NULL,
      0,
      0,
      '4124',
      NULL,
      NULL,
      NULL,
      41.206110,
      '11-23-1998',
      NULL,
      NULL,
      3,
      1.638278,
      NULL,
      ' 5-19-2002',
      28,
      2.827716,
      106,
      19.151215,
      NULL,
      ' 0- 8-2001',
      ' 3-21-1975',
      NULL,
      NULL,
      1.391745,
      0.033542,
      NULL,
      1,
      0.726578,
      2,
      0,
      0.065734,
      15.433662,
      3,
      18.042220,
      2.351981,
      2.960798,
      NULL,
      0,
      19,
      0,
      2,
      NULL,
      1.782514,
      3,
      NULL,
      2,
      0.614834,
      1.327259,
      NULL,
      3.731892,
      NULL,
      0.780019,
      1.265378,
      2,
      2,
      4,
      3,
      NULL,
      1,
      0,
      0,
      5,
      2,
      0,
      1,
      5,
      2,
      1,
      0,
      8,
      1,
      0,
      1,
      2,
      0.846927,
      NULL,
      NULL,
      1.072980,
      NULL,
      NULL,
      2,
      0,
      0.800688,
      0.936677,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992999,
      NULL,
      2,
      2.253293,
      NULL,
      2,
      NULL,
      1,
      3,
      1.778396,
      1.057617,
      0,
      3,
      2,
      4,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0,
      2,
      4,
      2,
      0,
      NULL,
      4,
      1,
      0,
      1,
      2,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1.132541,
      0,
      0,
      1,
      0,
      1,
      1,
      5,
      0,
      1,
      1,
      0,
      0,
      3,
      1,
      5,
      NULL,
      0,
      4,
      5,
      NULL,
      3,
      4,
      NULL,
      0,
      3,
      NULL,
      3.776643,
      NULL,
      NULL,
      '11- 8-1996',
      NULL,
      3.559032,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3,
      NULL,
      1,
      0,
      NULL,
      0.881173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      1,
      3,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196282,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.825576,
      NULL,
      NULL,
      1,
      9.900837,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113880,
      NULL,
      42.917114,
      3,
      3,
      6.307191,
      54,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      2,
      1,
      3,
      3,
      3,
      1,
      2,
      0,
      3.930662,
      0,
      NULL,
      NULL,
      0,
      0,
      0.395996,
      NULL,
      1,
      1.157413,
      1.589105,
      0,
      NULL,
      0.979175,
      NULL,
      1,
      0,
      4,
      1.212029,
      NULL,
      8,
      3,
      1.588841,
      3,
      0.749127,
      2.308793,
      1,
      3,
      0,
      2,
      2.351478,
      NULL,
      1,
      1.320641,
      NULL,
      40,
      20,
      53.241853,
      4,
      1.816312,
      NULL,
      '10410',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '34033',
      '',
      NULL,
      3,
      3,
      169,
      11.103530,
      2,
      33,
      4.381926,
      61,
      5,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      1.386676,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      3.134553,
      1,
      3.176079,
      2.356028,
      NULL,
      3,
      NULL,
      0.183144,
      0.187673,
      NULL,
      NULL,
      NULL,
      0,
      2.737566,
      2.011515,
      0,
      1,
      2,
      2,
      3.181289,
      1,
      NULL,
      NULL,
      1,
      4.423182,
      9.139991,
      NULL,
      1.984973,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670712,
      3.701157,
      0,
      NULL,
      3.488534,
      0.490112,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.908980,
      2.317371,
      0.411197,
      NULL,
      NULL,
      1.445421,
      0.629825,
      1.394123,
      NULL,
      NULL,
      0.102473,
      1,
      1.727556,
      1.844398,
      NULL,
      NULL,
      14.683038,
      NULL,
      NULL,
      0,
      0.074423,
      1,
      5.924938,
      2.275917,
      0,
      0,
      1.925382,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293254,
      3.964319,
      0.357467,
      1.946286,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      4,
      1,
      2.434808,
      NULL,
      1,
      1.272721,
      0.061715,
      0,
      0,
      5,
      1.269831,
      6.920264,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.208411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.366793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.759066,
      NULL,
      NULL,
      4,
      7.737056,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.339351,
      0.157694,
      1,
      NULL,
      3,
      NULL,
      0,
      2.791194,
      3,
      0,
      7.876678,
      0,
      6,
      1,
      1,
      2.242575,
      3,
      2.569906,
      1,
      2,
      0,
      1.678957,
      3.291301,
      NULL,
      5.131100,
      7.762063,
      1,
      4,
      5.416811,
      0,
      3,
      0,
      1.364865,
      0.113192,
      NULL,
      1.375598,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.049773,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.193588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968961,
      0.766055,
      3,
      NULL,
      0.104510,
      0,
      1.567353,
      NULL,
      6.599383,
      0.247660,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      1.523128,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.892719,
      0.362586,
      NULL,
      NULL,
      2.728873,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.662286,
      NULL,
      NULL,
      NULL,
      0.250889,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      0,
      0.306294,
      NULL,
      NULL,
      0.116237,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.146032,
      1,
      NULL,
      NULL,
      1.470760,
      0,
      NULL,
      NULL,
      3.540499,
      2.983112,
      NULL,
      NULL,
      0.678673,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      2,
      5,
      0,
      NULL,
      NULL,
      2.094413,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      123,
      NULL,
      3,
      31.183803,
      21,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473412,
      558.353728,
      178.031558,
      0.032290,
      0.779997,
      1.042747,
      1,
      1.075514,
      NULL,
      1,
      1.794202,
      0,
      0.114092,
      1.787075,
      NULL,
      1,
      1.632466,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.499769,
      NULL,
      1.391130,
      NULL,
      0,
      NULL,
      0,
      NULL,
      22,
      NULL,
      2,
      44,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.211810,
      NULL,
      0.940626,
      NULL,
      0,
      NULL,
      0.984587,
      NULL,
      1.388661,
      NULL,
      0,
      NULL,
      0.309671,
      NULL,
      0.962982,
      NULL,
      0.418274,
      1,
      1.966695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.356494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565076,
      1.189074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.768740,
      NULL,
      0.301119,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.235549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.852247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      5,
      NULL,
      1.234518,
      3,
      0,
      8,
      1,
      3,
      0.975454,
      1.008468,
      1,
      NULL,
      0.564157,
      0,
      NULL,
      NULL,
      0.835199,
      NULL,
      1,
      1,
      NULL,
      1,
      1.812315,
      NULL,
      0,
      0.979629,
      NULL,
      1.832050,
      1.056537,
      NULL,
      0.117835,
      1,
      NULL,
      1.880898,
      NULL,
      NULL,
      NULL,
      18.904890,
      NULL,
      NULL,
      0,
      NULL,
      0.052372,
      1.049193,
      0.795139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569722,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      4,
      3,
      0,
      2,
      27.519164,
      33,
      3,
      1,
      5.249223,
      '00410',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      3,
      '43122',
      '',
      '');
commit;
end;
/


