set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4810533';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      NULL,
      31,
      1,
      '1240231',
      2,
      NULL,
      NULL,
      2,
      '0131',
      NULL,
      0,
      NULL,
      NULL,
      ' 2-16-1980',
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 6-24-1981',
      '11-24-1984',
      ' 5- 7-1986',
      1.293759,
      1.145557,
      0,
      0.451866,
      NULL,
      1,
      7,
      1.243262,
      0,
      NULL,
      NULL,
      16.105109,
      4.092498,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.317854,
      1,
      1,
      1.974251,
      1,
      1.131871,
      1,
      0.333152,
      0,
      1.212396,
      8,
      5,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      4,
      5,
      0,
      2,
      1,
      NULL,
      3,
      2,
      1,
      1,
      1,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      0.636400,
      NULL,
      NULL,
      0,
      0,
      2.190496,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0.525516,
      0,
      1.458697,
      0,
      NULL,
      NULL,
      1.616451,
      NULL,
      0,
      0,
      0,
      0,
      7.603032,
      3,
      NULL,
      5.285945,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      2,
      5,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      2,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0.966914,
      NULL,
      3,
      0,
      0,
      3,
      2,
      3,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3,
      2,
      4,
      2,
      0,
      3,
      NULL,
      1,
      1,
      0,
      7.465878,
      0.227506,
      ' 2- 4-1976',
      1054,
      ' 6- 6-1993',
      NULL,
      1,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.511572,
      5,
      1.602104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.069520,
      NULL,
      9,
      2,
      1.349589,
      8.355102,
      6,
      0,
      3.209570,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1.437098,
      1.589582,
      NULL,
      3,
      1.940840,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      0,
      1,
      3,
      1,
      NULL,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080411,
      10.887072,
      NULL,
      NULL,
      0.499845,
      2,
      NULL,
      5,
      2,
      4,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0.858012,
      NULL,
      NULL,
      26,
      22,
      1,
      NULL,
      2,
      '4101',
      '',
      NULL,
      1,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1,
      18.768905,
      192.325506,
      43.129546,
      2.558832,
      40.478878,
      25,
      25,
      0,
      3,
      1,
      3.739121,
      1.242688,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.480717,
      0,
      2,
      3,
      2.460553,
      0,
      1,
      NULL,
      NULL,
      1,
      1.229576,
      3.533154,
      1.441270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278232,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      6,
      2.966648,
      1,
      1.540249,
      NULL,
      NULL,
      NULL,
      1.382079,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.519124,
      2,
      0.149510,
      NULL,
      0,
      3,
      1.807733,
      2.247962,
      NULL,
      1.922232,
      0,
      0,
      2.743096,
      NULL,
      2,
      0,
      2,
      3.385992,
      1,
      1.580092,
      0,
      1.565249,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.465019,
      NULL,
      NULL,
      0.443794,
      7,
      0.306388,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.299227,
      NULL,
      NULL,
      NULL,
      1.770104,
      NULL,
      NULL,
      0,
      1.070104,
      3.716086,
      0.601550,
      1,
      NULL,
      1.573179,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      0.809027,
      1,
      1,
      NULL,
      7,
      5,
      1.065113,
      0.160506,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.097789,
      NULL,
      NULL,
      2.414615,
      2.826803,
      3,
      2.251573,
      2.838503,
      1,
      7,
      1,
      0.691420,
      NULL,
      5.360167,
      2,
      4.360147,
      NULL,
      NULL,
      3.915519,
      0.713397,
      1,
      NULL,
      2.799333,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      3.085292,
      1.514350,
      3.754321,
      NULL,
      8.466928,
      9,
      6,
      5,
      7.541997,
      2,
      3,
      0,
      NULL,
      1.846249,
      1.350653,
      1,
      1,
      0.388898,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.000259,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712245,
      0.792007,
      1.554409,
      1.711490,
      1.410852,
      3,
      1.875840,
      NULL,
      NULL,
      0.458021,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.922693,
      1.696133,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.165032,
      0.259312,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.868329,
      NULL,
      NULL,
      NULL,
      2.015404,
      641,
      310,
      1.105242,
      35.480326,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033600,
      NULL,
      NULL,
      0.554268,
      164.909935,
      5,
      1.866757,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898315,
      32.820530,
      NULL,
      1,
      0,
      1,
      1.395901,
      0,
      0,
      1,
      0.562403,
      0,
      0,
      0.077712,
      1,
      0,
      0,
      0,
      0,
      0.701081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      3,
      1,
      2.868555,
      4.046895,
      1,
      NULL,
      2,
      1.648169,
      1.432798,
      0.772027,
      0.347364,
      0.105618,
      0,
      1,
      3,
      1,
      1,
      3.836240,
      0.238740,
      0,
      1.772603,
      0.412762,
      1.798405,
      0,
      0,
      1,
      1.259898,
      1.103287,
      0,
      2,
      1,
      NULL,
      2,
      0,
      0,
      0,
      3,
      NULL,
      0.122969,
      NULL,
      1.565554,
      1.880329,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.849214,
      1,
      0.144554,
      NULL,
      0,
      1,
      5,
      NULL,
      0.725083,
      2,
      NULL,
      16,
      20.727871,
      4,
      4,
      0.772631,
      '1013',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0.974299,
      '',
      '',
      '');
commit;
end;
/


