set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926229';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4024402',
      0.101486,
      NULL,
      3,
      2,
      '1221',
      NULL,
      1.373074,
      NULL,
      NULL,
      ' 7-28-1994',
      5,
      NULL,
      4,
      2.245921,
      0,
      ' 7-21-1998',
      57.559356,
      0,
      186.061312,
      NULL,
      2,
      ' 4-23-1978',
      '11-19-1988',
      ' 6-24-1992',
      NULL,
      2.947750,
      NULL,
      1,
      0,
      1.329766,
      5,
      NULL,
      0.642772,
      NULL,
      3,
      15,
      0,
      8,
      5.816500,
      4,
      16,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2,
      3.035428,
      5,
      0,
      0,
      3,
      0,
      1,
      4,
      0,
      1,
      NULL,
      2,
      0,
      2,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.400111,
      NULL,
      NULL,
      NULL,
      0,
      2.202733,
      1.537063,
      0.547757,
      NULL,
      3.055186,
      NULL,
      0,
      2,
      0,
      0.085143,
      NULL,
      1.903617,
      0.331226,
      NULL,
      NULL,
      1.029875,
      0.958208,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      4,
      0,
      1,
      0,
      5,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0.808575,
      NULL,
      0,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2,
      NULL,
      3,
      5,
      1,
      0,
      5,
      NULL,
      1,
      4,
      0,
      2,
      1,
      1.751233,
      2.980105,
      ' 8-26-1975',
      801,
      NULL,
      92,
      NULL,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      2.968120,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.594100,
      0,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      11.695452,
      0.001340,
      1.275192,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      3,
      3,
      1.561136,
      0.757800,
      3.231987,
      0.366042,
      2.235331,
      NULL,
      6.031841,
      1.659726,
      1,
      NULL,
      NULL,
      NULL,
      1.431850,
      NULL,
      1.758876,
      1,
      1,
      NULL,
      NULL,
      10,
      6.089349,
      6.132478,
      5.138594,
      NULL,
      0.833960,
      5,
      2,
      NULL,
      1.618819,
      3.019430,
      3,
      NULL,
      1,
      0,
      NULL,
      87,
      52,
      4,
      0,
      0.993195,
      0,
      '00000',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3.492816,
      18.345416,
      72,
      9,
      0,
      17.278031,
      NULL,
      12,
      NULL,
      NULL,
      1.756670,
      1,
      0.777787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.098199,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      2,
      0.160045,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.136413,
      1.372326,
      1.552096,
      0,
      NULL,
      NULL,
      0.753551,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.459936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.661492,
      3.960676,
      0,
      NULL,
      1.839588,
      0,
      0,
      0.775115,
      1.277687,
      0,
      1,
      1.978560,
      0,
      NULL,
      2.878620,
      0,
      1,
      3.513541,
      2.767014,
      0,
      NULL,
      0,
      0.082106,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.164720,
      1,
      0.346976,
      7,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.403760,
      NULL,
      NULL,
      0.162846,
      NULL,
      NULL,
      1.585316,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.453667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854496,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.781287,
      1.782884,
      1.832289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.636460,
      NULL,
      NULL,
      3,
      1.328021,
      0.569582,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      1.901256,
      NULL,
      1,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3.121727,
      NULL,
      0,
      6,
      NULL,
      6.732211,
      NULL,
      2,
      2.654278,
      1,
      1,
      1,
      NULL,
      NULL,
      1.382501,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      21.103019,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.751602,
      NULL,
      NULL,
      3.111395,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.153533,
      NULL,
      NULL,
      0.627362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.386115,
      1.297004,
      0.158471,
      2.601514,
      NULL,
      NULL,
      1,
      3.511351,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      3.136918,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.832545,
      NULL,
      NULL,
      NULL,
      2.015943,
      NULL,
      NULL,
      NULL,
      0,
      0.069650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716335,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      0.384873,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      1.149637,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.009525,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.896296,
      NULL,
      NULL,
      NULL,
      0.719680,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.104869,
      41.765512,
      0,
      2,
      NULL,
      0.293190,
      1,
      7.565876,
      892.420734,
      2.491296,
      12.000498,
      0,
      358.355795,
      32,
      1,
      0,
      0,
      2.117952,
      0,
      1.619551,
      1.665745,
      NULL,
      0.652431,
      3.403998,
      1.126543,
      3.436381,
      1.044772,
      0,
      NULL,
      0.930944,
      1.627740,
      1.528221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.298378,
      NULL,
      0.837725,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.177637,
      1,
      0,
      NULL,
      NULL,
      7.037963,
      3.179856,
      3,
      1,
      1.155620,
      1,
      0,
      0.716434,
      1.758527,
      NULL,
      0.558206,
      1,
      0.471830,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.734609,
      2,
      0,
      0,
      1,
      NULL,
      0.317056,
      0.034937,
      0.908490,
      3,
      1,
      0,
      0,
      0.933578,
      1.658903,
      3,
      NULL,
      2.352568,
      0,
      0.543099,
      1.169399,
      2.226805,
      2,
      0.898521,
      0.215173,
      0,
      2.689332,
      NULL,
      0.826639,
      NULL,
      3,
      NULL,
      NULL,
      1.464951,
      0.868596,
      NULL,
      1.277549,
      0.746339,
      1,
      0.479762,
      1,
      0.216916,
      3.944135,
      4.851838,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.925710,
      0,
      1,
      NULL,
      2,
      2,
      0,
      0,
      2.187929,
      65.619781,
      33.610877,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      1.628670,
      '',
      '',
      '',
      1.774217,
      '',
      '',
      '');
commit;
end;
/


