set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '42',
      NULL,
      16.099614,
      0.998452,
      '2240404',
      1.554476,
      0,
      5,
      0,
      '2044',
      1,
      0,
      NULL,
      NULL,
      ' 1-23-2000',
      40,
      NULL,
      NULL,
      NULL,
      1,
      ' 3-27-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '10-19-1996',
      ' 1- 2-1999',
      ' 3-17-1994',
      2.926059,
      0.264368,
      NULL,
      NULL,
      0.838660,
      0,
      2,
      1.470593,
      1,
      7,
      8,
      NULL,
      5.200772,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      3,
      0,
      0,
      0.173733,
      1.217698,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      1,
      2.777782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.745640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.649072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2,
      2,
      5,
      1,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1.352725,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      5,
      3,
      3,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      4,
      0,
      2,
      5,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      2,
      5,
      4.357538,
      NULL,
      ' 9- 2-1986',
      241,
      ' 7-15-1981',
      9,
      1.246501,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738625,
      1,
      NULL,
      8.392137,
      2,
      2.990488,
      0.292613,
      1,
      NULL,
      NULL,
      1.036621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125601,
      2.502570,
      0,
      0.361474,
      1.453047,
      1.118203,
      1,
      1,
      3.171032,
      2,
      0.033816,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.692483,
      2,
      3,
      NULL,
      3,
      3,
      NULL,
      0,
      2,
      0,
      2,
      2,
      2,
      2,
      3,
      0.490883,
      0.729694,
      1.685425,
      1,
      1,
      1,
      NULL,
      0.782183,
      0.308621,
      0.580124,
      1.806356,
      1,
      1,
      1,
      1.347714,
      3,
      7,
      NULL,
      1.542018,
      5,
      0,
      2.551720,
      2,
      4,
      1.999626,
      2.023042,
      NULL,
      22.890624,
      NULL,
      2,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      3,
      '2300',
      '00420',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '33324',
      '',
      '',
      0.338284,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636537,
      NULL,
      NULL,
      0.557828,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.756142,
      NULL,
      NULL,
      1.474627,
      NULL,
      NULL,
      0.928605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904035,
      NULL,
      NULL,
      1.961089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087550,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.612215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.138233,
      NULL,
      NULL,
      1.203797,
      NULL,
      NULL,
      0.992264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.732144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572670,
      NULL,
      NULL,
      2,
      3.431365,
      NULL,
      1.237421,
      1.663726,
      NULL,
      1.849132,
      NULL,
      NULL,
      4,
      NULL,
      5,
      0,
      NULL,
      NULL,
      1.353404,
      NULL,
      NULL,
      0.050943,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.967169,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.052676,
      0.607994,
      2,
      2.083373,
      0.650935,
      NULL,
      3.741973,
      6,
      NULL,
      NULL,
      1.956787,
      1.760019,
      1,
      NULL,
      NULL,
      2,
      3.808484,
      2.634551,
      1.516505,
      2,
      0,
      NULL,
      0.415188,
      1.984295,
      9.321585,
      7.693483,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      0.135849,
      NULL,
      3,
      3.707523,
      0,
      NULL,
      1,
      6.142434,
      NULL,
      1,
      NULL,
      2,
      1.529161,
      NULL,
      NULL,
      0.281316,
      0.276242,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500088,
      2.864381,
      1,
      1.448605,
      0.467658,
      4.376130,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.767864,
      NULL,
      NULL,
      NULL,
      3.055199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.828502,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      540.686776,
      2.353285,
      11.897806,
      4046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      72,
      0.976958,
      1.110379,
      1,
      1,
      1,
      NULL,
      0,
      1.449700,
      0.832212,
      1.811942,
      0.804051,
      0.719098,
      NULL,
      NULL,
      NULL,
      1.574978,
      0,
      1.735198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      3,
      2,
      4.472745,
      0,
      12,
      NULL,
      3.136870,
      0,
      0.990432,
      1.081372,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117788,
      0.318280,
      NULL,
      0,
      2,
      NULL,
      0.036719,
      2,
      NULL,
      1.323068,
      0,
      NULL,
      0,
      0.846963,
      NULL,
      0,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.793593,
      0.393205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.223206,
      NULL,
      1,
      3,
      0,
      0.160082,
      NULL,
      NULL,
      6.029074,
      NULL,
      3,
      3,
      1.344653,
      '1442',
      '22444',
      '',
      1.236722,
      '',
      '',
      NULL,
      NULL,
      '02201',
      '',
      '');
commit;
end;
/


