set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9670225';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      32,
      0,
      '2421431',
      1,
      0,
      NULL,
      NULL,
      '0433',
      NULL,
      0.115644,
      NULL,
      NULL,
      ' 1- 7-1990',
      40,
      2.335508,
      NULL,
      3.932482,
      0,
      ' 4- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 2-29-1984',
      ' 5- 4-1989',
      ' 7- 0-2001',
      2,
      NULL,
      0,
      3,
      0.222395,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2.989244,
      9.849302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.491920,
      1.377227,
      1.410105,
      1.584138,
      1.430440,
      3,
      NULL,
      2,
      2.232740,
      5,
      0,
      1,
      3,
      NULL,
      NULL,
      2,
      5,
      2,
      3,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      0.597833,
      NULL,
      NULL,
      2,
      5,
      6,
      1.931649,
      1,
      NULL,
      NULL,
      0.732104,
      1.100250,
      NULL,
      0.954821,
      2,
      1.546938,
      1,
      0.120285,
      0,
      1.556365,
      NULL,
      0,
      2,
      NULL,
      3,
      10.956979,
      1,
      0,
      2,
      2.328851,
      1.794354,
      1.554011,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      4,
      0,
      1,
      0,
      2,
      2,
      NULL,
      2,
      1,
      0,
      5.290223,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      4,
      3,
      3,
      5,
      0,
      0,
      5,
      NULL,
      0,
      2,
      1,
      2,
      2,
      4,
      2,
      4,
      3,
      1,
      NULL,
      1,
      2,
      4,
      NULL,
      3,
      ' 2- 1-2000',
      324.428978,
      ' 0- 7-2000',
      NULL,
      1.559721,
      1,
      1,
      4,
      4,
      NULL,
      2,
      NULL,
      1,
      2,
      0,
      5,
      2,
      3,
      4,
      1,
      4,
      6.438383,
      0.229825,
      8.726914,
      NULL,
      '10-21-1996',
      11.090241,
      '11- 8-1980',
      6.674354,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.598844,
      NULL,
      2.564549,
      3.557344,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462734,
      6,
      1.617505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      3.867919,
      1,
      0.065314,
      1,
      3.475199,
      55.872936,
      0,
      0.417786,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      3,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.843723,
      1.100241,
      0.505657,
      NULL,
      2,
      1,
      NULL,
      0.002711,
      1,
      1.767730,
      NULL,
      1,
      0.282995,
      0.933608,
      1,
      NULL,
      1.902482,
      5.355084,
      0.118312,
      5.394468,
      11,
      5.924354,
      7,
      0.881645,
      3,
      NULL,
      2.303018,
      0.043993,
      3,
      NULL,
      2.516939,
      31.630765,
      2,
      NULL,
      16,
      NULL,
      2,
      13.648928,
      4,
      NULL,
      3.046806,
      '12341',
      '',
      '',
      1.213571,
      '',
      '',
      NULL,
      1.771518,
      '41120',
      '',
      '',
      3,
      1,
      124.640569,
      39.737864,
      NULL,
      11.118145,
      7.470583,
      NULL,
      2,
      3.669674,
      1,
      NULL,
      0.220400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      2,
      3.026270,
      1,
      3,
      2.254447,
      0,
      2,
      0.409930,
      NULL,
      0.723248,
      NULL,
      0.282724,
      NULL,
      1.820547,
      1,
      2.200401,
      1,
      1.775462,
      2,
      0.033820,
      NULL,
      2,
      1.511949,
      0.527382,
      2.179669,
      1,
      7.093136,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.918123,
      NULL,
      NULL,
      2.503609,
      NULL,
      NULL,
      3.115612,
      1,
      NULL,
      1.648468,
      0.920008,
      1.224435,
      2.468407,
      NULL,
      2.890679,
      2,
      3.862004,
      2.370659,
      2.925285,
      1,
      1,
      3.698473,
      NULL,
      NULL,
      0.819593,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.011626,
      3.480133,
      2.167504,
      10.736119,
      4,
      4.095966,
      NULL,
      0.782348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446218,
      1,
      3,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      0,
      1,
      6,
      NULL,
      1.361131,
      NULL,
      1.064669,
      0.397536,
      1.053714,
      NULL,
      NULL,
      1.030679,
      2.242129,
      NULL,
      0.475333,
      NULL,
      NULL,
      0.419008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.297361,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.735167,
      NULL,
      NULL,
      3,
      1,
      0.631659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.660164,
      NULL,
      0.499760,
      NULL,
      2,
      1.185935,
      0,
      2.891633,
      2.929303,
      NULL,
      2.509334,
      2,
      3.064299,
      1,
      NULL,
      1.126291,
      2,
      3.294909,
      0.405217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.354818,
      1,
      0,
      0.767873,
      0,
      1.774590,
      2.948150,
      NULL,
      NULL,
      0.312245,
      NULL,
      4,
      0,
      1,
      0.205532,
      1.719741,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.137769,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.338905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.800375,
      0,
      3,
      1.015033,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.355481,
      NULL,
      NULL,
      NULL,
      1.886164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022138,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.975938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.823859,
      NULL,
      NULL,
      NULL,
      1.268609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.788470,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1.998880,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      NULL,
      2,
      20.838660,
      1,
      0.389624,
      NULL,
      NULL,
      2,
      2,
      2,
      0.740020,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.771910,
      NULL,
      1.414372,
      318,
      11,
      0.615385,
      0,
      0.018632,
      3,
      0,
      NULL,
      0.128250,
      2,
      1,
      2.813102,
      0,
      NULL,
      0.810672,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.186271,
      NULL,
      NULL,
      NULL,
      2.984980,
      NULL,
      3,
      NULL,
      15.416640,
      NULL,
      1,
      25,
      44,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.042435,
      NULL,
      1,
      NULL,
      1.306114,
      NULL,
      1,
      NULL,
      1.891351,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.481120,
      NULL,
      1.799865,
      NULL,
      1.251694,
      NULL,
      0,
      3.321693,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.979579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.615919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      339.604867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484674,
      NULL,
      NULL,
      0.343918,
      0.366205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898798,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      55.463037,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      1.439348,
      NULL,
      0,
      NULL,
      1,
      0,
      1.706607,
      2.713922,
      NULL,
      0,
      2.504007,
      NULL,
      0.184809,
      3.888441,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.954046,
      0,
      NULL,
      0.743494,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.913959,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268849,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.270340,
      NULL,
      NULL,
      82.266954,
      67,
      0,
      0.791615,
      NULL,
      '40043',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


