set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1422224',
      2.401042,
      0,
      1,
      3,
      '1043',
      1.921219,
      1,
      NULL,
      NULL,
      ' 4- 6-1997',
      0,
      NULL,
      3,
      1.091923,
      NULL,
      ' 6-10-1975',
      14,
      2.635943,
      275.131136,
      30,
      3,
      NULL,
      NULL,
      ' 1-10-1984',
      0,
      0.131640,
      0,
      0,
      0.495830,
      1,
      1,
      3.050685,
      NULL,
      NULL,
      NULL,
      9,
      3,
      10,
      4,
      3,
      NULL,
      2,
      2,
      NULL,
      0.530989,
      3,
      1,
      1.178727,
      0,
      1,
      0,
      2,
      0,
      0.483223,
      NULL,
      NULL,
      2,
      6,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.839331,
      NULL,
      NULL,
      0,
      1,
      1.029650,
      1.742586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      4,
      NULL,
      0,
      1,
      5,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      0,
      0,
      1,
      NULL,
      0,
      2,
      4,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      2,
      4,
      1,
      2.212675,
      ' 0-21-1974',
      NULL,
      ' 8- 5-1996',
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.510695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.732836,
      0.709614,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.221988,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.762398,
      NULL,
      1.596666,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.266104,
      3,
      1,
      1,
      3,
      2,
      NULL,
      2,
      2,
      0,
      3,
      0,
      3,
      3.670675,
      2,
      NULL,
      3,
      1.106068,
      1.034049,
      0,
      1.119943,
      NULL,
      1,
      0,
      1.917330,
      1.602802,
      0,
      1,
      1.318329,
      2.542497,
      1,
      4.460856,
      7.782499,
      NULL,
      2.668691,
      4,
      6.730189,
      NULL,
      NULL,
      2.668120,
      0.685373,
      0.523485,
      2.888488,
      31,
      2,
      1,
      81,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '24320',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      29.442117,
      62.769078,
      20,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.499945,
      NULL,
      NULL,
      1.913919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.887367,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.016579,
      0,
      1.506477,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.845488,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460718,
      NULL,
      NULL,
      1.763611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.159283,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.641013,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.044281,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.735850,
      NULL,
      NULL,
      1.011174,
      NULL,
      NULL,
      0.793377,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.582510,
      1.224162,
      NULL,
      NULL,
      3.417632,
      3,
      1.708743,
      1,
      5,
      2,
      NULL,
      NULL,
      NULL,
      0.574903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765038,
      0.176912,
      1.759932,
      0.993312,
      1.266564,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.022301,
      3.947133,
      2.584912,
      1.109176,
      0.903072,
      2.996372,
      3.836111,
      0,
      5,
      0.786542,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.486767,
      0,
      0,
      0.784345,
      0,
      3.570891,
      NULL,
      NULL,
      0.147305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745944,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.599775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532497,
      0,
      NULL,
      0.227608,
      1.877351,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.087241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.767175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501523,
      NULL,
      NULL,
      1,
      1.485251,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.140452,
      23,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.465162,
      0,
      NULL,
      1.113128,
      1.510713,
      0.948872,
      1,
      0.241103,
      NULL,
      NULL,
      0,
      NULL,
      0.064004,
      0,
      0,
      0.695158,
      NULL,
      0,
      1.649328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      4.159992,
      5,
      NULL,
      NULL,
      8.202079,
      2.003731,
      3,
      3.905803,
      NULL,
      1.635386,
      0.496524,
      0.775198,
      3.630845,
      NULL,
      1.435501,
      NULL,
      0.129927,
      0,
      0.389171,
      NULL,
      NULL,
      1.263578,
      1.934446,
      3.749791,
      1,
      0,
      3.543477,
      3,
      NULL,
      0.885282,
      3.796840,
      1.658155,
      0.385738,
      0.851772,
      NULL,
      1.852540,
      1,
      0.886083,
      1.126591,
      0,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177599,
      0,
      0,
      0.528729,
      0,
      1,
      NULL,
      NULL,
      2.459653,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.185568,
      1.374933,
      '10403',
      '',
      '',
      1.041059,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


