set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.506808,
      1,
      1,
      '1304',
      3.797471,
      1.333736,
      NULL,
      NULL,
      ' 6-18-1979',
      13,
      NULL,
      0,
      NULL,
      1,
      ' 5-15-1996',
      33.323088,
      0.119172,
      167.663352,
      NULL,
      0,
      NULL,
      NULL,
      ' 9-24-1997',
      2,
      0,
      1,
      0,
      0,
      0.861494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.817679,
      1,
      16,
      9.354222,
      2,
      22,
      5,
      1,
      4,
      1.266290,
      2,
      NULL,
      1.542201,
      1.508674,
      0,
      1.415916,
      2.672530,
      NULL,
      0.763596,
      0,
      3,
      4,
      5,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      4,
      1,
      1,
      1,
      0,
      0,
      0,
      1.528332,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      2,
      5,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      2,
      1,
      3,
      0,
      0,
      NULL,
      0,
      1,
      0,
      5,
      1,
      3,
      2,
      0,
      NULL,
      0,
      0.578433,
      2,
      NULL,
      31,
      ' 9-28-1979',
      148,
      0.927472,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      0,
      0,
      1,
      1.283021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      21.190899,
      2.984876,
      1.515417,
      4,
      NULL,
      0.894976,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.828528,
      0,
      NULL,
      NULL,
      NULL,
      0.399687,
      1,
      0.688357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.071598,
      NULL,
      1,
      1,
      NULL,
      0,
      1.554894,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.549899,
      3,
      0,
      3,
      3,
      1,
      0,
      3,
      0,
      0,
      3,
      1,
      2,
      5,
      5.067433,
      0.393256,
      3.734513,
      1.112009,
      0.895954,
      1.780031,
      0.211211,
      1.244637,
      0,
      1.347999,
      1,
      NULL,
      NULL,
      3.082726,
      0.157782,
      1,
      11.619290,
      9,
      3,
      9.711696,
      9.203463,
      7.133275,
      3.009666,
      1,
      3.781362,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.468990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941984,
      1.592515,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.431714,
      16,
      47.849778,
      5,
      0.080791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.558843,
      1,
      1.465684,
      NULL,
      NULL,
      0.894210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.686148,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.197775,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.495924,
      0,
      0,
      0.487589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.139796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.321714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.379020,
      NULL,
      NULL,
      0.774268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481338,
      NULL,
      NULL,
      1.790653,
      NULL,
      NULL,
      1.258478,
      NULL,
      NULL,
      0.943263,
      NULL,
      NULL,
      1.596964,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.161139,
      NULL,
      NULL,
      3.826808,
      0,
      3,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.320073,
      1,
      1.816981,
      NULL,
      0,
      3,
      2.510605,
      0.272873,
      3.710985,
      0.217620,
      NULL,
      3.000118,
      2.402009,
      1,
      3.119064,
      2,
      2.387806,
      3,
      7,
      6.973313,
      5,
      2.383096,
      0.357237,
      1,
      NULL,
      0,
      1,
      0,
      0.425280,
      1.481220,
      0.614464,
      2.990660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440815,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.631588,
      1.766627,
      3,
      2.177573,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.199786,
      NULL,
      NULL,
      NULL,
      3.101371,
      NULL,
      NULL,
      NULL,
      2,
      1.181283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.421920,
      NULL,
      NULL,
      NULL,
      0.081510,
      NULL,
      NULL,
      NULL,
      2.500063,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.818361,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.590958,
      0,
      NULL,
      NULL,
      0.322785,
      0.315085,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      0.061402,
      NULL,
      NULL,
      NULL,
      0.705178,
      16.650141,
      NULL,
      1,
      2,
      1.070528,
      NULL,
      NULL,
      NULL,
      0.234347,
      NULL,
      NULL,
      1.401713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.435813,
      0.087552,
      NULL,
      0,
      0,
      1.019297,
      1.438213,
      0.485134,
      NULL,
      1.820004,
      NULL,
      0,
      1,
      0.834139,
      1,
      NULL,
      0.725342,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.333430,
      NULL,
      NULL,
      5,
      2,
      9.242656,
      1,
      3.071286,
      1,
      1,
      0.830751,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      2,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      2,
      2.081434,
      0,
      3.890881,
      2.209333,
      NULL,
      2.997642,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1.813642,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.692600,
      0.107415,
      1.821105,
      0,
      2,
      3,
      1.181186,
      NULL,
      NULL,
      NULL,
      101,
      1,
      1.277377,
      0.905758,
      '32220',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


