set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '4121403',
      0.193667,
      1,
      1,
      2,
      '4044',
      NULL,
      0.883739,
      NULL,
      NULL,
      ' 3-28-1991',
      NULL,
      NULL,
      NULL,
      1,
      0,
      ' 9-14-1986',
      46.012683,
      NULL,
      112,
      NULL,
      1,
      NULL,
      NULL,
      ' 6-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      0.303893,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.307903,
      3.246236,
      3,
      NULL,
      30.084625,
      0,
      2,
      0.283265,
      0.622704,
      0,
      0,
      1.864173,
      1,
      NULL,
      NULL,
      0,
      0.358871,
      1.684130,
      1,
      2,
      2,
      4,
      2,
      5,
      NULL,
      3,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      6.753037,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.644174,
      1.808570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      5,
      0,
      1,
      NULL,
      0,
      5,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      4,
      0,
      4,
      1,
      2,
      '10-27-1994',
      NULL,
      ' 4-27-2002',
      75,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.028733,
      1,
      NULL,
      1.542646,
      0,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.953349,
      5,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.334860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096592,
      NULL,
      NULL,
      NULL,
      1.932510,
      0,
      1.303393,
      NULL,
      3.341839,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582708,
      3.118809,
      2,
      0,
      0,
      1,
      1,
      2,
      1,
      1,
      3,
      2,
      0,
      1.445528,
      4.986000,
      5.372552,
      NULL,
      3,
      1.250363,
      1,
      NULL,
      NULL,
      1.655106,
      0,
      NULL,
      NULL,
      0.844898,
      0,
      3.903384,
      3.415545,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      54,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.891326,
      '11044',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      25,
      22,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.659629,
      NULL,
      NULL,
      0.777379,
      NULL,
      NULL,
      0.943954,
      NULL,
      NULL,
      0.983753,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.464472,
      0,
      1,
      0.445197,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.848642,
      NULL,
      NULL,
      1.058154,
      NULL,
      NULL,
      1.130845,
      NULL,
      NULL,
      3.449672,
      0.167599,
      2.664742,
      0,
      0.383727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537626,
      NULL,
      NULL,
      1.930750,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.174927,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110770,
      NULL,
      NULL,
      1.252858,
      NULL,
      NULL,
      1.701758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.992681,
      NULL,
      NULL,
      1.459257,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.476154,
      NULL,
      NULL,
      5.206714,
      1,
      5,
      3,
      4.275668,
      NULL,
      0.976178,
      NULL,
      NULL,
      0.737443,
      NULL,
      NULL,
      0.302220,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.673660,
      NULL,
      NULL,
      2.956393,
      3.722197,
      3,
      0,
      3.881656,
      3.346697,
      1.295909,
      NULL,
      NULL,
      0,
      2.327977,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.302292,
      3.154758,
      NULL,
      0,
      0,
      0.661973,
      0.214085,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064801,
      NULL,
      NULL,
      1.120494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920761,
      NULL,
      NULL,
      1.191001,
      0.362980,
      0.294296,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.324482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.297413,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.315227,
      NULL,
      NULL,
      NULL,
      3.509939,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.909301,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.948749,
      NULL,
      NULL,
      NULL,
      0,
      0.225751,
      NULL,
      NULL,
      0.469933,
      NULL,
      NULL,
      NULL,
      1.808002,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.265757,
      0,
      NULL,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.584640,
      NULL,
      1.408519,
      NULL,
      NULL,
      1.993705,
      NULL,
      1.700491,
      0.791833,
      0.521871,
      1.764442,
      0.475327,
      0.722805,
      1,
      0.096621,
      1,
      0.609735,
      1.184574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4,
      2,
      NULL,
      1,
      NULL,
      0.544665,
      0.340666,
      0.679602,
      NULL,
      1.376869,
      0.934574,
      0.896262,
      NULL,
      1,
      0.213847,
      3,
      3,
      0.455250,
      1.469338,
      NULL,
      0.242349,
      0,
      1,
      1,
      3.052000,
      2.569780,
      1,
      2.370489,
      NULL,
      1.801757,
      2.007072,
      0.403007,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.364886,
      0,
      NULL,
      1.438560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234883,
      NULL,
      0,
      NULL,
      0.574097,
      1.770054,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57.240172,
      3,
      0,
      0,
      '40314',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.717247,
      '',
      '',
      '');
commit;
end;
/


