set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313052';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '2021242',
      2,
      0,
      3,
      NULL,
      '0243',
      2.411729,
      1,
      NULL,
      NULL,
      ' 3-25-1995',
      13.145668,
      NULL,
      0,
      2.843191,
      1.276037,
      ' 7- 1-1988',
      12.890317,
      0.450949,
      NULL,
      59.021483,
      3,
      NULL,
      ' 6-29-1984',
      ' 0-23-1976',
      NULL,
      2.344344,
      3.507638,
      NULL,
      0,
      3,
      0,
      1.170855,
      0.106885,
      63.186899,
      NULL,
      9.488745,
      2.994952,
      8.583489,
      8,
      3,
      13.285376,
      NULL,
      NULL,
      7,
      1.960870,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.599244,
      0.316048,
      0.068333,
      NULL,
      1,
      1,
      3,
      2,
      0,
      0,
      NULL,
      0,
      0,
      5,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.949119,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      1.056225,
      2.237617,
      1.947256,
      1,
      2,
      1,
      2.004362,
      3.552820,
      1,
      0.824938,
      1.043860,
      NULL,
      1,
      3.498766,
      0.514878,
      2,
      2,
      1,
      0,
      4,
      4,
      0,
      1,
      0.714943,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      4,
      NULL,
      0,
      1,
      0,
      0,
      3,
      0,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1.381191,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0,
      3,
      1,
      1,
      3,
      1,
      5,
      4,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      3,
      0,
      2,
      NULL,
      3,
      NULL,
      435,
      NULL,
      136.135711,
      1,
      NULL,
      1,
      3,
      3,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555677,
      1.138639,
      2,
      NULL,
      0.542514,
      NULL,
      1.768954,
      NULL,
      NULL,
      NULL,
      1.396621,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.582032,
      1,
      0.232649,
      2,
      0.479574,
      1,
      1,
      25,
      2,
      1.601916,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853329,
      3.437807,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      0.498252,
      3.782511,
      0,
      1,
      1,
      1.907460,
      0.544302,
      1.823722,
      2.693204,
      NULL,
      1,
      0,
      0,
      0.797486,
      0,
      1,
      0,
      2,
      NULL,
      0.595344,
      NULL,
      NULL,
      4,
      2.843632,
      NULL,
      1.754021,
      NULL,
      5,
      3,
      0,
      0.709452,
      58,
      0,
      0.395383,
      NULL,
      54,
      35,
      22.350578,
      3,
      1,
      2.511584,
      '42324',
      '',
      '',
      0.316088,
      '',
      '',
      NULL,
      1.865616,
      '',
      '',
      NULL,
      NULL,
      33,
      88,
      24.520356,
      0.106997,
      33,
      14.697143,
      20,
      4,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.228790,
      2.336232,
      1.111332,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.265121,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      4.665744,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      3.718114,
      NULL,
      0.562742,
      0.719802,
      1.512487,
      0.587641,
      0,
      0.312721,
      1.840880,
      0.995671,
      0.320253,
      3,
      0.227822,
      2,
      2,
      1,
      0,
      2.640607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812862,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.313136,
      7.112982,
      NULL,
      0,
      0.602223,
      NULL,
      NULL,
      NULL,
      1.037336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069616,
      1.490297,
      0,
      2,
      0.216200,
      1,
      1,
      NULL,
      NULL,
      1.660683,
      3.697107,
      1,
      1.430907,
      0,
      1.876371,
      2.817239,
      2.083453,
      1,
      NULL,
      4.004958,
      0,
      1,
      NULL,
      NULL,
      0.516414,
      NULL,
      NULL,
      0.770345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.636720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.450593,
      1.834979,
      1.981631,
      NULL,
      NULL,
      1.224364,
      NULL,
      NULL,
      5.811920,
      5.808949,
      1.132597,
      0.339808,
      NULL,
      NULL,
      0.410614,
      3,
      1.379236,
      3,
      3.626540,
      3.710775,
      3.059973,
      1.508814,
      3.179101,
      NULL,
      0,
      0.449294,
      NULL,
      NULL,
      0,
      0,
      2,
      2.370447,
      NULL,
      1,
      2.380155,
      2.023414,
      NULL,
      2,
      2.479613,
      9,
      NULL,
      1,
      0,
      1.941797,
      0.774409,
      NULL,
      3,
      1,
      1,
      NULL,
      0.011765,
      1.974770,
      0.356070,
      NULL,
      NULL,
      0.751354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.800823,
      NULL,
      NULL,
      1.933297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1.316960,
      1.882512,
      0.100973,
      2.230098,
      0.642383,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174525,
      NULL,
      NULL,
      NULL,
      2.129924,
      NULL,
      NULL,
      NULL,
      3.244744,
      NULL,
      NULL,
      NULL,
      0.793727,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.838045,
      NULL,
      NULL,
      NULL,
      1.083525,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.569210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      38,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.165043,
      2.991171,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.288789,
      190.680653,
      18,
      0.974010,
      NULL,
      NULL,
      NULL,
      1.239619,
      NULL,
      0,
      0.511553,
      1,
      1,
      0.077062,
      0,
      1.474629,
      NULL,
      NULL,
      NULL,
      1.926478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      5,
      1,
      4.398900,
      0,
      18,
      NULL,
      NULL,
      1,
      1.781678,
      0,
      NULL,
      2.973072,
      3.825553,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3.199791,
      3.477533,
      NULL,
      3.084161,
      2.028117,
      NULL,
      0,
      3.674962,
      NULL,
      2,
      NULL,
      NULL,
      0.792043,
      0.559974,
      0.406222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.387854,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.884984,
      NULL,
      NULL,
      1.107302,
      NULL,
      0.443563,
      NULL,
      0,
      NULL,
      3,
      NULL,
      4,
      NULL,
      3.648331,
      1,
      NULL,
      15.715555,
      NULL,
      1,
      3,
      '02402',
      '34044',
      NULL,
      3,
      '23342',
      '',
      '',
      0.003097,
      '',
      '',
      '');
commit;
end;
/


