set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8620424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '2304202',
      3.494378,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      3,
      NULL,
      0.238587,
      NULL,
      33.840894,
      NULL,
      224.833972,
      NULL,
      1,
      ' 0- 9-1997',
      ' 5-14-1993',
      ' 5- 8-1981',
      1,
      1,
      NULL,
      NULL,
      1.864002,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      25,
      1,
      1,
      6.812614,
      2.449988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      4,
      0,
      2,
      0,
      0,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      2,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1.152581,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1.886873,
      2.853411,
      2,
      0.305914,
      NULL,
      0.447674,
      1,
      0,
      1,
      1,
      0,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      3,
      4,
      NULL,
      3,
      3,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1.689883,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0,
      1,
      2,
      5,
      1,
      2,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      5,
      3,
      1,
      3,
      1,
      3,
      4,
      0.138866,
      ' 2- 0-1982',
      5,
      NULL,
      4.997094,
      0.040602,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      2.450418,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      2.599287,
      0.716916,
      3,
      1.402462,
      0,
      5.880785,
      3.096577,
      4.795090,
      0.617015,
      1,
      NULL,
      NULL,
      1.497474,
      0.193333,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      1.328688,
      NULL,
      1,
      NULL,
      4,
      3.109282,
      1.238529,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      2,
      0,
      3,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      5,
      141,
      81,
      NULL,
      2.669379,
      NULL,
      1.346025,
      1,
      0.262675,
      1,
      1,
      1.452576,
      NULL,
      1,
      19.341732,
      13.045595,
      0.628198,
      9.873911,
      5,
      0,
      9.345863,
      1,
      0.564749,
      4,
      0.833799,
      4.216685,
      NULL,
      1,
      1,
      10,
      0,
      1.210865,
      NULL,
      29,
      NULL,
      82,
      NULL,
      0.791579,
      NULL,
      '40013',
      '',
      '',
      1.619169,
      '',
      NULL,
      NULL,
      2.637068,
      '13203',
      '',
      '',
      1,
      NULL,
      96,
      NULL,
      NULL,
      36,
      7.512492,
      0,
      5,
      0,
      3,
      2.339179,
      0,
      3.205710,
      1,
      1.313890,
      1.387991,
      0.503681,
      0.518416,
      NULL,
      NULL,
      1.852818,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.897350,
      NULL,
      NULL,
      0,
      3,
      0,
      1.399495,
      NULL,
      NULL,
      3,
      1,
      1.482222,
      1,
      2.695575,
      0.313053,
      3.179670,
      4.293453,
      1.058896,
      1,
      1.139010,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      3,
      1.789779,
      1,
      NULL,
      NULL,
      3.815307,
      1.329707,
      0,
      2,
      0.613555,
      0.058936,
      0.507020,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1,
      0.077607,
      1.159402,
      1,
      NULL,
      NULL,
      1.993323,
      NULL,
      NULL,
      1.851147,
      NULL,
      NULL,
      3.074509,
      5.203913,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350015,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.711670,
      NULL,
      NULL,
      NULL,
      1.719684,
      0.086931,
      0,
      NULL,
      NULL,
      5.404255,
      4.481552,
      1.563916,
      3.988913,
      0,
      1.164646,
      NULL,
      NULL,
      NULL,
      1.409682,
      0,
      1,
      1.209067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.421016,
      NULL,
      NULL,
      1,
      2,
      1.435418,
      2.382497,
      NULL,
      NULL,
      7,
      0.695363,
      0,
      NULL,
      2.145628,
      1,
      0.241798,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.306956,
      0,
      1.297200,
      1,
      3,
      0,
      1.641065,
      2.713513,
      NULL,
      1,
      2.799709,
      0,
      3,
      0,
      0,
      0.612492,
      0.737340,
      2.163386,
      2.947112,
      NULL,
      0.863326,
      2,
      3,
      4,
      1.887609,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      0.962070,
      1.505118,
      0,
      0,
      2.121997,
      NULL,
      NULL,
      0.756571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099867,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131284,
      0,
      0,
      0,
      NULL,
      0.426082,
      NULL,
      NULL,
      NULL,
      5.221140,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555529,
      NULL,
      NULL,
      NULL,
      3.353317,
      0,
      NULL,
      NULL,
      1.321981,
      NULL,
      NULL,
      NULL,
      0.201023,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.275125,
      1,
      NULL,
      NULL,
      1.662866,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.876921,
      NULL,
      NULL,
      NULL,
      1.451996,
      NULL,
      NULL,
      1,
      3.074776,
      NULL,
      NULL,
      2.223249,
      0,
      NULL,
      NULL,
      9,
      2.849472,
      NULL,
      NULL,
      0,
      3.968257,
      6,
      NULL,
      2,
      3,
      NULL,
      NULL,
      13,
      NULL,
      1.477485,
      NULL,
      NULL,
      0.288158,
      NULL,
      NULL,
      0.382651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      320.105146,
      8,
      0,
      1,
      1,
      NULL,
      0.166790,
      0,
      0.787783,
      0,
      0,
      1.297478,
      0,
      0,
      1.994522,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.765129,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      8.640447,
      0,
      2,
      1,
      2,
      12,
      0.855001,
      0,
      0.410938,
      3.882190,
      3.012684,
      NULL,
      1.634058,
      1,
      2,
      NULL,
      0.206960,
      1,
      0,
      0.796394,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.641921,
      1.571672,
      1,
      1,
      0,
      0.236309,
      0.338286,
      NULL,
      0,
      1,
      NULL,
      0,
      1.463482,
      NULL,
      NULL,
      0.666981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.171870,
      0.825106,
      1,
      1.090094,
      3,
      3,
      0,
      0.645463,
      NULL,
      NULL,
      51,
      46.212202,
      NULL,
      0.390890,
      NULL,
      '40434',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3.019728,
      '01140',
      '',
      '');
commit;
end;
/


