set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8620424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '2422401',
      1,
      0,
      4,
      0,
      '1332',
      1.572659,
      1,
      NULL,
      NULL,
      ' 9- 6-2000',
      38,
      NULL,
      0,
      1,
      NULL,
      '10-14-1991',
      57.841539,
      2.650818,
      NULL,
      6.639644,
      1,
      ' 3-28-1982',
      ' 3-22-2003',
      '11-13-1984',
      0.826960,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      25.426855,
      5,
      NULL,
      5,
      0,
      NULL,
      3.817822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2.618359,
      5,
      1,
      4,
      0,
      0,
      0,
      3,
      0,
      0,
      0,
      1,
      1,
      6.453487,
      1,
      0,
      2,
      1,
      0.225215,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.977396,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.302731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      3,
      1,
      3,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0.628673,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1.998228,
      2,
      4,
      NULL,
      0,
      1,
      2,
      1,
      5,
      5,
      2,
      5,
      5,
      1,
      NULL,
      0,
      NULL,
      4,
      1,
      3,
      0,
      3,
      3,
      4,
      4,
      2,
      1.564096,
      NULL,
      NULL,
      NULL,
      ' 5- 6-1975',
      6.590440,
      0.791205,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.927321,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655483,
      1.246767,
      8.311135,
      1.558594,
      3,
      3,
      1.338051,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.445666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.204032,
      0.317987,
      1,
      0,
      0,
      0,
      3.879312,
      8,
      0.159552,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0,
      1,
      3,
      1,
      1,
      3,
      3,
      3,
      3,
      3.323733,
      2.700318,
      NULL,
      0.483078,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1.647746,
      0,
      1.224060,
      1,
      1,
      3,
      1.394100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.209299,
      NULL,
      71,
      39,
      50,
      4,
      0.418596,
      3,
      NULL,
      '',
      '',
      0.702643,
      NULL,
      '',
      '',
      2.505062,
      '41132',
      '',
      NULL,
      0,
      21.974342,
      9.388937,
      NULL,
      1,
      9,
      3,
      0,
      0,
      0.497164,
      NULL,
      NULL,
      1.731718,
      NULL,
      NULL,
      0.493517,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.008473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.160218,
      0,
      0,
      NULL,
      NULL,
      0.054232,
      NULL,
      NULL,
      0.472553,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.808161,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.004688,
      2.802989,
      3.930730,
      NULL,
      NULL,
      NULL,
      0.701886,
      NULL,
      NULL,
      3.573497,
      1,
      1,
      1.085985,
      0,
      NULL,
      1,
      NULL,
      0.524137,
      0.017621,
      0,
      NULL,
      1.422054,
      1,
      1,
      1,
      0.646439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.210226,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.048680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028793,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112352,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.377735,
      NULL,
      NULL,
      1.145647,
      3.711706,
      1,
      1,
      3.019448,
      0.412171,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.913642,
      0,
      NULL,
      NULL,
      1.912560,
      NULL,
      0,
      0.947722,
      NULL,
      NULL,
      3.310593,
      0,
      1,
      0,
      3.844911,
      3,
      0,
      NULL,
      1,
      2.515410,
      3.789314,
      2,
      3,
      0,
      3.586239,
      1.809761,
      2,
      1,
      8.773394,
      5.612693,
      1,
      NULL,
      5.919015,
      4,
      1.741427,
      2,
      4,
      0.134487,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.047021,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.804346,
      NULL,
      NULL,
      0.061117,
      NULL,
      NULL,
      0.148365,
      NULL,
      NULL,
      1.875368,
      1.176492,
      0,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.042816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831325,
      0.536771,
      NULL,
      NULL,
      NULL,
      0.904472,
      NULL,
      NULL,
      NULL,
      0.794622,
      NULL,
      NULL,
      0.226742,
      0.096462,
      NULL,
      NULL,
      2,
      2.378412,
      NULL,
      NULL,
      3.848382,
      1.884373,
      NULL,
      NULL,
      3.896700,
      0.818822,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.269282,
      10,
      NULL,
      1.100259,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.287561,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830036,
      NULL,
      0.452605,
      114.049903,
      1,
      1,
      0.798044,
      NULL,
      0.927948,
      1.356131,
      0,
      1.629917,
      0,
      0.456036,
      0,
      1,
      0.996741,
      1.128615,
      NULL,
      0.841144,
      0.729139,
      0,
      0.183113,
      NULL,
      0,
      NULL,
      1.747055,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.272101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.347832,
      0.053011,
      0.121912,
      3,
      2,
      1,
      0,
      0.192831,
      0,
      1.834688,
      1,
      0.206109,
      0,
      0,
      2,
      0.965250,
      1,
      NULL,
      0,
      0,
      0.464705,
      NULL,
      1,
      1.720257,
      0,
      1.272670,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      2.441570,
      0.725905,
      1,
      0.590672,
      0.485187,
      NULL,
      0.798545,
      1,
      NULL,
      3.793242,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.594501,
      NULL,
      NULL,
      4,
      5,
      7,
      1.277012,
      NULL,
      NULL,
      63,
      NULL,
      1,
      NULL,
      2,
      '24344',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2.490367,
      '22341',
      NULL,
      '');
commit;
end;
/


