set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8620424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '0130042',
      0.961271,
      1.723895,
      NULL,
      3,
      '4111',
      NULL,
      0.183055,
      NULL,
      NULL,
      ' 5- 5-1986',
      0,
      NULL,
      4,
      0.336217,
      NULL,
      ' 6- 9-1997',
      NULL,
      0.524170,
      2,
      43,
      3,
      ' 8-16-1981',
      ' 5-18-1984',
      ' 8- 6-1993',
      NULL,
      1,
      2.272262,
      2.935420,
      1.714564,
      NULL,
      2,
      2.208463,
      NULL,
      NULL,
      NULL,
      NULL,
      2.567724,
      3.675783,
      7,
      1,
      14.040161,
      5,
      0,
      NULL,
      1.946866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      1,
      3,
      0,
      5,
      2,
      1,
      1,
      3,
      3,
      2,
      1,
      3,
      1,
      NULL,
      1,
      1,
      0,
      2,
      0.519367,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      5,
      1.700498,
      3.616683,
      NULL,
      1,
      NULL,
      2.064446,
      2.388449,
      NULL,
      1,
      0.166130,
      3.848275,
      1,
      0,
      3.369568,
      1,
      1.859355,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      2.183973,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      3,
      1,
      4,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      0,
      1,
      1,
      2,
      2,
      2,
      2,
      NULL,
      4,
      1,
      1,
      0,
      NULL,
      4,
      NULL,
      5,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      ' 6-25-1977',
      6,
      ' 2- 9-1995',
      0,
      0.698191,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0.562951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.307193,
      2.394580,
      0.537386,
      2,
      1,
      2.044558,
      NULL,
      2.762705,
      0,
      4.176193,
      2,
      NULL,
      1.581076,
      NULL,
      NULL,
      1,
      4,
      1.608638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.439536,
      0,
      1,
      1,
      6.211303,
      2.111619,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.308825,
      2,
      2,
      1,
      NULL,
      1,
      1,
      1,
      0,
      2,
      0,
      0.261847,
      2.483667,
      1,
      3,
      NULL,
      0.198313,
      2,
      NULL,
      0.716270,
      0.698168,
      NULL,
      1,
      1,
      1.624297,
      1,
      0,
      0,
      2,
      0.923967,
      3,
      NULL,
      2.357228,
      1.915450,
      8,
      NULL,
      2.459540,
      0.465832,
      0,
      0.917285,
      NULL,
      3,
      23,
      1,
      1.413991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20021',
      NULL,
      NULL,
      1.272464,
      '',
      '',
      '',
      3.891974,
      NULL,
      '',
      '',
      1.659138,
      49,
      48.823131,
      NULL,
      1,
      NULL,
      7.720775,
      1,
      2,
      1,
      0.481971,
      0,
      1,
      1,
      1,
      NULL,
      0.175498,
      0,
      NULL,
      NULL,
      NULL,
      0.569631,
      NULL,
      NULL,
      1.534382,
      NULL,
      NULL,
      2,
      1.295350,
      0,
      1,
      NULL,
      NULL,
      2,
      3.170040,
      1.664806,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      3.102382,
      1,
      NULL,
      1.557066,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.729169,
      1.770077,
      2,
      NULL,
      0.244900,
      1.670662,
      0,
      NULL,
      NULL,
      1.291534,
      NULL,
      1,
      3,
      0,
      2.614204,
      1.070330,
      1.057347,
      0,
      3.522629,
      2,
      NULL,
      1.002670,
      1.344027,
      0.599495,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      1,
      1.435584,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.148981,
      NULL,
      NULL,
      3.437541,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.596528,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      0.011559,
      1.046938,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.110392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217137,
      1,
      0.077943,
      0,
      1.696306,
      1.068225,
      3,
      0,
      4.517213,
      4,
      7.539585,
      4.238194,
      1.322424,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.115528,
      1,
      1.373772,
      0.183318,
      NULL,
      0.995031,
      2.216853,
      2.744484,
      4.159131,
      1,
      2,
      0.306335,
      NULL,
      0,
      0.287916,
      2.575857,
      3,
      0,
      NULL,
      2.525975,
      1.050426,
      8,
      NULL,
      4.125207,
      0,
      0,
      3.179013,
      2.818415,
      1,
      NULL,
      0,
      1,
      1,
      1.015477,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834493,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.923711,
      NULL,
      NULL,
      0.466254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649291,
      NULL,
      NULL,
      0,
      0.141824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.555356,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508293,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.277346,
      NULL,
      NULL,
      NULL,
      3.434155,
      0,
      NULL,
      NULL,
      1.044305,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.223817,
      NULL,
      NULL,
      NULL,
      0.684582,
      NULL,
      NULL,
      NULL,
      5.359567,
      NULL,
      NULL,
      NULL,
      2.609795,
      0.661635,
      NULL,
      0,
      1.785612,
      NULL,
      2.607773,
      2.292629,
      8.219978,
      2.871144,
      1.486985,
      NULL,
      NULL,
      1.772769,
      1,
      0,
      1,
      NULL,
      NULL,
      1.988032,
      NULL,
      NULL,
      1.987161,
      NULL,
      1,
      NULL,
      4.619751,
      1.348577,
      NULL,
      1.473131,
      3.396997,
      1,
      0,
      1.531245,
      2,
      1.777659,
      1,
      1,
      2,
      1.329829,
      3,
      1.472756,
      1.489825,
      1,
      3.387803,
      NULL,
      1.767248,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.599385,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      5,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0,
      2,
      0.633366,
      3.516318,
      0.974199,
      0,
      0,
      NULL,
      1,
      2.085283,
      0.426582,
      1,
      NULL,
      1.122943,
      NULL,
      NULL,
      0,
      1,
      2.657622,
      0,
      0.385247,
      1.405774,
      NULL,
      1,
      0,
      1.716152,
      0.885326,
      2.811921,
      1.206539,
      1,
      1.915953,
      0,
      NULL,
      3.748557,
      NULL,
      0.177436,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.977245,
      0,
      0,
      NULL,
      1,
      4,
      1.945637,
      NULL,
      NULL,
      39,
      58.167068,
      5,
      0,
      1.797096,
      '03230',
      '',
      '',
      1,
      '',
      '',
      '',
      3.354255,
      '22211',
      '',
      '');
commit;
end;
/


