set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      3.827303,
      NULL,
      NULL,
      NULL,
      ' 3-26-1992',
      20.373393,
      NULL,
      3,
      NULL,
      NULL,
      ' 2-11-1981',
      10,
      2.648916,
      152,
      4.220354,
      1,
      NULL,
      NULL,
      '10-22-1980',
      1.335762,
      0.662867,
      1.448389,
      1.988136,
      1.816475,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      4.198362,
      NULL,
      NULL,
      3.328091,
      5,
      NULL,
      2,
      NULL,
      6.298602,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      0.936175,
      0,
      1,
      NULL,
      NULL,
      2,
      4,
      NULL,
      2,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      3,
      1,
      NULL,
      9.835891,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      2.802069,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.225279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.767284,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      2,
      2,
      1,
      2,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      0,
      1,
      3,
      3,
      2,
      4,
      0,
      2,
      2,
      ' 4- 7-1988',
      NULL,
      ' 8- 1-1985',
      8,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      2,
      NULL,
      0,
      1,
      1,
      NULL,
      0.330635,
      1,
      2,
      2,
      1.994747,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.002769,
      NULL,
      3.928565,
      3.285060,
      5,
      0,
      NULL,
      NULL,
      1.513718,
      7.325082,
      0,
      NULL,
      2,
      2,
      0.997996,
      ' 9-28-1993',
      2.667154,
      ' 9-10-1992',
      4,
      2.149755,
      0,
      1.417738,
      0,
      0,
      NULL,
      NULL,
      1.357327,
      0,
      1.409187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.064045,
      3,
      3,
      3,
      3,
      2,
      2,
      3,
      0,
      3,
      3,
      3.865072,
      2.121976,
      1,
      2,
      1,
      NULL,
      11.678148,
      1,
      1,
      0.624046,
      NULL,
      1,
      0.896326,
      1,
      1.640382,
      1,
      1.679629,
      3.306609,
      0.261947,
      3,
      NULL,
      7.368182,
      8,
      0,
      4.703657,
      3,
      0.261579,
      5,
      2.436466,
      1,
      1.503931,
      42,
      0,
      0.515670,
      19,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.161765,
      '41002',
      '',
      '',
      0.697647,
      '',
      NULL,
      '',
      1.510375,
      NULL,
      '',
      '',
      1.830920,
      31,
      9,
      NULL,
      2,
      20,
      3.869785,
      3.235650,
      4,
      1.969398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.454967,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.387013,
      NULL,
      NULL,
      1.249341,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.310926,
      0.837648,
      1,
      1,
      3,
      1,
      10,
      8,
      0,
      2,
      0.686667,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      18,
      1.504654,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1,
      0.163286,
      1.506982,
      1.083870,
      3.215324,
      1.509506,
      NULL,
      0.017257,
      3,
      0,
      2.521689,
      1.684120,
      0.376549,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.451291,
      NULL,
      NULL,
      NULL,
      4,
      2.199269,
      NULL,
      0.834167,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311961,
      NULL,
      8.999143,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.135556,
      NULL,
      0.818291,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.423546,
      NULL,
      NULL,
      0,
      0,
      0,
      2.717133,
      NULL,
      4,
      0.235146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626846,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.607695,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.270655,
      NULL,
      3.169724,
      2.061900,
      2.870066,
      3.823281,
      6,
      0.700845,
      1,
      3,
      5,
      5.664946,
      NULL,
      NULL,
      NULL,
      1.478035,
      NULL,
      NULL,
      2,
      3.018492,
      2.613418,
      1.510535,
      2,
      1.325199,
      NULL,
      NULL,
      NULL,
      1.395279,
      2.173239,
      1,
      1,
      2,
      2.140189,
      1.480976,
      NULL,
      2,
      NULL,
      NULL,
      0.019381,
      NULL,
      NULL,
      NULL,
      NULL,
      4.268724,
      4.441499,
      1.314548,
      NULL,
      4,
      1.334254,
      0,
      1,
      1,
      0.432927,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.388302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.707820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.631523,
      NULL,
      NULL,
      1.537982,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.388857,
      0,
      0,
      1.465725,
      NULL,
      9.048419,
      NULL,
      NULL,
      NULL,
      3.503597,
      NULL,
      NULL,
      NULL,
      2.263811,
      NULL,
      NULL,
      NULL,
      1.241362,
      NULL,
      NULL,
      NULL,
      1.425528,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.605225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.356618,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.847563,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.650702,
      NULL,
      NULL,
      NULL,
      1.005877,
      NULL,
      NULL,
      NULL,
      3.798081,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      0,
      0.617443,
      NULL,
      NULL,
      NULL,
      2,
      3.749059,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      163,
      0,
      1.720355,
      0.071861,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.942169,
      1,
      1.184493,
      0,
      1,
      1,
      1,
      0.798217,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      1,
      0.549258,
      0.243605,
      0,
      5,
      NULL,
      0,
      0,
      1,
      0.431515,
      NULL,
      0.353952,
      0.778171,
      NULL,
      1,
      1.315829,
      NULL,
      NULL,
      3.002636,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.502084,
      NULL,
      0.272438,
      0.220316,
      NULL,
      0,
      1.754565,
      NULL,
      0,
      0,
      NULL,
      0,
      0.346726,
      NULL,
      3.188839,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.916483,
      NULL,
      1,
      0,
      NULL,
      0.707601,
      NULL,
      NULL,
      11,
      NULL,
      2,
      0,
      3.503823,
      '10421',
      '',
      '',
      0.133326,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


