set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '2344123',
      0,
      0,
      NULL,
      1,
      '0001',
      1,
      1.929562,
      NULL,
      NULL,
      ' 3-13-1980',
      41.677662,
      NULL,
      1,
      3.795659,
      3,
      ' 9- 7-1996',
      2.757108,
      2.510375,
      212,
      28.702308,
      0,
      NULL,
      NULL,
      ' 7-10-1988',
      0.565337,
      0,
      0,
      0.200003,
      1.732772,
      1.534902,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      11.934972,
      4,
      7,
      NULL,
      2,
      5,
      NULL,
      2,
      5,
      0.016725,
      1,
      0,
      NULL,
      1.097186,
      0,
      NULL,
      0.901294,
      NULL,
      1.327797,
      0,
      3,
      1,
      1,
      2,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      1,
      0.974055,
      NULL,
      NULL,
      1.104247,
      NULL,
      NULL,
      3,
      0,
      1.940351,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      4,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      7,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      4,
      3,
      4,
      3,
      4,
      4,
      4,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      5,
      2,
      4,
      0,
      5,
      1,
      5,
      NULL,
      2.094143,
      ' 4- 5-2003',
      11,
      ' 3-27-1976',
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1.436105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.509989,
      NULL,
      0,
      1.083386,
      1,
      1,
      0.602648,
      0,
      NULL,
      1.401812,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3.799453,
      4,
      0,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      0.137969,
      NULL,
      1,
      1.625406,
      NULL,
      NULL,
      3.494339,
      0.598291,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      NULL,
      3,
      2,
      2,
      1,
      0,
      NULL,
      1,
      3,
      3.980768,
      0,
      2.488826,
      2.093846,
      0.284437,
      NULL,
      6,
      1,
      1.150484,
      NULL,
      0,
      0.145179,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      NULL,
      NULL,
      0,
      0.811126,
      NULL,
      '04004',
      NULL,
      '',
      1.375867,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      NULL,
      7.714092,
      NULL,
      NULL,
      29,
      2,
      3.072993,
      NULL,
      0.850947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.768954,
      1,
      NULL,
      NULL,
      NULL,
      3.949284,
      1.558983,
      2,
      NULL,
      1,
      2.150731,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      17.710771,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.162277,
      2.086726,
      5,
      1,
      0.779663,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.631070,
      1,
      1.101731,
      NULL,
      NULL,
      1.189828,
      NULL,
      NULL,
      NULL,
      0.276714,
      0.483598,
      NULL,
      0,
      1.994350,
      1.897289,
      1,
      1.930476,
      2.363904,
      NULL,
      0,
      1,
      0,
      NULL,
      0.608143,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      8,
      0.948710,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.661810,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.332565,
      1.336023,
      2.942559,
      NULL,
      NULL,
      NULL,
      1.954211,
      0,
      3,
      0.676643,
      1,
      3.365648,
      1,
      0,
      3,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.858608,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      2,
      6,
      1.410613,
      6.935125,
      5.462895,
      3,
      1.104096,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.720570,
      0.475166,
      NULL,
      3,
      NULL,
      0.862977,
      NULL,
      2.184143,
      5.909823,
      0.975001,
      3,
      0.835853,
      1,
      NULL,
      NULL,
      0.878590,
      0,
      NULL,
      3,
      2.509190,
      3.278410,
      NULL,
      9,
      NULL,
      2.490893,
      1.217464,
      0.599876,
      0.153155,
      4,
      1,
      1.365638,
      0,
      0.243654,
      0.430849,
      NULL,
      3,
      NULL,
      NULL,
      1.966206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.024399,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.678124,
      NULL,
      NULL,
      0.987534,
      0,
      NULL,
      1.184007,
      1.292892,
      NULL,
      2,
      NULL,
      NULL,
      0.552070,
      3,
      NULL,
      NULL,
      8,
      2.666122,
      NULL,
      NULL,
      2,
      1.121008,
      NULL,
      NULL,
      1,
      0.010783,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.404959,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.798839,
      0.649032,
      NULL,
      NULL,
      0,
      0.824254,
      NULL,
      NULL,
      0,
      0.765347,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.703719,
      NULL,
      NULL,
      NULL,
      1,
      3.891931,
      NULL,
      NULL,
      0.151826,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.192643,
      2.007506,
      NULL,
      NULL,
      10,
      0,
      NULL,
      NULL,
      13,
      3,
      NULL,
      NULL,
      0.521596,
      NULL,
      NULL,
      NULL,
      2.521268,
      0.953532,
      NULL,
      NULL,
      2.997157,
      NULL,
      0.569935,
      NULL,
      NULL,
      1.557358,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.907505,
      6893,
      0,
      0,
      1,
      0,
      NULL,
      0.387940,
      1,
      1.891643,
      1.619868,
      1.959892,
      1,
      0.074499,
      0.999167,
      0,
      1.576436,
      0,
      1.445142,
      NULL,
      1.862244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.075509,
      NULL,
      0,
      NULL,
      0,
      1,
      2.523525,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0.818833,
      0,
      0,
      NULL,
      0.779023,
      0,
      2.178132,
      1.492868,
      3,
      0.669234,
      0,
      NULL,
      2,
      1,
      1,
      1,
      1.103723,
      1.184663,
      1.851605,
      0.861684,
      1.238526,
      1,
      0,
      3,
      NULL,
      0,
      0.229029,
      3.815863,
      2,
      1.345829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612390,
      0,
      1.093992,
      NULL,
      1.822282,
      NULL,
      0,
      NULL,
      0.091208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.403680,
      NULL,
      1.102808,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.654865,
      NULL,
      0.231997,
      NULL,
      NULL,
      33,
      0,
      NULL,
      1.162706,
      1,
      1.525217,
      1,
      0.556706,
      0.908281,
      NULL,
      0,
      NULL,
      1.252952,
      NULL,
      NULL,
      109,
      28.625204,
      NULL,
      0.068894,
      1.736311,
      '24142',
      '',
      '',
      1.681204,
      '',
      '',
      '',
      0.831686,
      '',
      '',
      '');
commit;
end;
/


