set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      3.808989,
      0,
      5,
      0,
      '0441',
      3,
      1,
      NULL,
      NULL,
      NULL,
      24.940260,
      NULL,
      0,
      0.933804,
      6.091714,
      ' 2-21-1988',
      7.205869,
      1.827232,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 4-10-1984',
      1,
      0,
      1,
      NULL,
      0.173288,
      3.747593,
      0,
      1.275691,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      14.836747,
      2,
      19.156277,
      0,
      1,
      NULL,
      0,
      3,
      1,
      NULL,
      1.205651,
      NULL,
      1,
      0,
      NULL,
      0,
      1.924749,
      0,
      5,
      2,
      3.717618,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      4,
      1,
      1,
      2,
      4,
      7.157292,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      1.936727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.675452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      3,
      0,
      5,
      0,
      0,
      2,
      NULL,
      0.229549,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0.852186,
      NULL,
      1,
      1,
      1,
      4,
      3,
      3,
      4,
      2,
      1,
      4,
      NULL,
      NULL,
      0,
      0,
      4,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      0,
      3,
      0,
      1,
      1.921968,
      ' 1-19-2002',
      30.375493,
      ' 0-18-1998',
      3,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      3,
      0,
      1.308387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      18,
      2.467675,
      NULL,
      2,
      1,
      1.630425,
      0.903314,
      1.281145,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5.852101,
      NULL,
      1.013136,
      7,
      3,
      8.025347,
      NULL,
      1.923383,
      NULL,
      NULL,
      NULL,
      3.211268,
      NULL,
      0,
      4,
      3,
      NULL,
      ' 4-13-2002',
      NULL,
      ' 3-10-1994',
      14.745786,
      1,
      0,
      1.318244,
      1.574101,
      1.904267,
      0,
      NULL,
      0,
      0,
      0,
      1.565985,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.595630,
      2,
      2,
      1,
      1,
      1,
      3,
      0,
      1,
      2,
      0,
      1,
      2,
      3,
      3,
      0,
      NULL,
      5.676473,
      1.657345,
      NULL,
      0.676755,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0.640866,
      0,
      1.612871,
      6.152927,
      0,
      NULL,
      7,
      5,
      6,
      1,
      3.457461,
      2,
      0,
      2,
      2.290023,
      56.529091,
      2,
      0,
      23,
      NULL,
      NULL,
      NULL,
      4,
      1.819973,
      2,
      '20142',
      '',
      NULL,
      0.327530,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      30.532888,
      1,
      NULL,
      2,
      1.917021,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.040729,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      2,
      1.835750,
      0,
      NULL,
      NULL,
      1.309990,
      3.153138,
      1.548369,
      1.052332,
      3.808847,
      2.536499,
      1.389729,
      NULL,
      3,
      0,
      1.297384,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      1.012960,
      16,
      2.567387,
      0,
      1.276742,
      1.368806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.831003,
      NULL,
      0,
      3.414503,
      3.840201,
      1.745731,
      1.978752,
      1,
      0,
      3.405558,
      1.412704,
      NULL,
      0.370825,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000451,
      NULL,
      NULL,
      3,
      7,
      1.427948,
      0,
      1.110610,
      NULL,
      NULL,
      NULL,
      1.360549,
      1,
      1.151451,
      7,
      0.420006,
      NULL,
      NULL,
      0.842464,
      NULL,
      NULL,
      2.759786,
      1.992256,
      1.373783,
      19,
      NULL,
      NULL,
      0,
      3.272726,
      1.991239,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      5,
      4.868199,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610539,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.916695,
      NULL,
      NULL,
      2.961330,
      0.480549,
      2,
      1,
      1,
      2.055926,
      1,
      6.656296,
      4.021766,
      4,
      NULL,
      6.502415,
      0.966782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3,
      3,
      2.300268,
      7.960621,
      NULL,
      NULL,
      2,
      3.272689,
      1.618288,
      2,
      1.597220,
      NULL,
      2.882141,
      1.468005,
      1,
      NULL,
      2,
      NULL,
      NULL,
      6,
      1.610933,
      7.913156,
      NULL,
      2.413575,
      2.286644,
      4,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.928042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.512672,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.916597,
      NULL,
      NULL,
      0.336770,
      NULL,
      NULL,
      1.413515,
      NULL,
      NULL,
      2.137025,
      NULL,
      NULL,
      0,
      NULL,
      3.100120,
      1,
      2,
      1.236481,
      1.714806,
      NULL,
      0.025925,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.135942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.361616,
      NULL,
      NULL,
      NULL,
      0.082046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.139225,
      NULL,
      NULL,
      NULL,
      0.271268,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.181038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4.518471,
      1.033331,
      2.037401,
      2.134819,
      1.134034,
      1,
      NULL,
      NULL,
      1.557940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.000400,
      NULL,
      NULL,
      104,
      1.919532,
      1,
      0,
      0.864636,
      1,
      1.463866,
      0.249944,
      1,
      1,
      1.888125,
      NULL,
      NULL,
      1,
      1.164415,
      1.484131,
      0,
      1,
      NULL,
      0.813437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      1.443896,
      0.002894,
      NULL,
      4.205178,
      3.429380,
      NULL,
      NULL,
      0.779513,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.893276,
      0,
      NULL,
      1,
      1,
      NULL,
      1.039170,
      1.103585,
      NULL,
      NULL,
      1,
      NULL,
      1.661763,
      1.438395,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      83,
      1,
      1.342076,
      NULL,
      '41340',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.548832,
      NULL,
      '',
      '');
commit;
end;
/


