set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '1211331',
      1,
      NULL,
      1,
      0,
      '2141',
      NULL,
      3.938836,
      0,
      48.121882,
      ' 8- 5-1975',
      16,
      NULL,
      3,
      3.812345,
      1,
      ' 0-23-1995',
      53,
      NULL,
      1.872456,
      118.152612,
      NULL,
      NULL,
      NULL,
      ' 3-10-1983',
      0.905438,
      NULL,
      0.096822,
      0.667765,
      1,
      1,
      NULL,
      0.406676,
      NULL,
      208.064174,
      NULL,
      12.524011,
      0,
      31,
      6.191069,
      2,
      3.076619,
      2,
      NULL,
      11.551487,
      NULL,
      0,
      NULL,
      NULL,
      0.732876,
      0.604302,
      0.279066,
      0.834435,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.683998,
      NULL,
      NULL,
      5,
      1,
      1.515831,
      3,
      NULL,
      2,
      0.806469,
      1.486801,
      3.285666,
      1.179830,
      3,
      NULL,
      0,
      NULL,
      1,
      0,
      3.742537,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      1,
      1,
      4,
      1.846175,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0,
      1,
      4,
      1,
      NULL,
      NULL,
      1,
      2,
      1,
      7,
      0,
      1,
      0,
      1,
      1.306004,
      NULL,
      1.733126,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      4,
      0,
      2,
      NULL,
      4,
      0,
      4,
      2,
      5,
      5.657698,
      3.129627,
      NULL,
      827,
      ' 8-16-1984',
      427.545486,
      1.173477,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      8,
      2,
      1.687093,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.139472,
      0.490815,
      NULL,
      NULL,
      NULL,
      0.414255,
      0.684410,
      NULL,
      3.555538,
      0,
      0.335852,
      NULL,
      0,
      NULL,
      NULL,
      1.426396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.611248,
      0,
      0.770510,
      0,
      1,
      NULL,
      0.552378,
      NULL,
      2.247846,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.318153,
      3,
      2,
      1,
      0,
      3,
      2,
      0,
      2,
      3,
      1,
      NULL,
      0,
      3,
      0.332136,
      0.843362,
      1,
      4.008654,
      NULL,
      1,
      1,
      1,
      1.512552,
      0.613861,
      0,
      0,
      NULL,
      0,
      2.793185,
      0.191234,
      1,
      9.022124,
      5,
      0.446645,
      10,
      0.425191,
      2.414046,
      0.358869,
      NULL,
      3,
      0.520308,
      3.638912,
      61.177921,
      3,
      0.565701,
      31,
      NULL,
      NULL,
      NULL,
      5,
      1.753127,
      NULL,
      '43011',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.388440,
      '',
      NULL,
      '',
      3.657226,
      19.763665,
      194,
      12,
      3,
      15,
      NULL,
      4.334775,
      1,
      0,
      2.752580,
      2.292150,
      3,
      1,
      0.341918,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.994123,
      1.750114,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      0.005779,
      NULL,
      NULL,
      NULL,
      1.246658,
      NULL,
      NULL,
      3,
      2,
      0.122089,
      2.921503,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779525,
      0,
      1.004029,
      1,
      3,
      1.344354,
      0.103189,
      NULL,
      2,
      1.323806,
      0.602094,
      0.178788,
      NULL,
      0,
      1.606788,
      2,
      1.912832,
      0,
      2,
      3.912659,
      NULL,
      NULL,
      0.403740,
      NULL,
      1,
      0,
      NULL,
      2.368749,
      2.927104,
      1,
      1,
      1,
      1,
      1.452623,
      3.589747,
      0,
      3,
      NULL,
      5.231363,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2.427798,
      NULL,
      NULL,
      NULL,
      1.630543,
      NULL,
      NULL,
      NULL,
      NULL,
      0.194327,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.115230,
      0,
      1.935120,
      NULL,
      NULL,
      1,
      2.841885,
      0,
      0,
      3,
      3.473809,
      1.465504,
      1.855870,
      NULL,
      NULL,
      0.172385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.679217,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.575042,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0.710543,
      0.090632,
      1.870338,
      0,
      0.547926,
      2,
      NULL,
      0,
      3,
      0.926465,
      2.911559,
      NULL,
      1,
      3.096943,
      1,
      1,
      1.222210,
      0.064386,
      NULL,
      NULL,
      0.075842,
      2.113148,
      0,
      3.439865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      9.564684,
      3.424768,
      0,
      0,
      0,
      1,
      0,
      0.863723,
      NULL,
      1.838494,
      NULL,
      NULL,
      NULL,
      0.064959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.698120,
      NULL,
      NULL,
      3.353204,
      NULL,
      NULL,
      1.234479,
      NULL,
      NULL,
      5.033285,
      NULL,
      NULL,
      2.888519,
      2,
      1.994223,
      3.594190,
      NULL,
      3.730266,
      1.253226,
      NULL,
      NULL,
      3.991494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.325193,
      NULL,
      2.728441,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.255582,
      NULL,
      2,
      NULL,
      3.565687,
      NULL,
      1.481099,
      NULL,
      2.541612,
      NULL,
      1,
      NULL,
      0.367068,
      NULL,
      NULL,
      NULL,
      0.273077,
      NULL,
      NULL,
      NULL,
      1.142430,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.282780,
      NULL,
      NULL,
      NULL,
      1.387609,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0.272462,
      NULL,
      13.860128,
      NULL,
      7.908913,
      NULL,
      3.428907,
      NULL,
      1,
      5,
      NULL,
      5,
      1.172170,
      70,
      1,
      3,
      14.754858,
      2.597698,
      0.609823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063574,
      NULL,
      1,
      384,
      0.861861,
      1.642952,
      1.269031,
      0.075237,
      0,
      0.589727,
      1,
      0,
      2,
      1,
      1.127634,
      0.910131,
      NULL,
      0,
      0.827203,
      1,
      1,
      1,
      0.912005,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.102747,
      NULL,
      2,
      NULL,
      12,
      NULL,
      0,
      32.154554,
      35,
      NULL,
      0.917953,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.585174,
      NULL,
      1.236159,
      NULL,
      0,
      NULL,
      0.591477,
      NULL,
      NULL,
      NULL,
      0.828583,
      NULL,
      1,
      NULL,
      0.978346,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.561263,
      3.605400,
      1.096410,
      1.796976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.230788,
      1,
      NULL,
      3.386897,
      NULL,
      2.323229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.916686,
      NULL,
      0,
      NULL,
      3,
      0.010068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.331418,
      NULL,
      3,
      NULL,
      3.377136,
      NULL,
      106,
      NULL,
      3,
      1.580900,
      3,
      NULL,
      2.422353,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.671084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049837,
      36.111821,
      29,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      6,
      4,
      4.307637,
      3,
      2,
      5,
      0.551793,
      0,
      2,
      1,
      1,
      1.487501,
      0.734378,
      1,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      2,
      0.339211,
      1,
      2.233219,
      1,
      NULL,
      0.274834,
      0.018992,
      0.306484,
      NULL,
      2.371229,
      NULL,
      1,
      NULL,
      0.949070,
      3.677655,
      0,
      0.216477,
      1,
      1.348311,
      0.398445,
      0.849413,
      NULL,
      1.339407,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.912922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.518572,
      1.658353,
      NULL,
      6,
      4,
      NULL,
      0.337496,
      NULL,
      26,
      12.026695,
      3,
      NULL,
      4.978218,
      '14232',
      '13133',
      '40041',
      1,
      NULL,
      '',
      NULL,
      0,
      '323',
      '3300',
      '1340');
commit;
end;
/


