set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4011710';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.151573,
      1.017906,
      NULL,
      NULL,
      ' 5-16-1992',
      64.974648,
      NULL,
      5,
      2.018453,
      0.558631,
      '10- 5-1984',
      65.726915,
      5,
      303.895630,
      61,
      1,
      ' 3-22-1999',
      ' 8-14-1993',
      ' 3- 3-1987',
      NULL,
      NULL,
      1,
      0.433782,
      1.688730,
      2,
      NULL,
      1.565268,
      1.877359,
      63,
      NULL,
      11.031961,
      1.264912,
      92.410741,
      NULL,
      1,
      10,
      NULL,
      5,
      9.999622,
      0.526374,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1.116203,
      0.342791,
      1.332481,
      147.526949,
      NULL,
      6,
      7,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.080144,
      0.997464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      4,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1.308019,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      0,
      5,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      2,
      3,
      3,
      0,
      2,
      3,
      NULL,
      2,
      4,
      5,
      7.710029,
      0.935119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418631,
      NULL,
      1.222062,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490095,
      0.282212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717612,
      NULL,
      NULL,
      0.156531,
      1.755550,
      2.088452,
      10803,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      2,
      3,
      0,
      3,
      NULL,
      NULL,
      3,
      0.671695,
      4,
      2.321960,
      91,
      NULL,
      1.053969,
      NULL,
      135.211893,
      50.955604,
      187,
      36,
      99,
      139.129920,
      34.277008,
      27.978023,
      0,
      9.187810,
      12.969772,
      1,
      1,
      0,
      6,
      1.987605,
      1,
      4.826533,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      37.267528,
      3,
      0.972308,
      NULL,
      33,
      NULL,
      NULL,
      1,
      NULL,
      1.354210,
      '44330',
      '',
      NULL,
      3.813163,
      '41322',
      '',
      '',
      5,
      '44212',
      '12034',
      '',
      3,
      19.178693,
      830.026392,
      0,
      1.496216,
      17,
      6,
      234.761139,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625157,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.753150,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.578072,
      NULL,
      NULL,
      1.562872,
      NULL,
      NULL,
      1.862262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.148571,
      1,
      NULL,
      1,
      NULL,
      NULL,
      6.483521,
      4,
      NULL,
      NULL,
      3.360240,
      1,
      0.624859,
      NULL,
      NULL,
      5.079724,
      0.022189,
      4.973451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.784461,
      1,
      NULL,
      4.565345,
      2,
      2.026292,
      1.172686,
      NULL,
      NULL,
      1,
      2.750935,
      0,
      1,
      NULL,
      NULL,
      2,
      1.838760,
      3.509651,
      3,
      NULL,
      NULL,
      NULL,
      3.909767,
      1,
      1,
      NULL,
      NULL,
      0.997891,
      NULL,
      NULL,
      1.420917,
      0.966582,
      0,
      1.294472,
      1.906936,
      3,
      3,
      4,
      4,
      5,
      0,
      7.720518,
      NULL,
      NULL,
      NULL,
      1.175914,
      0.101453,
      0.686486,
      1,
      1.612810,
      1.472542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.793177,
      NULL,
      1.438563,
      1.031449,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      51,
      0,
      NULL,
      NULL,
      1.611913,
      NULL,
      NULL,
      3.701190,
      96,
      0,
      NULL,
      NULL,
      NULL,
      0,
      10.501305,
      29.626622,
      1,
      210.463479,
      NULL,
      NULL,
      9.330142,
      0,
      0.621790,
      1.585447,
      1,
      0,
      1.522728,
      1,
      NULL,
      1,
      NULL,
      1,
      1.207464,
      1.702430,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.026706,
      0.881777,
      0,
      4.211757,
      2,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.587946,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.502648,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.995012,
      NULL,
      NULL,
      1.955858,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.803354,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536172,
      NULL,
      0.654366,
      NULL,
      0,
      NULL,
      NULL,
      6,
      2,
      0,
      NULL,
      1.449127,
      32,
      60.600638,
      1,
      0,
      0.272337,
      '02143',
      NULL,
      '',
      2,
      '33300',
      '',
      '',
      1.073215,
      '33123',
      '30032',
      '');
commit;
end;
/


